/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.tooltipscroll;

import com.google.gson.stream.JsonReader;
import com.provismet.lilylib.util.JsonBuilder;
import com.provismet.tooltipscroll.ScrollTracker;
import com.provismet.tooltipscroll.TooltipScrollClient;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.minecraft.class_3532;

public abstract class Options {
    public static boolean canScroll = true;
    public static boolean useWASD = false;
    public static boolean startOnTop = false;
    public static boolean resetOnUnlock = true;
    public static boolean useLShift = true;
    public static boolean invertXScroll = false;
    public static boolean invertYScroll = false;
    public static boolean matrixMode = false;
    private static final String CAN_SCROLL = "canScroll";
    private static final String USE_WASD = "useWASD";
    private static final String START_ON_TOP = "startOnTop";
    private static final String RESET_ON_UNLOCK = "resetOnUnlock";
    private static final String USE_LEFT_SHIFT = "useLShift";
    private static final String INVERT_X_SCROLL = "invertXScroll";
    private static final String INVERT_Y_SCROLL = "invertYScroll";
    private static final String SCROLL_SPEED = "scrollSpeed";
    private static final String SCROLL_SPEED_KEYBOARD = "keyboardScrollSpeed";
    private static final String SMOOTHNESS = "scrollSmoothness";
    private static final String MATRIX_COMPAT = "matrixCompatibilityMode";

    public static void saveJSON() {
        JsonBuilder builder = new JsonBuilder();
        String json = builder.start().append(CAN_SCROLL, canScroll).newLine().append(USE_WASD, useWASD).newLine().append(START_ON_TOP, startOnTop).newLine().append(RESET_ON_UNLOCK, resetOnUnlock).newLine().append(USE_LEFT_SHIFT, useLShift).newLine().append(INVERT_X_SCROLL, invertXScroll).newLine().append(INVERT_Y_SCROLL, invertYScroll).newLine().append(SCROLL_SPEED, ScrollTracker.scrollSize).newLine().append(SCROLL_SPEED_KEYBOARD, ScrollTracker.scrollSizeKeyboard).newLine().append(SMOOTHNESS, ScrollTracker.smoothnessModifier).newLine().append(MATRIX_COMPAT, matrixMode).newLine(false).closeObject().toString();
        try (FileWriter writer = new FileWriter("config/tooltipscroll.json");){
            writer.write(json);
        }
        catch (Exception e) {
            TooltipScrollClient.LOGGER.error("Encountered error whilst trying to save config JSON.", (Throwable)e);
        }
    }

    public static void readJSON() {
        try {
            FileReader reader = new FileReader("config/tooltipscroll.json");
            JsonReader parser = new JsonReader((Reader)reader);
            parser.beginObject();
            while (parser.hasNext()) {
                String label;
                switch (label = parser.nextName()) {
                    case "canScroll": {
                        canScroll = parser.nextBoolean();
                        break;
                    }
                    case "useWASD": {
                        useWASD = parser.nextBoolean();
                        break;
                    }
                    case "startOnTop": {
                        startOnTop = parser.nextBoolean();
                        break;
                    }
                    case "resetOnUnlock": {
                        resetOnUnlock = parser.nextBoolean();
                        break;
                    }
                    case "useLShift": {
                        useLShift = parser.nextBoolean();
                        break;
                    }
                    case "invertXScroll": {
                        invertXScroll = parser.nextBoolean();
                        break;
                    }
                    case "invertYScroll": {
                        invertYScroll = parser.nextBoolean();
                        break;
                    }
                    case "scrollSpeed": {
                        ScrollTracker.scrollSize = (int)class_3532.method_15391((double)1.0, (double)parser.nextInt());
                        break;
                    }
                    case "keyboardScrollSpeed": {
                        ScrollTracker.scrollSizeKeyboard = (int)class_3532.method_15391((double)1.0, (double)parser.nextInt());
                        break;
                    }
                    case "scrollSmoothness": {
                        ScrollTracker.smoothnessModifier = class_3532.method_15391((double)0.05, (double)parser.nextDouble());
                        if (!(ScrollTracker.smoothnessModifier > 1.0)) break;
                        ScrollTracker.smoothnessModifier = 1.0;
                        break;
                    }
                    case "matrixCompatibilityMode": {
                        matrixMode = parser.nextBoolean();
                        break;
                    }
                }
            }
            parser.close();
        }
        catch (FileNotFoundException e) {
            try {
                new File("config").mkdirs();
                Options.saveJSON();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

