package com.provismet.tooltipscroll;

import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_5683;
import net.minecraft.class_5684;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.lwjgl.glfw.GLFW;

import com.provismet.tooltipscroll.mixin.KeyBindAccessor;
import com.provismet.tooltipscroll.mixin.OrderedTextTooltipComponentAccessor;

public class ScrollTracker {
    // render functions are called every frame, so the offset needs to be saved somewhere
    private static double currentXOffset = 0;
    private static double currentYOffset = 0;

    private static double trueXOffset = 0;
    private static double trueYOffset = 0;

		private static boolean moved = false;
    
    // save the currently selected item, the scroll offset will reset if the user hovers over a different item
    private static List<class_5684> currentItem;

    private static long unlockTime = System.currentTimeMillis();
    private static final long RELOCK_AT = 100;
    
    public static int scrollSize = 10;
    public static int scrollSizeKeyboard = 5;
    public static double smoothnessModifier = 0.25;

    public static void update () {
        currentXOffset += (trueXOffset - currentXOffset) * smoothnessModifier;
        currentYOffset += (trueYOffset - currentYOffset) * smoothnessModifier;

        class_1041 window = class_310.method_1551().method_22683();

		// An unbound key has a code of -1.
		int up = ((KeyBindAccessor)TooltipScrollClient.moveUp).getBoundKey().method_1444();
		int down = ((KeyBindAccessor)TooltipScrollClient.moveDown).getBoundKey().method_1444();
		int horizontal = ((KeyBindAccessor)TooltipScrollClient.horizontal).getBoundKey().method_1444();
		int reset = ((KeyBindAccessor)TooltipScrollClient.reset).getBoundKey().method_1444();

		if (Options.useWASD) {
			if (class_3675.method_15987(window, GLFW.GLFW_KEY_W)) {
				ScrollTracker.scrollUp(scrollSizeKeyboard);
			}
			else if (class_3675.method_15987(window, GLFW.GLFW_KEY_S)) {
				ScrollTracker.scrollDown(scrollSizeKeyboard);
			}

			if (class_3675.method_15987(window, GLFW.GLFW_KEY_A)) {
				ScrollTracker.scrollLeft(scrollSizeKeyboard);
			}
			else if (class_3675.method_15987(window, GLFW.GLFW_KEY_D)) {
				ScrollTracker.scrollRight(scrollSizeKeyboard);
			}
		}

		// Check for -1 codes first.
		// They don't cause Exceptions, but they do create a messy block of errors on the render thread when logging.
		if (up != -1 && class_3675.method_15987(window, up)) {
			if ((horizontal != -1 && class_3675.method_15987(window, horizontal)) || (Options.useLShift && class_3675.method_15987(window, GLFW.GLFW_KEY_LEFT_SHIFT))) {
				ScrollTracker.scrollLeft(scrollSizeKeyboard);
			}
			else {
				ScrollTracker.scrollUp(scrollSizeKeyboard);
			}
		}
		else if (down != -1 && class_3675.method_15987(window, down)) {
			if ((horizontal != -1 && class_3675.method_15987(window, horizontal)) || (Options.useLShift && class_3675.method_15987(window, GLFW.GLFW_KEY_LEFT_SHIFT))) {
				ScrollTracker.scrollRight(scrollSizeKeyboard);
			}
			else {
				ScrollTracker.scrollDown(scrollSizeKeyboard);
			}
		}
		else if (reset != -1 && class_3675.method_15987(window, reset)) {
			ScrollTracker.reset();
		}
    }

    public static int getXOffset () {
        MutableDouble convenientInjectionPoint = new MutableDouble(currentXOffset); // Other mods can inject here and manipulate this object for compatibility.
        return class_3532.method_15357(convenientInjectionPoint.doubleValue());
    }

    public static int getYOffset () {
        MutableDouble convenientInjectionPoint = new MutableDouble(currentYOffset); // Other mods can inject here and manipulate this object for compatibility.
        return class_3532.method_15357(convenientInjectionPoint.doubleValue());
    }

		public static void setInitialYOffset(int offset) {
				trueYOffset += offset;
				currentYOffset = trueYOffset;
		}

    public static void scrollUp () {
        scrollUp(scrollSize);
				moved = true;
    }

    public static void scrollUp (int amount) {
        if (!isLocked()) trueYOffset -= amount;
				moved = true;
    }

    public static void scrollDown () {
        scrollDown(scrollSize);
				moved = true;
    }

    public static void scrollDown (int amount) {
        if (!isLocked()) trueYOffset += amount;
				moved = true;
    }

    public static void scrollLeft () {
        scrollLeft(scrollSize);
				moved = true;
    }

    public static void scrollLeft (int amount) {
        if (!isLocked()) trueXOffset -= amount;
				moved = true;
    } 

    public static void scrollRight () {
        scrollRight(scrollSize);
				moved = true;
    }

    public static void scrollRight (int amount) {
        if (!isLocked()) trueXOffset += amount;
				moved = true;
    }

    private static void resetScroll () {
        currentXOffset = 0;
        currentYOffset = 0;
        trueXOffset = 0;
        trueYOffset = 0;
				moved = false;
    }

    private static boolean isEqual (List<class_5684> item1, List<class_5684> item2) {
        if (item1 == null || item2 == null || item1.size() != item2.size()) return false;
        
        for (int i = 0; i < item1.size(); ++i) {
            if (item1.get(i) instanceof class_5683 && !(item2.get(i) instanceof class_5683)) return false;
            if (item2.get(i) instanceof class_5683 && !(item1.get(i) instanceof class_5683)) return false;
            if (!(item1.get(i) instanceof class_5683) && !(item2.get(i) instanceof class_5683)) continue; // Can't compare non-text.
            
            OrderedTextTooltipComponentAccessor accessible1 = (OrderedTextTooltipComponentAccessor) item1.get(i);
            OrderedTextTooltipComponentAccessor accessible2 = (OrderedTextTooltipComponentAccessor) item2.get(i);

            String text1 = OrderedTextReader.read(accessible1.getText());
            String text2 = OrderedTextReader.read(accessible2.getText());
            if (!text1.equals(text2)) return false;
        }
        return true;
    }

    private static boolean isLocked () {
        long difference = System.currentTimeMillis() - unlockTime;
        return difference > RELOCK_AT;
    }

    // Reset the tracker to default values.
    public static void reset () {
        resetScroll();
        currentItem = null; // Using null instead of just clearing the list because not all of Minecraft's Text Lists can be cleared for some reason and that can cause an error.
    }

    public static void setItem (List<class_5684> item) {
        if (!isEqual(currentItem, item)) {
            resetScroll();
            currentItem = item;
        }
    }

    public static void unlock () {
        if (Options.resetOnUnlock && isLocked()) {
            resetScroll();
        }
        unlockTime = System.currentTimeMillis();
    }

		public static boolean hasMoved() {
				return moved;
		}
}