package com.provismet.tooltipscroll.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.provismet.tooltipscroll.ScrollTracker;
import com.provismet.tooltipscroll.Options;
import com.provismet.tooltipscroll.TooltipScrollClient;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5684;
import net.minecraft.class_8000;

@Mixin(value = class_332.class, priority = 1001)
public abstract class DrawContextMixin {
    @Shadow
    @Final
    private class_4587 matrices;

    // Allows tooltips to be moved with keybinds.
	// It's just a QOL feature because some menus are scrollable and would be moved by the scroll wheel.
	@Inject (method = "drawTooltip(Lnet/minecraft/client/font/TextRenderer;Ljava/util/List;IILnet/minecraft/client/gui/tooltip/TooltipPositioner;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/tooltip/TooltipPositioner;getPosition(IIIIII)Lorg/joml/Vector2ic;", shift = At.Shift.BEFORE))
	public void applyTracker (class_327 textRenderer, List<class_5684> components, int x, int y, class_8000 positioner, CallbackInfo info) {
		ScrollTracker.unlock();
		ScrollTracker.update();
		ScrollTracker.setItem(components);
	}

	@Inject(
        method = "drawTooltip(Lnet/minecraft/client/font/TextRenderer;Ljava/util/List;IILnet/minecraft/client/gui/tooltip/TooltipPositioner;)V",
        at = @At(value = "INVOKE", target = "Lnet/minecraft/client/util/math/MatrixStack;push()V", shift = At.Shift.BEFORE)
	)
	private void editXY (class_327 textRenderer, List<class_5684> components, int x, int y, class_8000 positioner, CallbackInfo ci, @Local(ordinal = 6) LocalIntRef effectiveX, @Local(ordinal = 7) LocalIntRef effectiveY) {
        if (Options.matrixMode) return;

        effectiveX.set(effectiveX.get() + ScrollTracker.getXOffset());
		effectiveY.set(effectiveY.get() + ScrollTracker.getYOffset());

        if (Options.startOnTop && !ScrollTracker.hasMoved()) {
            int originalY = effectiveY.get();
            if (effectiveY.get() < 4) {
                effectiveY.set(4);
                ScrollTracker.setInitialYOffset(4 - originalY);
            }
        }
	}

    @Inject(
        method = "drawTooltip(Lnet/minecraft/client/font/TextRenderer;Ljava/util/List;IILnet/minecraft/client/gui/tooltip/TooltipPositioner;)V",
        at = @At("HEAD")
    )
    private void headMatrices(class_327 textRenderer, List<class_5684> components, int x, int y, class_8000 positioner, CallbackInfo info) {
        if (!Options.matrixMode) return;

        this.matrices.method_22903();
        this.matrices.method_46416(ScrollTracker.getXOffset(), ScrollTracker.getYOffset(), 0);
    }

    @Inject(
        method = "drawTooltip(Lnet/minecraft/client/font/TextRenderer;Ljava/util/List;IILnet/minecraft/client/gui/tooltip/TooltipPositioner;)V",
        at = @At("TAIL")
    )
    private void tailMatrices (class_327 textRenderer, List<class_5684> components, int x, int y, class_8000 positioner, CallbackInfo info) {
        if (!Options.matrixMode) return;
        this.matrices.method_22909();
    }
}
