/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures;

import com.mojang.authlib.GameProfile;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.MoCEntityAnimal;
import drzhark.mocreatures.entity.ambient.MoCEntityMaggot;
import drzhark.mocreatures.entity.hostile.MoCEntityOgre;
import drzhark.mocreatures.entity.hostile.MoCEntitySilverSkeleton;
import drzhark.mocreatures.entity.inventory.MoCAnimalChest;
import drzhark.mocreatures.entity.item.MoCEntityThrowableRock;
import drzhark.mocreatures.entity.passive.MoCEntityHorse;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCEntities;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageNameGUI;
import drzhark.mocreatures.util.MoCTags;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class MoCTools {
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    public static void performCustomWorldGenSpawning(ServerLevel world, Biome biome, int centerX, int centerZ, int diameterX, int diameterZ, RandomSource random, List<MobSpawnSettings.SpawnerData> spawnList, SpawnPlacements.Type placementType) {
        if (spawnList == null || spawnList.isEmpty()) {
            return;
        }
        float baseChance = biome.m_47518_().m_48344_();
        float spawnChance = (float)Math.min((double)baseChance * MoCreatures.proxy.spawnMultiplier, 0.5);
        while (random.m_188501_() < spawnChance) {
            MobSpawnSettings.SpawnerData spawnEntry = WeightedRandom.m_216822_((RandomSource)random, spawnList).orElse(null);
            if (spawnEntry == null) continue;
            int min = Math.min(spawnEntry.f_48405_, 1);
            int max = Math.min(spawnEntry.f_48406_, 6);
            int groupSize = min + random.m_188503_(1 + max - min);
            SpawnGroupData spawnData = null;
            int xOrig = centerX + random.m_188503_(diameterX);
            int zOrig = centerZ + random.m_188503_(diameterZ);
            int xPos = xOrig;
            int zPos = zOrig;
            block1: for (int i = 0; i < groupSize; ++i) {
                boolean spawned = false;
                for (int j = 0; !spawned && j < 4; ++j) {
                    BlockPos pos = world.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(xPos, 0, zPos));
                    if (placementType == SpawnPlacements.Type.IN_WATER) {
                        pos = pos.m_7495_();
                    }
                    if (SpawnPlacements.m_217074_((EntityType)spawnEntry.f_48404_, (ServerLevelAccessor)world, (MobSpawnType)MobSpawnType.NATURAL, (BlockPos)pos, (RandomSource)world.m_213780_())) {
                        Entity entity = spawnEntry.f_48404_.m_20615_((Level)world);
                        if (!(entity instanceof Mob)) continue block1;
                        Mob mob = (Mob)entity;
                        if (!ForgeEventFactory.checkSpawnPosition((Mob)mob, (ServerLevelAccessor)world, (MobSpawnType)MobSpawnType.NATURAL)) continue;
                        mob.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, random.m_188501_() * 360.0f, 0.0f);
                        if (mob.m_5545_((LevelAccessor)world, MobSpawnType.NATURAL) && mob.m_6914_((LevelReader)world)) {
                            spawnData = mob.m_6518_((ServerLevelAccessor)world, world.m_6436_(pos), MobSpawnType.NATURAL, spawnData, null);
                            world.m_7967_((Entity)mob);
                            spawned = true;
                        } else {
                            mob.m_146870_();
                        }
                    }
                    xPos += random.m_188503_(5) - random.m_188503_(5);
                    zPos += random.m_188503_(5) - random.m_188503_(5);
                    while (xPos < centerX || xPos >= centerX + diameterX || zPos < centerZ || zPos >= centerZ + diameterZ) {
                        xPos = xOrig + random.m_188503_(5) - random.m_188503_(5);
                        zPos = zOrig + random.m_188503_(5) - random.m_188503_(5);
                    }
                }
            }
        }
    }

    public static void spawnSlimes(Level level, Entity entity) {
        if (!level.f_46443_) {
            RandomSource random = level.m_213780_();
            int count = 1 + random.m_188503_(1);
            for (int i = 0; i < count; ++i) {
                float offsetX = ((float)(i % 2) - 0.5f) * 0.25f;
                float offsetZ = ((float)i / 2.0f - 0.5f) * 0.25f;
                Slime slime = (Slime)EntityType.f_20526_.m_20615_(level);
                if (slime == null) continue;
                slime.m_7678_(entity.m_20185_() + (double)offsetX, entity.m_20186_() + 0.5, entity.m_20189_() + (double)offsetZ, random.m_188501_() * 360.0f, 0.0f);
                level.m_7967_((Entity)slime);
            }
        }
    }

    public static void dropSaddle(MoCEntityAnimal entity, Level level) {
        if (!entity.getIsRideable() || level.f_46443_) {
            return;
        }
        MoCTools.dropCustomItem((Entity)entity, level, new ItemStack((ItemLike)MoCItems.HORSE_SADDLE.get(), 1));
        entity.setRideable(false);
    }

    public static void dropCustomItem(Entity entity, Level level, ItemStack itemstack) {
        if (level.f_46443_) {
            return;
        }
        ItemEntity entityItem = new ItemEntity(level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), itemstack);
        float f = 0.05f;
        RandomSource random = level.m_213780_();
        entityItem.m_20334_(random.m_188583_() * (double)f, random.m_188583_() * (double)f + (double)0.2f, random.m_188583_() * (double)f);
        level.m_7967_((Entity)entityItem);
    }

    public static void bigSmack(Entity entity, Entity target, float force) {
        double dx = entity.m_20185_() - target.m_20185_();
        RandomSource random = entity.m_9236_().m_213780_();
        double dz = entity.m_20189_() - target.m_20189_();
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (random.m_188500_() - random.m_188500_()) * 0.01;
            dz = (random.m_188500_() - random.m_188500_()) * 0.01;
        }
        float dist = Mth.m_14116_((float)((float)(dx * dx + dz * dz)));
        Vec3 motion = target.m_20184_().m_82490_(0.5).m_82492_(dx / (double)dist * (double)force, (double)(-force), dz / (double)dist * (double)force);
        target.m_20256_(motion);
        if (target.m_20184_().m_7098_() > (double)force) {
            target.m_20334_(target.m_20184_().m_7096_(), (double)force, target.m_20184_().m_7094_());
        }
    }

    public static void buckleMobs(Mob entityAttacker, double dist, Level level) {
        AABB area = entityAttacker.m_20191_().m_82377_(dist, 2.0, dist);
        List targets = level.m_45933_((Entity)entityAttacker, area);
        for (Entity entityTarget : targets) {
            if (!(entityTarget instanceof Mob) || entityAttacker.m_20159_() && entityTarget == entityAttacker.m_20202_()) continue;
            DamageSource source = new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)entityAttacker);
            entityTarget.m_6469_(source, 2.0f);
            MoCTools.bigSmack((Entity)entityAttacker, entityTarget, 0.6f);
            MoCTools.playCustomSound((Entity)entityAttacker, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_TUD.get());
        }
    }

    public static void buckleMobsNotPlayers(Mob attacker, double dist, Level level) {
        AABB area = attacker.m_20191_().m_82377_(dist, 2.0, dist);
        List targets = level.m_45933_((Entity)attacker, area);
        for (Entity target : targets) {
            if (!(target instanceof Mob) || attacker.m_20159_() && target == attacker.m_20202_()) continue;
            DamageSource source = new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)attacker);
            target.m_6469_(source, 2.0f);
            MoCTools.bigSmack((Entity)attacker, target, 0.6f);
            MoCTools.playCustomSound((Entity)attacker, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_TUD.get());
        }
    }

    public static void spawnNearPlayer(ServerPlayer player, int entityId, int numberToSpawn) {
        ServerLevel world = player.m_284548_();
        for (int i = 0; i < numberToSpawn; ++i) {
            Mob entity = null;
            try {
                Class entityClass = (Class)MoCreatures.instaSpawnerMap.get(entityId);
                entity = (Mob)entityClass.getConstructor(Level.class).newInstance(world);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (entity == null) continue;
            entity.m_7678_(player.m_20185_() - 1.0, player.m_20186_(), player.m_20189_() - 1.0, player.m_146908_(), player.m_146909_());
            world.m_7967_((Entity)entity);
        }
    }

    public static void playCustomSound(Entity entity, SoundEvent customSound) {
        MoCTools.playCustomSound(entity, customSound, 1.0f);
    }

    public static void playCustomSound(Entity entity, SoundEvent customSound, float volume) {
        float pitch = 1.0f + (entity.m_9236_().f_46441_.m_188501_() - entity.m_9236_().f_46441_.m_188501_()) * 0.2f;
        entity.m_9236_().m_5594_(null, entity.m_20183_(), customSound, SoundSource.NEUTRAL, volume, pitch);
    }

    public static JukeboxBlockEntity nearJukeBoxRecord(Entity entity, double dist) {
        AABB aabb = entity.m_20191_().m_82377_(dist, dist / 2.0, dist);
        BlockPos.m_121886_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)(aabb.f_82291_ + 1.0)), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)(aabb.f_82293_ + 1.0))).forEach(pos -> {
            BlockEntity be;
            BlockState state = entity.m_9236_().m_8055_(pos);
            if (!state.m_60795_() && state.m_60734_() instanceof JukeboxBlock && (be = entity.m_9236_().m_7702_(pos)) instanceof JukeboxBlockEntity) {
                throw new JukeboxFound((JukeboxBlockEntity)be);
            }
        });
        return null;
    }

    public static void checkForTwistedEntities(Level level) {
        ServerLevel serverLevel = level.m_7654_().m_129880_(level.m_46472_());
        if (serverLevel == null) {
            return;
        }
        for (Entity entity : serverLevel.m_8583_()) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            if (living.f_20919_ <= 0 || living.m_20159_() || living.m_21224_()) continue;
            living.f_20919_ = 0;
        }
    }

    public static double getSqDistanceTo(Entity entity, double x, double y, double z) {
        double dx = entity.m_20185_() - x;
        double dy = entity.m_20186_() - y;
        double dz = entity.m_20189_() - z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static int[] returnNearestMaterialCoord(Entity entity, double rangeXZ, double rangeY) {
        double shortestDistance = -1.0;
        int x = -9999;
        int y = -1;
        int z = -1;
        AABB box = entity.m_20191_().m_82377_(rangeXZ, rangeY, rangeXZ);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int minX = Mth.m_14107_((double)box.f_82288_);
        int maxX = Mth.m_14107_((double)(box.f_82291_ + 1.0));
        int minY = Mth.m_14107_((double)box.f_82289_);
        int maxY = Mth.m_14107_((double)(box.f_82292_ + 1.0));
        int minZ = Mth.m_14107_((double)box.f_82290_);
        int maxZ = Mth.m_14107_((double)(box.f_82293_ + 1.0));
        for (int xi = minX; xi < maxX; ++xi) {
            for (int yi = minY; yi < maxY; ++yi) {
                for (int zi = minZ; zi < maxZ; ++zi) {
                    pos.m_122178_(xi, yi, zi);
                    BlockState state = entity.m_9236_().m_8055_((BlockPos)pos);
                    if (!state.m_60819_().m_76170_() || !state.m_60819_().m_76152_().m_6212_((Fluid)Fluids.f_76193_)) continue;
                    double distance = MoCTools.getSqDistanceTo(entity, xi, yi, zi);
                    if (shortestDistance != -1.0 && !(distance < shortestDistance)) continue;
                    x = xi;
                    y = yi;
                    z = zi;
                    shortestDistance = distance;
                }
            }
        }
        x = entity.m_20185_() > (double)x ? (x -= 2) : (x += 2);
        z = entity.m_20189_() > (double)z ? (z -= 2) : (z += 2);
        return new int[]{x, y, z};
    }

    public static int[] returnNearestBlockCoord(Entity entity, Block targetBlock, double dist) {
        double shortestDistance = -1.0;
        int x = -9999;
        int y = -1;
        int z = -1;
        AABB box = entity.m_20191_().m_82400_(dist);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int minX = Mth.m_14107_((double)box.f_82288_);
        int maxX = Mth.m_14107_((double)(box.f_82291_ + 1.0));
        int minY = Mth.m_14107_((double)box.f_82289_);
        int maxY = Mth.m_14107_((double)(box.f_82292_ + 1.0));
        int minZ = Mth.m_14107_((double)box.f_82290_);
        int maxZ = Mth.m_14107_((double)(box.f_82293_ + 1.0));
        for (int xi = minX; xi < maxX; ++xi) {
            for (int yi = minY; yi < maxY; ++yi) {
                for (int zi = minZ; zi < maxZ; ++zi) {
                    pos.m_122178_(xi, yi, zi);
                    BlockState state = entity.m_9236_().m_8055_((BlockPos)pos);
                    if (state.m_60795_() || state.m_60734_() != targetBlock) continue;
                    double distance = MoCTools.getSqDistanceTo(entity, xi, yi, zi);
                    if (shortestDistance != -1.0 && !(distance < shortestDistance)) continue;
                    x = xi;
                    y = yi;
                    z = zi;
                    shortestDistance = distance;
                }
            }
        }
        x = entity.m_20185_() > (double)x ? (x -= 2) : (x += 2);
        z = entity.m_20189_() > (double)z ? (z -= 2) : (z += 2);
        return new int[]{x, y, z};
    }

    public static BlockPos getTreeTop(Level level, Entity entity, int range) {
        BlockPos entityPos = BlockPos.m_274561_((double)entity.m_20185_(), (double)(entity.m_20186_() + (double)entity.m_20192_()), (double)entity.m_20189_());
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                block2: for (int z = -range; z <= range; ++z) {
                    BlockPos pos = entityPos.m_7918_(x, y, z);
                    BlockState state = level.m_8055_(pos);
                    if (!state.m_204336_(BlockTags.f_13106_)) continue;
                    for (int yOffset = 1; yOffset < 256; ++yOffset) {
                        BlockPos checkPos = pos.m_6630_(yOffset);
                        BlockState checkState = level.m_8055_(checkPos);
                        if (checkState.m_60795_()) {
                            return checkPos;
                        }
                        if (!checkState.m_204336_(BlockTags.f_13035_)) continue block2;
                    }
                }
            }
        }
        return null;
    }

    public static void moveCreatureToXYZ(PathfinderMob entity, int x, int y, int z, double speed) {
        Path path = entity.m_21573_().m_7864_(BlockPos.m_274561_((double)x, (double)y, (double)z), 0);
        if (path != null) {
            entity.m_21573_().m_26536_(path, speed);
        }
    }

    public static void moveToWater(PathfinderMob entity) {
        int[] coords = MoCTools.returnNearestMaterialCoord((Entity)entity, 20.0, 2.0);
        if (coords[0] > -1000) {
            MoCTools.moveCreatureToXYZ(entity, coords[0], coords[1], coords[2], 1.0);
        }
    }

    public static float realAngle(float origAngle) {
        return origAngle % 360.0f;
    }

    public static double waterSurfaceAtGivenPosition(double posX, double posY, double posZ, Level level) {
        BlockPos basePos = BlockPos.m_274561_((double)posX, (double)posY, (double)posZ);
        BlockState state = level.m_8055_(basePos);
        if (!state.m_60795_() && state.m_60819_().m_76152_().m_6212_((Fluid)Fluids.f_76193_)) {
            for (int offset = 1; offset < 64; ++offset) {
                BlockPos checkPos = basePos.m_6630_(offset);
                BlockState checkState = level.m_8055_(checkPos);
                if (!checkState.m_60795_() && checkState.m_60819_().m_76152_().m_6212_((Fluid)Fluids.f_76193_)) continue;
                return checkPos.m_123342_();
            }
        }
        return 0.0;
    }

    public static double waterSurfaceAtGivenEntity(Entity entity) {
        return MoCTools.waterSurfaceAtGivenPosition(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_9236_());
    }

    public static float distanceToSurface(double posX, double posY, double posZ, Level level) {
        BlockPos basePos = BlockPos.m_274561_((double)posX, (double)posY, (double)posZ);
        BlockState state = level.m_8055_(basePos);
        if (!state.m_60795_() && state.m_60819_().m_76152_().m_6212_((Fluid)Fluids.f_76193_)) {
            for (int offset = 1; offset < 64; ++offset) {
                BlockPos checkPos = basePos.m_6630_(offset);
                BlockState checkState = level.m_8055_(checkPos);
                if (!checkState.m_60795_() && checkState.m_60819_().m_76152_().m_6212_((Fluid)Fluids.f_76193_)) continue;
                return offset;
            }
        }
        return 0.0f;
    }

    public static int distanceToFloor(Entity entity) {
        BlockPos pos = BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_());
        Level level = entity.m_9236_();
        for (int offset = 0; offset < 64; ++offset) {
            BlockPos checkPos = pos.m_6625_(offset);
            if (level.m_8055_(checkPos).m_60795_()) continue;
            return offset;
        }
        return 0;
    }

    public static String biomeName(Level level, BlockPos pos) {
        return level.m_204166_(pos).m_203543_().map(key -> key.m_135782_().toString()).orElse("unknown");
    }

    public static ResourceKey<Biome> biomeKind(Level level, BlockPos pos) {
        return level.m_204166_(pos).m_203543_().orElse(Biomes.f_48173_);
    }

    public static void destroyDrops(Entity entity, double range) {
        if (!MoCreatures.proxy.destroyDrops) {
            return;
        }
        AABB box = entity.m_20191_().m_82400_(range);
        List entities = entity.m_9236_().m_45933_(entity, box);
        for (Entity nearby : entities) {
            ItemEntity item;
            if (!(nearby instanceof ItemEntity) || (item = (ItemEntity)nearby).m_32059_() >= 50) continue;
            item.m_146870_();
        }
    }

    public static boolean mobGriefing(Level world) {
        return world.m_46469_().m_46207_(GameRules.f_46132_);
    }

    public static void destroyBlast(Entity entity, double x, double y, double z, float strength, boolean fire) {
        Player p;
        Level level = entity.m_9236_();
        Player player = entity instanceof Player ? (p = (Player)entity) : null;
        level.m_6263_(player, x, y, z, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_DESTROY.get(), SoundSource.HOSTILE, 4.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f);
        boolean mobGrief = MoCTools.mobGriefing(level);
        HashSet<BlockPos> affectedBlocks = new HashSet<BlockPos>();
        float blastRadius = strength;
        int steps = 16;
        for (int i = 0; i < steps; ++i) {
            for (int j = 0; j < steps; ++j) {
                for (int k = 0; k < steps; ++k) {
                    if (i != 0 && i != steps - 1 && j != 0 && j != steps - 1 && k != 0 && k != steps - 1) continue;
                    double dx = (double)i / (double)(steps - 1) * 2.0 - 1.0;
                    double dy = (double)j / (double)(steps - 1) * 2.0 - 1.0;
                    double dz = (double)k / (double)(steps - 1) * 2.0 - 1.0;
                    double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    dx /= dist;
                    dy /= dist;
                    dz /= dist;
                    double px = x;
                    double py = y;
                    double pz = z;
                    float step = 0.3f;
                    for (float power = strength * (0.7f + level.f_46441_.m_188501_() * 0.6f); power > 0.0f; power -= step * 0.75f) {
                        BlockPos pos = BlockPos.m_274561_((double)px, (double)py, (double)pz);
                        BlockState state = level.m_8055_(pos);
                        if (!state.m_60795_()) {
                            float resistance = state.m_60734_().m_7325_();
                            power -= (resistance + 0.3f) * step;
                        }
                        if (power > 0.0f && py > entity.m_20186_() && state.m_60800_((BlockGetter)level, pos) < 3.0f) {
                            affectedBlocks.add(pos);
                        }
                        px += dx * (double)step;
                        py += dy * (double)step;
                        pz += dz * (double)step;
                    }
                }
            }
        }
        if (!level.f_46443_) {
            AABB blastBox = new AABB(x - (double)blastRadius, y - (double)blastRadius, z - (double)blastRadius, x + (double)blastRadius, y + (double)blastRadius, z + (double)blastRadius);
            Vec3 blastCenter = new Vec3(x, y, z);
            List entities = level.m_45933_(entity, blastBox);
            for (Entity e : entities) {
                double dz;
                double dy;
                double dx;
                double magnitude;
                double distance;
                if (e instanceof MoCEntityOgre || (distance = Math.sqrt(e.m_20238_(blastCenter)) / (double)blastRadius) > 1.0 || (magnitude = Math.sqrt((dx = e.m_20185_() - x) * dx + (dy = e.m_20186_() - y) * dy + (dz = e.m_20189_() - z) * dz)) == 0.0) continue;
                dx /= magnitude;
                dy /= magnitude;
                dz /= magnitude;
                double exposure = Explosion.m_46064_((Vec3)blastCenter, (Entity)e);
                double impact = (1.0 - distance) * exposure;
                float damage = (float)((impact * impact + impact) / 2.0 * 7.0 * (double)blastRadius + 1.0);
                e.m_6469_(level.m_269111_().m_269036_(entity, null), damage);
                Vec3 motion = e.m_20184_().m_82520_(dx * impact, dy * impact, dz * impact);
                e.m_20256_(motion);
            }
        }
        if (level.f_46443_) {
            for (BlockPos pos : affectedBlocks) {
                for (int i = 0; i < 5; ++i) {
                    Vec3 spawn = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82520_(level.f_46441_.m_188500_(), level.f_46441_.m_188500_(), level.f_46441_.m_188500_());
                    Vec3 motion = spawn.m_82492_(x, y, z).m_82541_().m_82490_(level.f_46441_.m_188500_() * 0.5);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, spawn.f_82479_, spawn.f_82480_, spawn.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
                }
                entity.m_20256_(entity.m_20184_().m_82492_(0.001, 0.001, 0.0));
            }
        }
        if (!level.f_46443_ && mobGrief) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (BlockPos pos : affectedBlocks) {
                BlockEvent.BreakEvent breakEvent;
                BlockState state = level.m_8055_(pos);
                if (state.m_60795_() || MinecraftForge.EVENT_BUS.post((Event)(breakEvent = new BlockEvent.BreakEvent((Level)serverLevel, pos, state, (Player)FakePlayerFactory.get((ServerLevel)serverLevel, (GameProfile)MoCreatures.MOCFAKEPLAYER))))) continue;
                level.m_7471_(pos, false);
                Explosion explosion = new Explosion(level, entity, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 3.0f, false, Explosion.BlockInteraction.KEEP);
                state.onBlockExploded(level, pos, explosion);
            }
        }
        if (!level.f_46443_ && mobGrief && fire) {
            for (BlockPos pos : affectedBlocks) {
                ServerLevel serverLevel;
                BlockEvent.BreakEvent breakEvent;
                if (!level.m_8055_(pos).m_60795_() || level.f_46441_.m_188503_(8) != 0 || MinecraftForge.EVENT_BUS.post((Event)(breakEvent = new BlockEvent.BreakEvent((Level)(serverLevel = (ServerLevel)level), pos, Blocks.f_50016_.m_49966_(), (Player)FakePlayerFactory.get((ServerLevel)serverLevel, (GameProfile)MoCreatures.MOCFAKEPLAYER))))) continue;
                level.m_7731_(pos, Blocks.f_50083_.m_49966_(), 3);
            }
        }
    }

    public static void updatePlayerArmorEffects(Player player) {
        if (!MoCreatures.proxy.armorSetEffects) {
            return;
        }
        Item boots = player.m_6844_(EquipmentSlot.FEET).m_41720_();
        Item legs = player.m_6844_(EquipmentSlot.LEGS).m_41720_();
        Item plate = player.m_6844_(EquipmentSlot.CHEST).m_41720_();
        Item helmet = player.m_6844_(EquipmentSlot.HEAD).m_41720_();
        if (boots == MoCItems.BOOTS_SCORP_C.get() && legs == MoCItems.LEGS_SCORP_C.get() && plate == MoCItems.PLATE_SCORP_C.get() && helmet == MoCItems.HELMET_SCORP_C.get()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 300, 0));
            return;
        }
        if (boots == MoCItems.BOOTS_SCORP_N.get() && legs == MoCItems.LEGS_SCORP_N.get() && plate == MoCItems.PLATE_SCORP_N.get() && helmet == MoCItems.HELMET_SCORP_N.get()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 300, 0));
            return;
        }
        if (boots == MoCItems.BOOTS_SCORP_F.get() && legs == MoCItems.LEGS_SCORP_F.get() && plate == MoCItems.PLATE_SCORP_F.get() && helmet == MoCItems.HELMET_SCORP_F.get()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 300, 0));
            return;
        }
        if (boots == MoCItems.BOOTS_SCORP_D.get() && legs == MoCItems.LEGS_SCORP_D.get() && plate == MoCItems.PLATE_SCORP_D.get() && helmet == MoCItems.HELMET_SCORP_D.get()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19616_, 300, 1));
            return;
        }
        if (boots == MoCItems.BOOTS_SCORP_U.get() && legs == MoCItems.LEGS_SCORP_U.get() && plate == MoCItems.PLATE_SCORP_U.get() && helmet == MoCItems.HELMET_SCORP_U.get()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 300, 0));
        }
    }

    @Nullable
    public static BlockState destroyRandomBlockWithIBlockState(Entity entity, double distance) {
        int l = (int)(distance * distance * distance);
        Level level = entity.m_9236_();
        for (int i = 0; i < l; ++i) {
            int x = (int)(entity.m_20185_() + (double)level.f_46441_.m_188503_((int)distance) - distance / 2.0);
            int y = (int)(entity.m_20186_() + (double)level.f_46441_.m_188503_((int)distance) - distance / 2.0);
            int z = (int)(entity.m_20189_() + (double)level.f_46441_.m_188503_((int)distance) - distance / 2.0);
            BlockPos pos = new BlockPos(Mth.m_14143_((float)x), Mth.m_14143_((float)y), Mth.m_14143_((float)z));
            BlockState stateAbove = level.m_8055_(pos.m_7494_());
            BlockState stateTarget = level.m_8055_(pos);
            if ((double)pos.m_123342_() == (double)((int)entity.m_20186_()) - 1.0 && pos.m_123341_() == Mth.m_14107_((double)entity.m_20185_()) && pos.m_123343_() == Mth.m_14107_((double)entity.m_20189_()) || stateTarget.m_60795_() || stateTarget.m_60734_() == Blocks.f_49990_ || stateTarget.m_60734_() == Blocks.f_50752_ || !stateAbove.m_60795_()) continue;
            if (MoCTools.mobGriefing(level)) {
                BlockEvent.BreakEvent event = null;
                if (!level.f_46443_) {
                    event = new BlockEvent.BreakEvent(level, pos, stateTarget, (Player)FakePlayerFactory.get((ServerLevel)((ServerLevel)level), (GameProfile)MoCreatures.MOCFAKEPLAYER));
                }
                if (event != null && !event.isCanceled()) {
                    level.m_7471_(pos, false);
                } else {
                    stateTarget = null;
                }
            }
            if (stateTarget == null) continue;
            return stateTarget;
        }
        return null;
    }

    public static BlockPos getRandomSurfaceBlockPos(Entity entity, int distance) {
        BlockPos pos = entity.m_20183_();
        Level world = entity.m_9236_();
        int x = pos.m_123341_() + world.f_46441_.m_188503_(distance * 2 + 1) - distance;
        int z = pos.m_123343_() + world.f_46441_.m_188503_(distance * 2 + 1) - distance;
        int y = world.m_6325_(x >> 4, z >> 4).m_5885_(Heightmap.Types.MOTION_BLOCKING, x & 0xF, z & 0xF) - 1;
        return new BlockPos(x, y, z);
    }

    public static InteractionResult tameWithName(Player ep, IMoCTameable storedCreature) {
        if (ep == null || storedCreature == null) {
            return InteractionResult.PASS;
        }
        storedCreature.setOwnerId(ep.m_20148_());
        if (MoCreatures.proxy.enableOwnership) {
            int max = MoCreatures.proxy.maxTamed;
            if (!MoCreatures.instance.mapData.isExistingPet(ep.m_20148_(), storedCreature)) {
                int count = MoCTools.numberTamedByPlayer(ep);
                if (MoCTools.isThisPlayerAnOP(ep)) {
                    max = MoCreatures.proxy.maxOPTamed;
                }
                if (count >= max) {
                    ep.m_213846_((Component)Component.m_237113_((String)("\u00a74" + ep.m_7755_().getString() + " can not tame more creatures, limit of " + max + " reached")));
                    return InteractionResult.PASS;
                }
            }
        }
        storedCreature.setTamed(true);
        if (MoCreatures.instance.mapData != null && storedCreature.getOwnerPetId() == -1) {
            MoCreatures.instance.mapData.updateOwnerPet(storedCreature);
            if (ep.m_9236_() instanceof ServerLevel) {
                MoCreatures.LOGGER.info("Forcing save after taming pet for player {}", (Object)ep.m_7755_().getString());
                ((ServerLevel)ep.m_9236_()).m_8895_().m_78151_();
            }
        }
        if (!ep.m_9236_().f_46443_ && MoCreatures.proxy.alwaysNamePets && ep instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)ep;
            Entity entity = (Entity)storedCreature;
            MoCTools.runLater(() -> MoCMessageHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MoCMessageNameGUI(entity.m_19879_())), 3);
        }
        return InteractionResult.SUCCESS;
    }

    public static void runLater(Runnable task, int ticksDelay) {
        long delayMs = (long)ticksDelay * 50L;
        scheduler.schedule(task, delayMs, TimeUnit.MILLISECONDS);
    }

    public static int numberTamedByPlayer(Player ep) {
        if (MoCreatures.instance.mapData != null && MoCreatures.instance.mapData.getPetData(ep.m_20148_()) != null) {
            return MoCreatures.instance.mapData.getPetData(ep.m_20148_()).getTamedList().size();
        }
        return 0;
    }

    public static int destroyBlocksInFront(Entity entity, double distance, int strength, int height) {
        if (strength == 0) {
            return 0;
        }
        int count = 0;
        double newPosX = entity.m_20185_() - distance * Math.cos((double)MoCTools.realAngle(entity.m_146908_() - 90.0f) / 57.29577951308232);
        double newPosZ = entity.m_20189_() - distance * Math.sin((double)MoCTools.realAngle(entity.m_146908_() - 90.0f) / 57.29577951308232);
        double newPosY = entity.m_20186_();
        int x = Mth.m_14107_((double)newPosX);
        int y = Mth.m_14107_((double)newPosY);
        int z = Mth.m_14107_((double)newPosZ);
        for (int i = 0; i < height; ++i) {
            BlockPos pos = new BlockPos(x, y + i, z);
            BlockState blockstate = entity.m_9236_().m_8055_(pos);
            if (blockstate.m_60795_() || !(blockstate.m_60800_((BlockGetter)entity.m_9236_(), pos) <= (float)strength)) continue;
            BlockEvent.BreakEvent event = null;
            if (!entity.m_9236_().f_46443_) {
                event = new BlockEvent.BreakEvent(entity.m_9236_(), pos, blockstate, (Player)FakePlayerFactory.get((ServerLevel)((ServerLevel)entity.m_9236_()), (GameProfile)MoCreatures.MOCFAKEPLAYER));
            }
            if (event == null || event.isCanceled()) continue;
            entity.m_9236_().m_7471_(pos, false);
            if (entity.m_9236_().f_46441_.m_188503_(3) != 0) continue;
            MoCTools.playCustomSound(entity, (SoundEvent)MoCSoundEvents.ENTITY_GOLEM_WALK.get());
            ++count;
        }
        return count;
    }

    public static void dropInventory(Entity entity, MoCAnimalChest animalchest) {
        if (animalchest == null || entity.m_9236_().f_46443_) {
            return;
        }
        int i = Mth.m_14107_((double)entity.m_20185_());
        int j = Mth.m_14107_((double)entity.m_20191_().f_82289_);
        int k = Mth.m_14107_((double)entity.m_20189_());
        Random random = (Random)entity.m_9236_().f_46441_;
        for (int l = 0; l < animalchest.m_6643_(); ++l) {
            ItemStack itemstack = animalchest.m_8020_(l);
            if (itemstack.m_41619_()) continue;
            float f = random.nextFloat() * 0.8f + 0.1f;
            float f1 = random.nextFloat() * 0.8f + 0.1f;
            float f2 = random.nextFloat() * 0.8f + 0.1f;
            float f3 = 0.05f;
            ItemEntity entityitem = new ItemEntity(entity.m_9236_(), (double)((float)i + f), (double)((float)j + f1), (double)((float)k + f2), itemstack);
            entityitem.m_20334_(random.nextGaussian() * (double)f3, random.nextGaussian() * (double)f3 + (double)0.2f, random.nextGaussian() * (double)f3);
            entity.m_9236_().m_7967_((Entity)entityitem);
            animalchest.m_6836_(l, ItemStack.f_41583_);
        }
    }

    public static void dropHorseAmulet(MoCEntityTameableAnimal entity) {
        if (entity.m_9236_().f_46443_) {
            return;
        }
        ItemStack stack = MoCTools.getProperAmulet(entity);
        if (stack == null) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        UUID ownerId = entity.getOwnerId();
        Player ownerPlayer = null;
        if (ownerId != null) {
            ownerPlayer = entity.m_9236_().m_46003_(ownerId);
        }
        try {
            tag.m_128359_("SpawnClass", "WildHorse");
            tag.m_128350_("Health", entity.m_21223_());
            tag.m_128405_("Edad", entity.getMoCAge());
            tag.m_128359_("Name", entity.getPetName());
            tag.m_128379_("Rideable", entity.getIsRideable());
            tag.m_128405_("Armor", entity.getArmorType());
            tag.m_128405_("CreatureType", entity.getTypeMoC());
            tag.m_128379_("Adult", entity.getIsAdult());
            tag.m_128359_("OwnerName", ownerPlayer != null ? ownerPlayer.m_7755_().getString() : "");
            if (ownerId != null) {
                tag.m_128362_("OwnerUUID", ownerId);
            }
            tag.m_128405_("PetId", entity.getOwnerPetId());
            int amuletType = 1;
            if (stack.m_41720_() == MoCItems.PET_AMULET_FULL.get()) {
                amuletType = 2;
            } else if (stack.m_41720_() == MoCItems.AMULET_GHOST_FULL.get()) {
                amuletType = 3;
            }
            tag.m_128379_("Ghost", amuletType == 3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ownerPlayer != null && ownerPlayer.m_150109_().m_36062_() != -1) {
            ownerPlayer.m_150109_().m_36054_(stack);
        } else {
            ItemEntity entityItem = new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack);
            entityItem.m_32010_(20);
            entity.m_9236_().m_7967_((Entity)entityItem);
        }
    }

    public static void dropAmulet(IMoCEntity entity, int amuletType, Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        ItemStack stack = switch (amuletType) {
            case 2 -> new ItemStack((ItemLike)MoCItems.PET_AMULET_FULL.get());
            case 3 -> new ItemStack((ItemLike)MoCItems.AMULET_GHOST_FULL.get());
            default -> new ItemStack((ItemLike)MoCItems.FISH_NET_FULL.get());
        };
        CompoundTag tag = stack.m_41784_();
        try {
            EntityType entry = ((Entity)entity).m_6095_();
            String petClass = BuiltInRegistries.f_256780_.m_7981_((Object)entry).m_135815_().replace("mocreatures:", "");
            tag.m_128359_("SpawnClass", petClass);
            tag.m_128362_("OwnerUUID", player.m_20148_());
            tag.m_128359_("OwnerName", player.m_7755_().getString());
            tag.m_128350_("Health", ((LivingEntity)entity).m_21223_());
            tag.m_128405_("Edad", entity.getMoCAge());
            tag.m_128359_("Name", entity.getPetName());
            tag.m_128405_("CreatureType", entity.getTypeMoC());
            tag.m_128379_("Adult", entity.getIsAdult());
            tag.m_128405_("PetId", entity.getOwnerPetId());
            tag.m_128379_("Ghost", amuletType == 3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!player.m_150109_().m_36054_(stack)) {
            Level level = ((LivingEntity)entity).m_9236_();
            ItemEntity itemEntity = new ItemEntity(level, ((Entity)entity).m_20185_(), ((Entity)entity).m_20186_(), ((Entity)entity).m_20189_(), stack);
            itemEntity.m_32010_(20);
            level.m_7967_((Entity)itemEntity);
        }
    }

    public static ItemStack getProperAmulet(MoCEntityAnimal entity) {
        if (entity instanceof MoCEntityHorse) {
            int type = entity.getTypeMoC();
            if (type == 26 || type == 27 || type == 28) {
                return new ItemStack((ItemLike)MoCItems.AMULET_BONE_FULL.get());
            }
            if (type > 47 && type < 60) {
                return new ItemStack((ItemLike)MoCItems.AMULET_FAIRY_FULL.get());
            }
            if (type == 39 || type == 40) {
                return new ItemStack((ItemLike)MoCItems.AMULET_PEGASUS_FULL.get());
            }
            if (type == 21 || type == 22) {
                return new ItemStack((ItemLike)MoCItems.AMULET_GHOST_FULL.get());
            }
        }
        return ItemStack.f_41583_;
    }

    public static boolean isThisPlayerAnOP(Player player) {
        if (player.m_9236_().f_46443_) {
            return false;
        }
        return player.m_20194_().m_6846_().m_11303_(player.m_36316_());
    }

    public static void spawnMaggots(Level level, Entity entity) {
        if (!level.f_46443_) {
            RandomSource rand = level.m_213780_();
            int count = 1 + rand.m_188503_(4);
            for (int i = 0; i < count; ++i) {
                float offsetX = ((float)(i % 2) - 0.5f) * 0.25f;
                float offsetZ = ((float)i / 2.0f - 0.5f) * 0.25f;
                MoCEntityMaggot maggot = (MoCEntityMaggot)((EntityType)MoCEntities.MAGGOT.get()).m_20615_(level);
                if (maggot == null) continue;
                maggot.m_7678_(entity.m_20185_() + (double)offsetX, entity.m_20186_() + 0.5, entity.m_20189_() + (double)offsetZ, rand.m_188501_() * 360.0f, 0.0f);
                level.m_7967_((Entity)maggot);
            }
        }
    }

    public static void setPathToEntity(Mob creature, Entity target, float distance) {
        Path path;
        if (creature.m_21573_() instanceof PathNavigation && (path = creature.m_21573_().m_6570_(target, 0)) != null && distance < 12.0f) {
            creature.m_21573_().m_26536_(path, 1.0);
        }
    }

    public static void runLikeHell(Mob runner, Entity boogey) {
        RandomSource rand = runner.m_217043_();
        double dx = runner.m_20185_() - boogey.m_20185_();
        double dz = runner.m_20189_() - boogey.m_20189_();
        double angle = Math.atan2(dx, dz);
        double targetX = runner.m_20185_() + Math.sin(angle += (double)(rand.m_188501_() - rand.m_188501_()) * 0.75) * 8.0;
        double targetZ = runner.m_20189_() + Math.cos(angle) * 8.0;
        int baseX = Mth.m_14107_((double)targetX);
        int baseY = Mth.m_14107_((double)runner.m_20191_().f_82289_);
        int baseZ = Mth.m_14107_((double)targetZ);
        Level level = runner.m_9236_();
        for (int i = 0; i < 16; ++i) {
            int x = baseX + rand.m_188503_(4) - rand.m_188503_(4);
            int y = baseY + rand.m_188503_(3) - rand.m_188503_(3);
            int z = baseZ + rand.m_188503_(4) - rand.m_188503_(4);
            BlockPos pos = new BlockPos(x, y, z);
            BlockState state = level.m_8055_(pos);
            BlockState below = level.m_8055_(pos.m_7495_());
            if (y <= 4 || !state.m_60795_() && !state.m_60713_(Blocks.f_50125_) || below.m_60795_()) continue;
            runner.m_21573_().m_26519_((double)x, (double)y, (double)z, 1.5);
            break;
        }
    }

    public static boolean findNearPlayerAndPoison(Entity poisoner, boolean needsToBeInWater) {
        Level level = poisoner.m_9236_();
        Player target = level.m_45930_(poisoner, 2.0);
        if (!(target == null || needsToBeInWater && !target.m_20069_() || !(poisoner.m_20270_((Entity)target) < 2.0f) || target.m_150110_().f_35934_ || target.m_20202_() instanceof Boat)) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 120, 0));
            return true;
        }
        return false;
    }

    public static boolean isTamed(Entity entity) {
        TamableAnimal tamable;
        if (entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).m_21824_()) {
            return true;
        }
        CompoundTag tag = entity.serializeNBT();
        if (tag.m_128441_("Owner") && !tag.m_128461_("Owner").isEmpty()) {
            return true;
        }
        return tag.m_128441_("Tamed") && tag.m_128471_("Tamed");
    }

    public static void throwStone(Entity throwerEntity, Entity targetEntity, BlockState state, double speedMod, double height) {
        MoCTools.throwStone(throwerEntity, (int)targetEntity.m_20185_(), (int)targetEntity.m_20186_(), (int)targetEntity.m_20189_(), state, speedMod, height);
    }

    public static void throwStone(Entity throwerEntity, double x, double y, double z, BlockState state, double speedMod, double height) {
        MoCEntityThrowableRock etrock = MoCEntityThrowableRock.build(throwerEntity.m_9236_(), throwerEntity, throwerEntity.m_20185_(), throwerEntity.m_20186_() + 0.5, throwerEntity.m_20189_());
        if (etrock == null) {
            return;
        }
        etrock.setState(state);
        etrock.setBehavior(0);
        etrock.m_20242_(false);
        double dx = (x - throwerEntity.m_20185_()) / speedMod;
        double dy = (y - throwerEntity.m_20186_()) / speedMod + height;
        double dz = (z - throwerEntity.m_20189_()) / speedMod;
        etrock.m_20334_(dx, dy, dz);
        etrock.f_19812_ = true;
        throwerEntity.m_9236_().m_7967_((Entity)etrock);
    }

    public static float getMyMovementSpeed(Entity entity) {
        return Mth.m_14116_((float)((float)(entity.m_20184_().f_82479_ * entity.m_20184_().f_82479_ + entity.m_20184_().f_82481_ * entity.m_20184_().f_82481_)));
    }

    public static ItemEntity getClosestFood(Entity entity, double range) {
        double closestDistSq = -1.0;
        ItemEntity closestItem = null;
        AABB searchBox = entity.m_20191_().m_82400_(range);
        List list = entity.m_9236_().m_45933_(entity, searchBox);
        for (Entity other : list) {
            ItemEntity itemEntity;
            if (!(other instanceof ItemEntity) || !MoCTools.isItemEdible((itemEntity = (ItemEntity)other).m_32055_().m_41720_())) continue;
            double distSq = itemEntity.m_20275_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            if (!(range < 0.0) && !(distSq < range * range) || closestDistSq != -1.0 && !(distSq < closestDistSq)) continue;
            closestDistSq = distSq;
            closestItem = itemEntity;
        }
        return closestItem;
    }

    public static boolean isItemEdible(Item item) {
        return item.m_41472_() || item.m_204114_().m_203656_(Tags.Items.SEEDS) || item == Items.f_42405_ || item == Items.f_42501_ || item == Items.f_42502_ || item == Items.f_42521_;
    }

    public static boolean isItemEdibleForCarnivores(Item item) {
        return item == Items.f_42579_ || item == Items.f_42581_ || item == Items.f_42580_ || item == Items.f_42582_ || item == Items.f_42697_ || item == Items.f_42659_ || item == Items.f_42486_ || item == Items.f_42658_ || item == Items.f_42698_ || item == Items.f_42485_ || item.m_204114_().m_203656_(MoCTags.Items.COOKED_FISHES) || item.m_204114_().m_203656_(MoCTags.Items.RAW_FISHES);
    }

    public static CompoundTag getEntityData(Entity entity) {
        if (!entity.getPersistentData().m_128441_("mocreatures")) {
            entity.getPersistentData().m_128365_("mocreatures", (Tag)new CompoundTag());
        }
        return entity.getPersistentData().m_128469_("mocreatures");
    }

    public static void findMobRider(Entity mountEntity) {
        List list = mountEntity.m_9236_().m_45933_(mountEntity, mountEntity.m_20191_().m_82377_(4.0, 2.0, 4.0));
        for (Entity entity : list) {
            if (!(entity instanceof Monster) || entity.m_20202_() != null || !(entity instanceof Skeleton) && !(entity instanceof Zombie) && !(entity instanceof MoCEntitySilverSkeleton)) continue;
            if (mountEntity.m_9236_().m_5776_()) break;
            entity.m_20329_(mountEntity);
            break;
        }
    }

    public static void copyDataFromOld(Entity source, Entity target) {
        CompoundTag tag = target.m_20240_(new CompoundTag());
        tag.m_128473_("Dimension");
        source.m_20258_(tag);
    }

    public static void dismountSneakingPlayer(Mob entity) {
        if (!entity.m_20159_()) {
            return;
        }
        Entity ridden = entity.m_20202_();
        if (ridden instanceof LivingEntity && ridden.m_6144_()) {
            entity.m_8127_();
            double dist = -1.5;
            double yaw = Math.toRadians(((LivingEntity)ridden).m_146908_());
            double newX = ridden.m_20185_() + dist * Math.sin(yaw);
            double newZ = ridden.m_20189_() - dist * Math.cos(yaw);
            double newY = ridden.m_20186_() + 2.0;
            entity.m_6021_(newX, newY, newZ);
            MoCTools.playCustomSound((Entity)entity, SoundEvents.f_11752_);
        }
    }

    public static double roundToNearest90Degrees(double degrees) {
        double radians = Math.toRadians(degrees);
        double roundedRadians = (double)Math.round(radians / 1.5707963267948966) * 1.5707963267948966;
        return Math.toDegrees(roundedRadians);
    }

    public static List<String> getAllBiomeTags() {
        RegistryAccess access = MoCTools.getSafeRegistryAccess();
        if (access == null) {
            return Collections.emptyList();
        }
        Registry biomeRegistry = access.m_175515_(Registries.f_256952_);
        HashSet tagSet = new HashSet();
        biomeRegistry.m_203611_().forEach(biomeHolder -> biomeHolder.m_203616_().forEach(tagKey -> tagSet.add(tagKey.f_203868_())));
        return tagSet.stream().sorted().map(ResourceLocation::toString).collect(Collectors.toList());
    }

    private static RegistryAccess getSafeRegistryAccess() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            return ServerLifecycleHooks.getCurrentServer().m_206579_();
        }
        if (Minecraft.m_91087_().f_91073_ != null) {
            return Minecraft.m_91087_().f_91073_.m_9598_();
        }
        return null;
    }

    public static boolean canSpawnInWyvernLair(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof Player) {
            return true;
        }
        if (!(entity instanceof Mob)) {
            return true;
        }
        try {
            EntityType entityType = entity.m_6095_();
            ResourceLocation entityId = EntityType.m_20613_((EntityType)entityType);
            String entityName = entityId.m_135815_();
            return entityName.equals("wyvern") || entityName.equals("bunny") || entityName.equals("snake") || entityName.equals("filchlizard") || entityName.equals("dragonfly") || entityName.equals("firefly") || entityName.equals("grasshopper");
        }
        catch (Exception e) {
            MoCreatures.LOGGER.debug("Error checking entity type for Wyvern Lair: " + e.getMessage());
            return true;
        }
    }

    public static boolean isInWyvernLair(Entity entity) {
        if (entity == null || entity.m_9236_() == null) {
            return false;
        }
        ResourceKey dimension = entity.m_9236_().m_46472_();
        ResourceLocation dimensionLocation = dimension.m_135782_();
        return dimensionLocation.toString().equals("mocreatures:wyvernlairworld");
    }

    private static class JukeboxFound
    extends RuntimeException {
        final JukeboxBlockEntity jukebox;

        JukeboxFound(JukeboxBlockEntity jukebox) {
            this.jukebox = jukebox;
        }
    }
}

