/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures;

import com.mojang.authlib.GameProfile;
import drzhark.mocreatures.client.renderer.fx.MoCParticles;
import drzhark.mocreatures.compat.CompatHandler;
import drzhark.mocreatures.config.biome.BiomeSpawnConfig;
import drzhark.mocreatures.entity.MoCEntityData;
import drzhark.mocreatures.entity.tameable.MoCPetMapData;
import drzhark.mocreatures.event.MoCEventHooks;
import drzhark.mocreatures.event.MoCEventHooksTerrain;
import drzhark.mocreatures.event.MoCWyvernDimensionHandler;
import drzhark.mocreatures.init.MoCBlocks;
import drzhark.mocreatures.init.MoCCreativeTabs;
import drzhark.mocreatures.init.MoCEntities;
import drzhark.mocreatures.init.MoCFeatures;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.init.MoCSpawnEggs;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.proxy.MoCProxy;
import drzhark.mocreatures.proxy.MoCProxyClient;
import drzhark.mocreatures.registry.MoCPOI;
import drzhark.mocreatures.world.MoCSpawnBiomeModifier;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mocreatures")
public class MoCreatures {
    public static final Logger LOGGER = LogManager.getLogger((String)"mocreatures");
    private static boolean debug = false;
    public static final String MOC_LOGO = ChatFormatting.WHITE + "[" + ChatFormatting.AQUA + "Mo' Creatures: Nostalgia Edition" + ChatFormatting.WHITE + "]";
    public static MoCreatures instance;
    public static MoCProxy proxy;
    public static GameProfile MOCFAKEPLAYER;
    public static Object2ObjectLinkedOpenHashMap<String, MoCEntityData> mocEntityMap;
    public static Object2ObjectOpenHashMap<EntityType<?>, MoCEntityData> entityMap;
    public static Int2ObjectOpenHashMap<Class<? extends Mob>> instaSpawnerMap;
    public MoCPetMapData mapData;

    public MoCreatures() {
        instance = this;
        proxy = (MoCProxy)DistExecutor.unsafeRunForDist(() -> MoCProxyClient::new, () -> MoCProxy::new);
        MoCMessageHandler.init();
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)new MoCEventHooks());
        MinecraftForge.EVENT_BUS.register((Object)new MoCEventHooksTerrain());
        MinecraftForge.EVENT_BUS.register(MoCWyvernDimensionHandler.class);
        CompatHandler.preInit();
        proxy.configInit();
        proxy.registerRenderers();
        proxy.registerRenderInformation();
        CompatHandler.init();
        MoCreatures.registerDeferredRegistries(eventBus);
        DeferredRegister biomeModifiers = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"mocreatures");
        biomeModifiers.register(eventBus);
        biomeModifiers.register("moc_spawns", MoCSpawnBiomeModifier::makeCodec);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            LOGGER.info("Building Mo'Creatures world gen spawn lists");
            LOGGER.info("Initializing Mo'Creatures entity maps...");
            proxy.initializeMocEntityMap();
            LOGGER.info("Entity maps initialized with {} entities", (Object)entityMap.size());
            LOGGER.info("Initializing BiomeConfig during setup...");
            BiomeSpawnConfig.init();
            LOGGER.info("BiomeConfig initialized during setup");
            debug = MoCreatures.proxy.debug;
            LOGGER.info("Mo'Creatures debug mode: {}", (Object)debug);
            MoCEventHooksTerrain.buildWorldGenSpawnLists();
            MoCPOI.init();
        });
    }

    public static boolean isServer(Level world) {
        return !world.m_5776_();
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void setDebug(boolean debug) {
        MoCreatures.debug = debug;
        if (debug) {
            LOGGER.info("Mo'Creatures debug mode enabled");
        }
    }

    public static void registerDeferredRegistries(IEventBus modBus) {
        MoCSoundEvents.SOUND_DEFERRED.register(modBus);
        MoCParticles.PARTICLES.register(modBus);
        MoCBlocks.BLOCKS.register(modBus);
        MoCBlocks.ITEMS.register(modBus);
        MoCEntities.ENTITY_TYPES.register(modBus);
        MoCSpawnEggs.SPAWN_EGGS.register(modBus);
        MoCItems.ITEMS.register(modBus);
        MoCFeatures.FEATURES.register(modBus);
        MoCCreativeTabs.register(modBus);
        MoCPOI.POI_TYPES.register(modBus);
    }

    static {
        MOCFAKEPLAYER = new GameProfile(UUID.fromString("6E379B45-1111-2222-3333-2FE1A88BCD66"), "[MoCreatures]");
        mocEntityMap = new Object2ObjectLinkedOpenHashMap();
        entityMap = new Object2ObjectOpenHashMap();
        instaSpawnerMap = new Int2ObjectOpenHashMap();
    }
}

