/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.gui;

import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageUpdatePetName;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoCGUIEntityNamer
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mocreatures", "textures/gui/pet_naming.png");
    private final IMoCEntity namedEntity;
    private EditBox nameInput;
    private final int imageWidth = 256;
    private final int imageHeight = 181;

    public MoCGUIEntityNamer(IMoCEntity entity, String defaultName) {
        super((Component)Component.m_237113_((String)"Choose your Pet's name:"));
        this.namedEntity = entity;
        this.nameInput = new EditBox(this.f_96547_, 0, 0, 200, 20, (Component)Component.m_237113_((String)"Pet Name"));
        this.nameInput.m_94144_(defaultName);
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = (this.f_96543_ - 256) / 2;
        int centerY = (this.f_96544_ - 181) / 2;
        this.nameInput = new EditBox(this.f_96547_, this.f_96543_ / 2 - 75, centerY + 70, 150, 20, (Component)Component.m_237113_((String)"Pet Name"));
        this.nameInput.m_94199_(30);
        this.nameInput.m_93692_(true);
        this.m_142416_((GuiEventListener)this.nameInput);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Done"), btn -> this.updateName()).m_252987_(this.f_96543_ / 2 - 75, centerY + 100, 150, 20).m_253136_());
    }

    private void updateName() {
        String petName = this.nameInput.m_94155_().trim();
        if (!petName.isEmpty()) {
            this.namedEntity.setPetName(petName);
            if (this.namedEntity instanceof Mob) {
                MoCMessageHandler.INSTANCE.sendToServer((Object)new MoCMessageUpdatePetName(((Mob)this.namedEntity).m_19879_(), petName));
            }
        }
        this.m_7379_();
    }

    public void m_88315_(GuiGraphics poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(poseStack);
        int centerX = (this.f_96543_ - 256) / 2;
        int centerY = (this.f_96544_ - 181) / 2;
        poseStack.m_280218_(TEXTURE, centerX, centerY, 0, 0, 256, 181);
        poseStack.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, centerY + 30, 0xFFFFFF);
        this.nameInput.m_88315_(poseStack, mouseX, mouseY, partialTicks);
        super.m_88315_(poseStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 || keyCode == 335) {
            this.updateName();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7379_() {
        super.m_7379_();
        IMoCEntity iMoCEntity = this.namedEntity;
        if (iMoCEntity instanceof IMoCTameable) {
            IMoCTameable tamed = (IMoCTameable)iMoCEntity;
            tamed.playTameEffect(true);
        }
    }
}

