/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class MoCModelAbstractHorse<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("mocreatures", "horse"), "main");
    protected final ModelPart body;
    protected final ModelPart tailA;
    protected final ModelPart tailB;
    protected final ModelPart tailC;
    protected final ModelPart leg1A;
    protected final ModelPart leg1B;
    protected final ModelPart leg1C;
    protected final ModelPart leg2A;
    protected final ModelPart leg2B;
    protected final ModelPart leg2C;
    protected final ModelPart leg3A;
    protected final ModelPart leg3B;
    protected final ModelPart leg3C;
    protected final ModelPart leg4A;
    protected final ModelPart leg4B;
    protected final ModelPart leg4C;
    protected final ModelPart head;
    protected final ModelPart uMouth;
    protected final ModelPart lMouth;
    protected final ModelPart uMouth2;
    protected final ModelPart lMouth2;
    protected final ModelPart unicorn;
    protected final ModelPart ear1;
    protected final ModelPart ear2;
    protected final ModelPart muleEarL;
    protected final ModelPart muleEarR;
    protected final ModelPart neck;
    protected final ModelPart bag1;
    protected final ModelPart bag2;
    protected final ModelPart saddle;
    protected final ModelPart saddleB;
    protected final ModelPart saddleC;
    protected final ModelPart saddleL;
    protected final ModelPart saddleL2;
    protected final ModelPart saddleR;
    protected final ModelPart saddleR2;
    protected final ModelPart saddleMouthL;
    protected final ModelPart saddleMouthR;
    protected final ModelPart saddleMouthLine;
    protected final ModelPart saddleMouthLineR;
    protected final ModelPart headSaddle;
    protected final ModelPart mane;
    protected final ModelPart midWing;
    protected final ModelPart innerWing;
    protected final ModelPart outerWing;
    protected final ModelPart innerWingR;
    protected final ModelPart midWingR;
    protected final ModelPart outerWingR;
    protected final ModelPart butterflyL;
    protected final ModelPart butterflyR;
    protected int type;
    protected boolean saddled;
    protected boolean rider;
    protected boolean flapwings;
    protected boolean shuffling;
    protected boolean wings;
    protected boolean eating;
    protected boolean standing;
    protected boolean moveTail;
    protected boolean floating;

    public MoCModelAbstractHorse(ModelPart root) {
        this.body = root.m_171324_("body");
        this.tailA = root.m_171324_("tailA");
        this.tailB = root.m_171324_("tailB");
        this.tailC = root.m_171324_("tailC");
        this.leg1A = root.m_171324_("leg1A");
        this.leg1B = root.m_171324_("leg1B");
        this.leg1C = root.m_171324_("leg1C");
        this.leg2A = root.m_171324_("leg2A");
        this.leg2B = root.m_171324_("leg2B");
        this.leg2C = root.m_171324_("leg2C");
        this.leg3A = root.m_171324_("leg3A");
        this.leg3B = root.m_171324_("leg3B");
        this.leg3C = root.m_171324_("leg3C");
        this.leg4A = root.m_171324_("leg4A");
        this.leg4B = root.m_171324_("leg4B");
        this.leg4C = root.m_171324_("leg4C");
        this.head = root.m_171324_("head");
        this.uMouth = root.m_171324_("uMouth");
        this.lMouth = root.m_171324_("lMouth");
        this.uMouth2 = root.m_171324_("uMouth2");
        this.lMouth2 = root.m_171324_("lMouth2");
        this.unicorn = root.m_171324_("unicorn");
        this.ear1 = root.m_171324_("ear1");
        this.ear2 = root.m_171324_("ear2");
        this.muleEarL = root.m_171324_("muleEarL");
        this.muleEarR = root.m_171324_("muleEarR");
        this.neck = root.m_171324_("neck");
        this.bag1 = root.m_171324_("bag1");
        this.bag2 = root.m_171324_("bag2");
        this.saddle = root.m_171324_("saddle");
        this.saddleB = root.m_171324_("saddleB");
        this.saddleC = root.m_171324_("saddleC");
        this.saddleL = root.m_171324_("saddleL");
        this.saddleL2 = root.m_171324_("saddleL2");
        this.saddleR = root.m_171324_("saddleR");
        this.saddleR2 = root.m_171324_("saddleR2");
        this.saddleMouthL = root.m_171324_("saddleMouthL");
        this.saddleMouthR = root.m_171324_("saddleMouthR");
        this.saddleMouthLine = root.m_171324_("saddleMouthLine");
        this.saddleMouthLineR = root.m_171324_("saddleMouthLineR");
        this.headSaddle = root.m_171324_("headSaddle");
        this.mane = root.m_171324_("mane");
        this.midWing = root.m_171324_("midWing");
        this.innerWing = root.m_171324_("innerWing");
        this.outerWing = root.m_171324_("outerWing");
        this.innerWingR = root.m_171324_("innerWingR");
        this.midWingR = root.m_171324_("midWingR");
        this.outerWingR = root.m_171324_("outerWingR");
        this.butterflyL = root.m_171324_("butterflyL");
        this.butterflyR = root.m_171324_("butterflyR");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171481_(-5.0f, -8.0f, -19.0f, 10.0f, 10.0f, 24.0f), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)9.0f));
        root.m_171599_("tailA", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171481_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)14.0f, (float)-1.134464f, (float)0.0f, (float)0.0f));
        root.m_171599_("tailB", CubeListBuilder.m_171558_().m_171514_(38, 7).m_171481_(-1.5f, -2.0f, 3.0f, 3.0f, 4.0f, 7.0f), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)14.0f, (float)-1.134464f, (float)0.0f, (float)0.0f));
        root.m_171599_("tailC", CubeListBuilder.m_171558_().m_171514_(24, 3).m_171481_(-1.5f, -4.5f, 9.0f, 3.0f, 4.0f, 7.0f), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)14.0f, (float)-1.40215f, (float)0.0f, (float)0.0f));
        root.m_171599_("leg1A", CubeListBuilder.m_171558_().m_171514_(78, 29).m_171481_(-2.5f, -2.0f, -2.5f, 4.0f, 9.0f, 5.0f), PartPose.m_171419_((float)4.0f, (float)9.0f, (float)11.0f));
        root.m_171599_("leg1B", CubeListBuilder.m_171558_().m_171514_(78, 43).m_171481_(-2.0f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f), PartPose.m_171419_((float)4.0f, (float)16.0f, (float)11.0f));
        root.m_171599_("leg1C", CubeListBuilder.m_171558_().m_171514_(78, 51).m_171481_(-2.5f, 5.1f, -2.0f, 4.0f, 3.0f, 4.0f), PartPose.m_171419_((float)4.0f, (float)16.0f, (float)11.0f));
        root.m_171599_("leg2A", CubeListBuilder.m_171558_().m_171514_(96, 29).m_171481_(-1.5f, -2.0f, -2.5f, 4.0f, 9.0f, 5.0f), PartPose.m_171419_((float)-4.0f, (float)9.0f, (float)11.0f));
        root.m_171599_("leg2B", CubeListBuilder.m_171558_().m_171514_(96, 43).m_171481_(-1.0f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f), PartPose.m_171419_((float)-4.0f, (float)16.0f, (float)11.0f));
        root.m_171599_("leg2C", CubeListBuilder.m_171558_().m_171514_(96, 51).m_171481_(-1.5f, 5.1f, -2.0f, 4.0f, 3.0f, 4.0f), PartPose.m_171419_((float)-4.0f, (float)16.0f, (float)11.0f));
        root.m_171599_("leg3A", CubeListBuilder.m_171558_().m_171514_(44, 29).m_171481_(-1.9f, -1.0f, -2.1f, 3.0f, 8.0f, 4.0f), PartPose.m_171419_((float)4.0f, (float)9.0f, (float)-8.0f));
        root.m_171599_("leg3B", CubeListBuilder.m_171558_().m_171514_(44, 41).m_171481_(-1.9f, 0.0f, -1.6f, 3.0f, 5.0f, 3.0f), PartPose.m_171419_((float)4.0f, (float)16.0f, (float)-8.0f));
        root.m_171599_("leg3C", CubeListBuilder.m_171558_().m_171514_(44, 51).m_171481_(-2.4f, 5.1f, -2.1f, 4.0f, 3.0f, 4.0f), PartPose.m_171419_((float)4.0f, (float)16.0f, (float)-8.0f));
        root.m_171599_("leg4A", CubeListBuilder.m_171558_().m_171514_(60, 29).m_171481_(-1.1f, -1.0f, -2.1f, 3.0f, 8.0f, 4.0f), PartPose.m_171419_((float)-4.0f, (float)9.0f, (float)-8.0f));
        root.m_171599_("leg4B", CubeListBuilder.m_171558_().m_171514_(60, 41).m_171481_(-1.1f, 0.0f, -1.6f, 3.0f, 5.0f, 3.0f), PartPose.m_171419_((float)-4.0f, (float)16.0f, (float)-8.0f));
        root.m_171599_("leg4C", CubeListBuilder.m_171558_().m_171514_(60, 51).m_171481_(-1.6f, 5.1f, -2.1f, 4.0f, 3.0f, 4.0f), PartPose.m_171419_((float)-4.0f, (float)16.0f, (float)-8.0f));
        root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.5f, -10.0f, -1.5f, 5.0f, 5.0f, 7.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-10.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        root.m_171599_("uMouth", CubeListBuilder.m_171558_().m_171514_(24, 18).m_171481_(-2.0f, -10.0f, -7.0f, 4.0f, 3.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-10.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        root.m_171599_("lMouth", CubeListBuilder.m_171558_().m_171514_(24, 27).m_171481_(-2.0f, -7.0f, -6.5f, 4.0f, 2.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-10.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        root.m_171599_("uMouth2", CubeListBuilder.m_171558_().m_171514_(24, 18).m_171481_(-2.0f, -10.0f, -8.0f, 4.0f, 3.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-10.0f, (float)0.4363323f, (float)0.0f, (float)0.0f));
        root.m_171599_("lMouth2", CubeListBuilder.m_171558_().m_171514_(24, 27).m_171481_(-2.0f, -7.0f, -5.5f, 4.0f, 2.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-10.0f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        root.m_171599_("unicorn", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-0.5f, -18.0f, 2.0f, 1.0f, 8.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-10.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        root.m_171599_("ear1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.45f, -12.0f, 4.0f, 2.0f, 3.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-10.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        root.m_171599_("ear2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.45f, -12.0f, 4.0f, 2.0f, 3.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-10.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        root.m_171599_("muleEarL", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(-2.0f, -16.0f, 4.0f, 2.0f, 7.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-10.0f, (float)0.5235988f, (float)0.0f, (float)0.2617994f));
        root.m_171599_("muleEarR", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(0.0f, -16.0f, 4.0f, 2.0f, 7.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-10.0f, (float)0.5235988f, (float)0.0f, (float)-0.2617994f));
        root.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(-2.05f, -9.8f, -2.0f, 4.0f, 14.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-10.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        root.m_171599_("bag1", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171481_(-3.0f, 0.0f, 0.0f, 8.0f, 8.0f, 3.0f), PartPose.m_171423_((float)-7.5f, (float)3.0f, (float)10.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        root.m_171599_("bag2", CubeListBuilder.m_171558_().m_171514_(0, 47).m_171481_(-3.0f, 0.0f, 0.0f, 8.0f, 8.0f, 3.0f), PartPose.m_171423_((float)4.5f, (float)3.0f, (float)10.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        root.m_171599_("saddle", CubeListBuilder.m_171558_().m_171514_(80, 0).m_171481_(-5.0f, 0.0f, -3.0f, 10.0f, 1.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)2.0f));
        root.m_171599_("saddleB", CubeListBuilder.m_171558_().m_171514_(106, 9).m_171481_(-1.5f, -1.0f, -3.0f, 3.0f, 1.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)2.0f));
        root.m_171599_("saddleC", CubeListBuilder.m_171558_().m_171514_(80, 9).m_171481_(-4.0f, -1.0f, 3.0f, 8.0f, 1.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)2.0f));
        root.m_171599_("saddleL2", CubeListBuilder.m_171558_().m_171514_(74, 0).m_171481_(-0.5f, 6.0f, -1.0f, 1.0f, 2.0f, 2.0f), PartPose.m_171419_((float)5.0f, (float)3.0f, (float)2.0f));
        root.m_171599_("saddleL", CubeListBuilder.m_171558_().m_171514_(70, 0).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 6.0f, 1.0f), PartPose.m_171419_((float)5.0f, (float)3.0f, (float)2.0f));
        root.m_171599_("saddleR2", CubeListBuilder.m_171558_().m_171514_(74, 4).m_171481_(-0.5f, 6.0f, -1.0f, 1.0f, 2.0f, 2.0f), PartPose.m_171419_((float)-5.0f, (float)3.0f, (float)2.0f));
        root.m_171599_("saddleR", CubeListBuilder.m_171558_().m_171514_(80, 0).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 6.0f, 1.0f), PartPose.m_171419_((float)-5.0f, (float)3.0f, (float)2.0f));
        root.m_171599_("saddleMouthL", CubeListBuilder.m_171558_().m_171514_(74, 13).m_171481_(1.5f, -8.0f, -4.0f, 1.0f, 2.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-10.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        root.m_171599_("saddleMouthR", CubeListBuilder.m_171558_().m_171514_(74, 13).m_171481_(-2.5f, -8.0f, -4.0f, 1.0f, 2.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-10.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        root.m_171599_("saddleMouthLine", CubeListBuilder.m_171558_().m_171514_(44, 10).m_171481_(2.6f, -6.0f, -6.0f, 0.0f, 3.0f, 16.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-10.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        root.m_171599_("saddleMouthLineR", CubeListBuilder.m_171558_().m_171514_(44, 5).m_171481_(-2.6f, -6.0f, -6.0f, 0.0f, 3.0f, 16.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-10.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        root.m_171599_("headSaddle", CubeListBuilder.m_171558_().m_171514_(80, 12).m_171488_(-2.5f, -10.1f, -7.0f, 5.0f, 5.0f, 12.0f, new CubeDeformation(0.2f)), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-10.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        root.m_171599_("mane", CubeListBuilder.m_171558_().m_171514_(58, 0).m_171481_(-1.0f, -11.5f, 5.0f, 2.0f, 16.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-10.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        root.m_171599_("midWing", CubeListBuilder.m_171558_().m_171514_(82, 68).m_171481_(1.0f, 0.1f, 1.0f, 12.0f, 2.0f, 11.0f), PartPose.m_171423_((float)5.0f, (float)3.0f, (float)-6.0f, (float)0.0f, (float)0.0872665f, (float)0.0f));
        root.m_171599_("innerWing", CubeListBuilder.m_171558_().m_171514_(0, 96).m_171481_(0.0f, 0.0f, 0.0f, 7.0f, 2.0f, 11.0f), PartPose.m_171423_((float)5.0f, (float)3.0f, (float)-6.0f, (float)0.0f, (float)-0.3490659f, (float)0.0f));
        root.m_171599_("outerWing", CubeListBuilder.m_171558_().m_171514_(0, 68).m_171481_(0.0f, 0.0f, 0.0f, 22.0f, 2.0f, 11.0f), PartPose.m_171423_((float)17.0f, (float)3.0f, (float)-6.0f, (float)0.0f, (float)-0.3228859f, (float)0.0f));
        root.m_171599_("innerWingR", CubeListBuilder.m_171558_().m_171514_(0, 110).m_171481_(-7.0f, 0.0f, 0.0f, 7.0f, 2.0f, 11.0f), PartPose.m_171423_((float)-5.0f, (float)3.0f, (float)-6.0f, (float)0.0f, (float)0.3490659f, (float)0.0f));
        root.m_171599_("midWingR", CubeListBuilder.m_171558_().m_171514_(82, 82).m_171481_(-13.0f, 0.1f, 1.0f, 12.0f, 2.0f, 11.0f), PartPose.m_171423_((float)-5.0f, (float)3.0f, (float)-6.0f, (float)0.0f, (float)-0.0872665f, (float)0.0f));
        root.m_171599_("outerWingR", CubeListBuilder.m_171558_().m_171514_(0, 82).m_171481_(-22.0f, 0.0f, 0.0f, 22.0f, 2.0f, 11.0f), PartPose.m_171423_((float)-17.0f, (float)3.0f, (float)-6.0f, (float)0.0f, (float)0.3228859f, (float)0.0f));
        root.m_171599_("butterflyL", CubeListBuilder.m_171558_().m_171514_(0, 98).m_171481_(-1.0f, 0.0f, -14.0f, 26.0f, 0.0f, 30.0f), PartPose.m_171423_((float)4.5f, (float)3.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.78539f));
        root.m_171599_("butterflyR", CubeListBuilder.m_171558_().m_171514_(0, 68).m_171481_(-25.0f, 0.0f, -14.0f, 26.0f, 0.0f, 30.0f), PartPose.m_171423_((float)-4.5f, (float)3.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.78539f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)128);
    }

    public void m_6973_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float tailMov;
        float RLegXRot = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        float LLegXRot = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount;
        float HeadXRot = headPitch * ((float)Math.PI / 180);
        if (netHeadYaw > 20.0f) {
            netHeadYaw = 20.0f;
        }
        if (netHeadYaw < -20.0f) {
            netHeadYaw = -20.0f;
        }
        if (this.shuffling) {
            HeadXRot += Mth.m_14089_((float)(ageInTicks * 0.4f)) * 0.15f;
        } else if (limbSwingAmount > 0.2f && !this.floating) {
            HeadXRot += Mth.m_14089_((float)(limbSwing * 0.4f)) * 0.15f * limbSwingAmount;
        }
        this.head.f_104201_ = 4.0f;
        this.head.f_104202_ = -10.0f;
        this.head.f_104203_ = 0.5235988f + HeadXRot;
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.tailA.f_104201_ = 3.0f;
        this.tailB.f_104202_ = 14.0f;
        this.bag2.f_104201_ = 3.0f;
        this.bag2.f_104202_ = 10.0f;
        this.body.f_104203_ = 0.0f;
        if (this.standing && !this.shuffling) {
            this.head.f_104201_ = -6.0f;
            this.head.f_104202_ = -1.0f;
            this.head.f_104203_ = 0.2617994f + HeadXRot;
            this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.tailA.f_104201_ = 9.0f;
            this.tailB.f_104202_ = 18.0f;
            this.bag2.f_104201_ = 5.5f;
            this.bag2.f_104202_ = 15.0f;
            this.body.f_104203_ = -0.7853981f;
        } else if (this.eating && !this.shuffling) {
            this.head.f_104201_ = 11.0f;
            this.head.f_104202_ = -10.0f;
            this.head.f_104203_ = 2.18166f;
            this.head.f_104204_ = 0.0f;
        }
        for (ModelPart part : new ModelPart[]{this.ear1, this.ear2, this.muleEarL, this.muleEarR, this.neck, this.uMouth, this.uMouth2, this.lMouth, this.lMouth2, this.mane, this.unicorn}) {
            part.f_104201_ = this.head.f_104201_;
            part.f_104202_ = this.head.f_104202_;
            part.f_104203_ = this.head.f_104203_;
            part.f_104204_ = this.head.f_104204_;
        }
        this.uMouth2.f_104203_ -= 0.0872664f;
        this.lMouth2.f_104203_ += 0.261799f;
        this.saddleMouthLine.f_104201_ = this.head.f_104201_;
        this.saddleMouthLineR.f_104201_ = this.head.f_104201_;
        this.headSaddle.f_104201_ = this.head.f_104201_;
        this.saddleMouthL.f_104201_ = this.head.f_104201_;
        this.saddleMouthR.f_104201_ = this.head.f_104201_;
        this.saddleMouthLine.f_104202_ = this.head.f_104202_;
        this.saddleMouthLineR.f_104202_ = this.head.f_104202_;
        this.headSaddle.f_104202_ = this.head.f_104202_;
        this.saddleMouthL.f_104202_ = this.head.f_104202_;
        this.saddleMouthR.f_104202_ = this.head.f_104202_;
        this.saddleMouthLine.f_104203_ = HeadXRot;
        this.saddleMouthLineR.f_104203_ = HeadXRot;
        this.headSaddle.f_104203_ = this.head.f_104203_;
        this.saddleMouthL.f_104203_ = this.head.f_104203_;
        this.saddleMouthR.f_104203_ = this.head.f_104203_;
        this.headSaddle.f_104204_ = this.head.f_104204_;
        this.saddleMouthL.f_104204_ = this.head.f_104204_;
        this.saddleMouthLine.f_104204_ = this.head.f_104204_;
        this.saddleMouthR.f_104204_ = this.head.f_104204_;
        this.saddleMouthLineR.f_104204_ = this.head.f_104204_;
        this.bag1.f_104203_ = RLegXRot / 5.0f;
        this.bag2.f_104203_ = -RLegXRot / 5.0f;
        if (this.wings) {
            this.innerWing.f_104203_ = this.body.f_104203_;
            this.midWing.f_104203_ = this.body.f_104203_;
            this.outerWing.f_104203_ = this.body.f_104203_;
            this.innerWingR.f_104203_ = this.body.f_104203_;
            this.midWingR.f_104203_ = this.body.f_104203_;
            this.outerWingR.f_104203_ = this.body.f_104203_;
            if (this.standing) {
                this.innerWing.f_104201_ = -5.0f;
                this.innerWing.f_104202_ = 4.0f;
            } else {
                this.innerWing.f_104201_ = 3.0f;
                this.innerWing.f_104202_ = -6.0f;
            }
            float WingRot = this.flapwings ? Mth.m_14089_((float)(ageInTicks * 0.3f + (float)Math.PI)) * 1.2f : Mth.m_14089_((float)(limbSwing * 0.5f)) * 0.1f;
            if (this.floating) {
                this.outerWing.f_104204_ = -0.3228859f + WingRot / 2.0f;
                this.outerWingR.f_104204_ = 0.3228859f - WingRot / 2.0f;
            } else {
                WingRot = 1.0471976f;
                this.outerWing.f_104204_ = -1.5707963f;
                this.outerWingR.f_104204_ = 1.5707963f;
            }
            this.innerWingR.f_104201_ = this.innerWing.f_104201_;
            this.innerWingR.f_104202_ = this.innerWing.f_104202_;
            this.outerWing.f_104200_ = this.innerWing.f_104200_ + Mth.m_14089_((float)WingRot) * 12.0f;
            this.outerWingR.f_104200_ = this.innerWingR.f_104200_ - Mth.m_14089_((float)WingRot) * 12.0f;
            this.midWing.f_104201_ = this.innerWing.f_104201_;
            this.midWingR.f_104201_ = this.innerWing.f_104201_;
            this.outerWing.f_104201_ = this.innerWing.f_104201_ + Mth.m_14031_((float)WingRot) * 12.0f;
            this.outerWingR.f_104201_ = this.innerWingR.f_104201_ + Mth.m_14031_((float)WingRot) * 12.0f;
            this.midWing.f_104202_ = this.innerWing.f_104202_;
            this.midWingR.f_104202_ = this.innerWing.f_104202_;
            this.outerWing.f_104202_ = this.innerWing.f_104202_;
            this.outerWingR.f_104202_ = this.innerWing.f_104202_;
            this.midWing.f_104205_ = WingRot;
            this.innerWing.f_104205_ = WingRot;
            this.outerWing.f_104205_ = WingRot;
            this.innerWingR.f_104205_ = -WingRot;
            this.midWingR.f_104205_ = -WingRot;
            this.outerWingR.f_104205_ = -WingRot;
        }
        if (this.type > 44 && this.type < 60 || this.type == 21) {
            float f2a = ageInTicks % 100.0f;
            float WingRot = 0.0f;
            if (this.type != 21) {
                if (this.flapwings) {
                    WingRot = Mth.m_14089_((float)(ageInTicks * 0.9f)) * 0.9f;
                } else if (this.floating) {
                    WingRot = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.5f;
                } else if (f2a > 40.0f && f2a < 60.0f) {
                    WingRot = Mth.m_14089_((float)(ageInTicks * 0.15f)) * 1.2f;
                }
            } else {
                WingRot = Mth.m_14089_((float)(ageInTicks * 0.1f));
            }
            if (this.standing) {
                this.butterflyL.f_104201_ = -2.5f;
                this.butterflyL.f_104202_ = 6.5f;
            } else {
                this.butterflyL.f_104201_ = 3.0f;
                this.butterflyL.f_104202_ = -2.0f;
            }
            this.butterflyR.f_104201_ = this.butterflyL.f_104201_;
            this.butterflyR.f_104202_ = this.butterflyL.f_104202_;
            this.butterflyL.f_104203_ = this.body.f_104203_;
            this.butterflyR.f_104203_ = this.body.f_104203_;
            float baseAngle = this.type == 21 ? 0.0f : 0.52359f;
            this.butterflyL.f_104205_ = -baseAngle + WingRot;
            this.butterflyR.f_104205_ = baseAngle - WingRot;
        }
        float RLegXRotB = RLegXRot;
        float LLegXRotB = LLegXRot;
        float RLegXRotC = RLegXRot;
        float LLegXRotC = LLegXRot;
        if (this.floating) {
            LLegXRot = RLegXRot = 0.2617994f;
            RLegXRotC = RLegXRotB = 0.7853981f;
            LLegXRotB = RLegXRotB;
            LLegXRotC = RLegXRotB;
        }
        if (this.standing) {
            this.leg3A.f_104201_ = -2.0f;
            this.leg3A.f_104202_ = -2.0f;
            this.leg4A.f_104201_ = this.leg3A.f_104201_;
            this.leg4A.f_104202_ = this.leg3A.f_104202_;
            RLegXRot = -1.0471976f + Mth.m_14089_((float)(ageInTicks * 0.4f + (float)Math.PI));
            LLegXRot = -1.0471976f + Mth.m_14089_((float)(ageInTicks * 0.4f));
            LLegXRotB = RLegXRotB = 0.7853981f;
            RLegXRotC = -0.2617994f;
            LLegXRotC = 0.2617994f;
            this.leg3B.f_104201_ = this.leg3A.f_104201_ + Mth.m_14031_((float)(1.5707963f + RLegXRot)) * 7.0f;
            this.leg3B.f_104202_ = this.leg3A.f_104202_ + Mth.m_14089_((float)(4.712389f + RLegXRot)) * 7.0f;
            this.leg4B.f_104201_ = this.leg4A.f_104201_ + Mth.m_14031_((float)(1.5707963f + LLegXRot)) * 7.0f;
            this.leg4B.f_104202_ = this.leg4A.f_104202_ + Mth.m_14089_((float)(4.712389f + LLegXRot)) * 7.0f;
            this.leg1B.f_104201_ = this.leg1A.f_104201_ + Mth.m_14031_((float)(1.5707963f + RLegXRotC)) * 7.0f;
            this.leg1B.f_104202_ = this.leg1A.f_104202_ + Mth.m_14089_((float)(4.712389f + RLegXRotC)) * 7.0f;
            this.leg2B.f_104201_ = this.leg1B.f_104201_;
            this.leg2B.f_104202_ = this.leg1B.f_104202_;
            this.leg1A.f_104203_ = RLegXRotC;
            this.leg1C.f_104203_ = this.leg1B.f_104203_ = LLegXRotC;
            this.leg2A.f_104203_ = RLegXRotC;
            this.leg2C.f_104203_ = this.leg2B.f_104203_ = LLegXRotC;
        } else {
            this.leg3A.f_104201_ = 9.0f;
            this.leg3A.f_104202_ = -8.0f;
            this.leg4A.f_104201_ = this.leg3A.f_104201_;
            this.leg4A.f_104202_ = this.leg3A.f_104202_;
            RLegXRot = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.4f * limbSwingAmount;
            LLegXRot = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.4f * limbSwingAmount;
            RLegXRotC = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.4f * limbSwingAmount;
            LLegXRotC = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.4f * limbSwingAmount;
            this.leg3B.f_104201_ = this.leg3A.f_104201_ + Mth.m_14031_((float)(1.5707963f + RLegXRot)) * 7.0f;
            this.leg3B.f_104202_ = this.leg3A.f_104202_ + Mth.m_14089_((float)(4.712389f + RLegXRot)) * 7.0f;
            this.leg4B.f_104201_ = this.leg4A.f_104201_ + Mth.m_14031_((float)(1.5707963f + LLegXRot)) * 7.0f;
            this.leg4B.f_104202_ = this.leg4A.f_104202_ + Mth.m_14089_((float)(4.712389f + LLegXRot)) * 7.0f;
            this.leg1A.f_104201_ = 9.0f;
            this.leg1A.f_104202_ = 11.0f;
            this.leg2A.f_104201_ = this.leg1A.f_104201_;
            this.leg2A.f_104202_ = this.leg1A.f_104202_;
            this.leg1B.f_104201_ = this.leg1A.f_104201_ + Mth.m_14031_((float)(1.5707963f + RLegXRotC)) * 7.0f;
            this.leg1B.f_104202_ = this.leg1A.f_104202_ + Mth.m_14089_((float)(4.712389f + RLegXRotC)) * 7.0f;
            this.leg2B.f_104201_ = this.leg2A.f_104201_ + Mth.m_14031_((float)(1.5707963f + LLegXRotC)) * 7.0f;
            this.leg2B.f_104202_ = this.leg2A.f_104202_ + Mth.m_14089_((float)(4.712389f + LLegXRotC)) * 7.0f;
        }
        this.leg3A.f_104203_ = RLegXRot;
        this.leg3B.f_104203_ = RLegXRotB;
        this.leg3C.f_104203_ = RLegXRotB;
        this.leg4A.f_104203_ = LLegXRot;
        this.leg4B.f_104203_ = LLegXRotB;
        this.leg4C.f_104203_ = LLegXRotB;
        if (this.type == 60 && this.shuffling) {
            this.leg3A.f_104201_ = 9.0f;
            this.leg3A.f_104202_ = -8.0f;
            this.leg4A.f_104201_ = this.leg3A.f_104201_;
            this.leg4A.f_104202_ = this.leg3A.f_104202_;
            if (!this.floating) {
                float LLegXRot2;
                float RLegXRot2 = Mth.m_14089_((float)(ageInTicks * 0.4f));
                if (RLegXRot2 > 0.1f) {
                    RLegXRot2 = 0.3f;
                }
                if ((LLegXRot2 = Mth.m_14089_((float)(ageInTicks * 0.4f + (float)Math.PI))) > 0.1f) {
                    LLegXRot2 = 0.3f;
                }
                RLegXRot = RLegXRot2;
                LLegXRot = LLegXRot2;
            }
            this.leg1B.f_104201_ = this.leg1A.f_104201_ + Mth.m_14031_((float)(1.5707963f + LLegXRot)) * 7.0f;
            this.leg1B.f_104202_ = this.leg1A.f_104202_ + Mth.m_14089_((float)(4.712389f + LLegXRot)) * 7.0f;
            this.leg2B.f_104201_ = this.leg2A.f_104201_ + Mth.m_14031_((float)(1.5707963f + RLegXRot)) * 7.0f;
            this.leg2B.f_104202_ = this.leg2A.f_104202_ + Mth.m_14089_((float)(4.712389f + RLegXRot)) * 7.0f;
            this.leg3B.f_104201_ = this.leg3A.f_104201_ + Mth.m_14031_((float)(1.5707963f + LLegXRot)) * 7.0f;
            this.leg3B.f_104202_ = this.leg3A.f_104202_ + Mth.m_14089_((float)(4.712389f + LLegXRot)) * 7.0f;
            this.leg4B.f_104201_ = this.leg4A.f_104201_ + Mth.m_14031_((float)(1.5707963f + RLegXRot)) * 7.0f;
            this.leg4B.f_104202_ = this.leg4A.f_104202_ + Mth.m_14089_((float)(4.712389f + RLegXRot)) * 7.0f;
            this.leg1A.f_104203_ = LLegXRot;
            this.leg1B.f_104203_ = LLegXRotB;
            this.leg1C.f_104203_ = LLegXRotB;
            this.leg3A.f_104203_ = LLegXRot;
            this.leg3B.f_104203_ = LLegXRotB;
            this.leg3C.f_104203_ = LLegXRotB;
            this.leg2A.f_104203_ = RLegXRot;
            this.leg2B.f_104203_ = RLegXRotB;
            this.leg2C.f_104203_ = RLegXRotB;
            this.leg4A.f_104203_ = RLegXRot;
            this.leg4B.f_104203_ = RLegXRotB;
            this.leg4C.f_104203_ = RLegXRotB;
        }
        this.leg1C.f_104201_ = this.leg1B.f_104201_;
        this.leg1C.f_104202_ = this.leg1B.f_104202_;
        this.leg2C.f_104201_ = this.leg2B.f_104201_;
        this.leg2C.f_104202_ = this.leg2B.f_104202_;
        this.leg3C.f_104201_ = this.leg3B.f_104201_;
        this.leg3C.f_104202_ = this.leg3B.f_104202_;
        this.leg4C.f_104201_ = this.leg4B.f_104201_;
        this.leg4C.f_104202_ = this.leg4B.f_104202_;
        if (this.saddled) {
            if (this.standing) {
                this.saddle.f_104201_ = 0.5f;
                this.saddle.f_104202_ = 11.0f;
            } else {
                this.saddle.f_104201_ = 2.0f;
                this.saddle.f_104202_ = 2.0f;
            }
            this.saddleB.f_104201_ = this.saddle.f_104201_;
            this.saddleC.f_104201_ = this.saddle.f_104201_;
            this.saddleL.f_104201_ = this.saddle.f_104201_;
            this.saddleR.f_104201_ = this.saddle.f_104201_;
            this.saddleL2.f_104201_ = this.saddle.f_104201_;
            this.saddleR2.f_104201_ = this.saddle.f_104201_;
            this.bag1.f_104201_ = this.bag2.f_104201_;
            this.saddleB.f_104202_ = this.saddle.f_104202_;
            this.saddleC.f_104202_ = this.saddle.f_104202_;
            this.saddleL.f_104202_ = this.saddle.f_104202_;
            this.saddleR.f_104202_ = this.saddle.f_104202_;
            this.saddleL2.f_104202_ = this.saddle.f_104202_;
            this.saddleR2.f_104202_ = this.saddle.f_104202_;
            this.bag1.f_104202_ = this.bag2.f_104202_;
            this.saddle.f_104203_ = this.body.f_104203_;
            this.saddleB.f_104203_ = this.body.f_104203_;
            this.saddleC.f_104203_ = this.body.f_104203_;
            if (this.rider) {
                this.saddleL.f_104203_ = -1.0471976f;
                this.saddleL2.f_104203_ = -1.0471976f;
                this.saddleR.f_104203_ = -1.0471976f;
                this.saddleR2.f_104203_ = -1.0471976f;
                this.saddleL.f_104205_ = 0.0f;
                this.saddleL2.f_104205_ = 0.0f;
                this.saddleR.f_104205_ = 0.0f;
                this.saddleR2.f_104205_ = 0.0f;
            } else {
                this.saddleL.f_104203_ = RLegXRot / 3.0f;
                this.saddleL2.f_104203_ = RLegXRot / 3.0f;
                this.saddleR.f_104203_ = RLegXRot / 3.0f;
                this.saddleR2.f_104203_ = RLegXRot / 3.0f;
                this.saddleL.f_104205_ = RLegXRot / 5.0f;
                this.saddleL2.f_104205_ = RLegXRot / 5.0f;
                this.saddleR.f_104205_ = -RLegXRot / 5.0f;
                this.saddleR2.f_104205_ = -RLegXRot / 5.0f;
            }
        }
        if ((tailMov = -1.3089f + limbSwingAmount * 1.5f) > 0.0f) {
            tailMov = 0.0f;
        }
        if (this.moveTail) {
            this.tailA.f_104204_ = Mth.m_14089_((float)(ageInTicks * 0.7f));
            tailMov = 0.0f;
        } else {
            this.tailA.f_104204_ = 0.0f;
        }
        this.tailB.f_104204_ = this.tailA.f_104204_;
        this.tailC.f_104204_ = this.tailA.f_104204_;
        this.tailB.f_104201_ = this.tailA.f_104201_;
        this.tailC.f_104201_ = this.tailA.f_104201_;
        this.tailB.f_104202_ = this.tailA.f_104202_;
        this.tailC.f_104202_ = this.tailA.f_104202_;
        this.tailA.f_104203_ = tailMov;
        this.tailB.f_104203_ = tailMov;
        this.tailC.f_104203_ = -0.2618f + tailMov;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tailA.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tailB.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tailC.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leg1A.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leg1B.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leg1C.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leg2A.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leg2B.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leg2C.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leg3A.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leg3B.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leg3C.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leg4A.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leg4B.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leg4C.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.uMouth.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.lMouth.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.uMouth2.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.lMouth2.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.unicorn.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.ear1.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.ear2.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.muleEarL.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.muleEarR.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.neck.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.bag1.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.bag2.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.saddle.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.saddleB.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.saddleC.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.saddleL.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.saddleL2.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.saddleR.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.saddleR2.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.saddleMouthL.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.saddleMouthR.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.saddleMouthLine.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.saddleMouthLineR.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.headSaddle.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.mane.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.midWing.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.innerWing.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.outerWing.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.innerWingR.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.midWingR.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.outerWingR.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.butterflyL.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.butterflyR.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

