/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.model;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import drzhark.mocreatures.entity.MoCEntityInsect;
import drzhark.mocreatures.entity.ambient.MoCEntityBee;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoCModelBee<T extends MoCEntityBee>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("mocreatures", "bee"), "main");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart mouth;
    private final ModelPart rAntenna;
    private final ModelPart lAntenna;
    private final ModelPart thorax;
    private final ModelPart abdomen;
    private final ModelPart tail;
    private final ModelPart frontLegs;
    private final ModelPart midLegs;
    private final ModelPart rearLegs;
    private final ModelPart leftWing;
    private final ModelPart rightWing;
    private final ModelPart foldedWings;
    private boolean flying;

    public MoCModelBee(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.mouth = root.m_171324_("mouth");
        this.rAntenna = root.m_171324_("r_antenna");
        this.lAntenna = root.m_171324_("l_antenna");
        this.thorax = root.m_171324_("thorax");
        this.abdomen = root.m_171324_("abdomen");
        this.tail = root.m_171324_("tail");
        this.frontLegs = root.m_171324_("front_legs");
        this.midLegs = root.m_171324_("mid_legs");
        this.rearLegs = root.m_171324_("rear_legs");
        this.leftWing = root.m_171324_("left_wing");
        this.rightWing = root.m_171324_("right_wing");
        this.foldedWings = root.m_171324_("folded_wings");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)21.5f, (float)-2.0f, (float)-2.171231f, (float)0.0f, (float)0.0f));
        root.m_171599_("r_antenna", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171481_(-0.5f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f), PartPose.m_171423_((float)-0.5f, (float)20.2f, (float)-2.3f, (float)-1.041001f, (float)0.7853982f, (float)0.0f));
        root.m_171599_("l_antenna", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(-0.5f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f), PartPose.m_171423_((float)0.5f, (float)20.2f, (float)-2.3f, (float)-1.041001f, (float)-0.7853982f, (float)0.0f));
        root.m_171599_("mouth", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171481_(0.0f, 0.0f, -1.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)21.5f, (float)-2.0f, (float)-0.4461433f, (float)0.3569147f, (float)0.7853982f));
        root.m_171599_("thorax", CubeListBuilder.m_171558_().m_171514_(0, 5).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)20.5f, (float)-1.0f));
        root.m_171599_("abdomen", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)21.5f, (float)0.0f, (float)1.249201f, (float)0.0f, (float)0.0f));
        root.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171481_(-0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)22.0f, (float)2.0f, (float)0.2379431f, (float)0.0f, (float)0.0f));
        root.m_171599_("front_legs", CubeListBuilder.m_171558_().m_171514_(4, 14).m_171481_(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)22.0f, (float)-1.8f, (float)0.1487144f, (float)0.0f, (float)0.0f));
        root.m_171599_("mid_legs", CubeListBuilder.m_171558_().m_171514_(4, 12).m_171481_(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)22.5f, (float)-1.2f, (float)0.5948578f, (float)0.0f, (float)0.0f));
        root.m_171599_("rear_legs", CubeListBuilder.m_171558_().m_171514_(8, 1).m_171481_(-1.5f, 0.0f, 0.0f, 3.0f, 3.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)22.5f, (float)-0.4f, (float)0.8922867f, (float)0.0f, (float)0.0f));
        root.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171481_(-1.0f, 0.0f, 0.5f, 2.0f, 0.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)20.4f, (float)-1.0f, (float)0.0f, (float)1.047198f, (float)0.0f));
        root.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171481_(-1.0f, 0.0f, 0.5f, 2.0f, 0.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)20.4f, (float)-1.0f, (float)0.0f, (float)-1.047198f, (float)0.0f));
        root.m_171599_("folded_wings", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171481_(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)20.5f, (float)-1.0f, (float)1.745E-4f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.flying = ((MoCEntityInsect)entityIn).getIsFlying() || entityIn.m_20184_().f_82480_ < -0.1;
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float legMovB;
        float legMov;
        float wingRot;
        this.rightWing.f_104205_ = wingRot = Mth.m_14089_((float)(ageInTicks * 3.0f)) * 0.7f;
        this.leftWing.f_104205_ = -wingRot;
        if (this.flying) {
            legMovB = legMov = limbSwingAmount * 1.5f;
        } else {
            legMov = Mth.m_14089_((float)(limbSwing * 1.5f + (float)Math.PI)) * 2.0f * limbSwingAmount;
            legMovB = Mth.m_14089_((float)(limbSwing * 1.5f)) * 2.0f * limbSwingAmount;
        }
        this.frontLegs.f_104203_ = 0.1487144f + legMov;
        this.midLegs.f_104203_ = 0.5948578f + legMovB;
        this.rearLegs.f_104203_ = 1.070744f + legMov;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.abdomen.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.frontLegs.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rAntenna.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.lAntenna.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rearLegs.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.midLegs.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.mouth.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tail.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.thorax.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        if (!this.flying) {
            this.foldedWings.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        } else {
            poseStack.m_85836_();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.clearColor((float)0.8f, (float)0.8f, (float)0.8f, (float)0.6f);
            this.leftWing.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.rightWing.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            RenderSystem.disableBlend();
            poseStack.m_85849_();
        }
    }
}

