/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.model;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import drzhark.mocreatures.entity.MoCEntityInsect;
import drzhark.mocreatures.entity.ambient.MoCEntityButterfly;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoCModelButterfly<T extends MoCEntityButterfly>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("mocreatures", "butterfly"), "main");
    private final ModelPart head;
    private final ModelPart mouth;
    private final ModelPart right_antenna;
    private final ModelPart left_antenna;
    private final ModelPart thorax;
    private final ModelPart abdomen;
    private final ModelPart front_legs;
    private final ModelPart mid_legs;
    private final ModelPart rear_legs;
    private final ModelPart wing_left_front;
    private final ModelPart wing_left;
    private final ModelPart wing_left_back;
    private final ModelPart wing_right_front;
    private final ModelPart wing_right;
    private final ModelPart wing_right_back;
    private boolean getIsFlying;

    public MoCModelButterfly(ModelPart root) {
        this.head = root.m_171324_("head");
        this.mouth = root.m_171324_("mouth");
        this.right_antenna = root.m_171324_("right_antenna");
        this.left_antenna = root.m_171324_("left_antenna");
        this.thorax = root.m_171324_("thorax");
        this.abdomen = root.m_171324_("abdomen");
        this.front_legs = root.m_171324_("front_legs");
        this.mid_legs = root.m_171324_("mid_legs");
        this.rear_legs = root.m_171324_("rear_legs");
        this.wing_left_front = root.m_171324_("wing_left_front");
        this.wing_left = root.m_171324_("wing_left");
        this.wing_left_back = root.m_171324_("wing_left_back");
        this.wing_right_front = root.m_171324_("wing_right_front");
        this.wing_right = root.m_171324_("wing_right");
        this.wing_right_back = root.m_171324_("wing_right_back");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171481_(-0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)21.9f, (float)-1.3f, (float)-2.171231f, (float)0.0f, (float)0.0f));
        root.m_171599_("mouth", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f), PartPose.m_171423_((float)-0.2f, (float)22.0f, (float)-2.5f, (float)0.6548599f, (float)0.0f, (float)0.0f));
        root.m_171599_("right_antenna", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171481_(-0.5f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f), PartPose.m_171423_((float)-0.5f, (float)21.7f, (float)-2.3f, (float)-1.041001f, (float)0.7853982f, (float)0.0f));
        root.m_171599_("left_antenna", CubeListBuilder.m_171558_().m_171514_(4, 7).m_171481_(-0.5f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f), PartPose.m_171423_((float)0.5f, (float)21.7f, (float)-2.3f, (float)-1.041001f, (float)-0.7853982f, (float)0.0f));
        root.m_171599_("thorax", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-0.5f, 1.5f, -1.0f, 1.0f, 1.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)20.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("abdomen", CubeListBuilder.m_171558_().m_171514_(8, 1).m_171481_(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)21.5f, (float)0.0f, (float)1.427659f, (float)0.0f, (float)0.0f));
        root.m_171599_("front_legs", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171481_(-1.0f, 0.0f, 0.0f, 2.0f, 3.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)21.5f, (float)-1.8f, (float)0.1487144f, (float)0.0f, (float)0.0f));
        root.m_171599_("mid_legs", CubeListBuilder.m_171558_().m_171514_(4, 8).m_171481_(-1.0f, 0.0f, 0.0f, 2.0f, 3.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)22.0f, (float)-1.2f, (float)0.5948578f, (float)0.0f, (float)0.0f));
        root.m_171599_("rear_legs", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171481_(-1.0f, 0.0f, 0.0f, 2.0f, 3.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)22.5f, (float)-0.4f, (float)1.070744f, (float)0.0f, (float)0.0f));
        root.m_171599_("wing_left_front", CubeListBuilder.m_171558_().m_171514_(4, 20).m_171481_(0.0f, 0.0f, -4.0f, 8.0f, 0.0f, 6.0f), PartPose.m_171423_((float)0.3f, (float)21.4f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("wing_left", CubeListBuilder.m_171558_().m_171514_(4, 26).m_171481_(0.0f, 0.0f, -1.0f, 8.0f, 0.0f, 6.0f), PartPose.m_171423_((float)0.3f, (float)21.5f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("wing_left_back", CubeListBuilder.m_171558_().m_171514_(4, 0).m_171481_(0.0f, 0.0f, -1.0f, 5.0f, 0.0f, 8.0f), PartPose.m_171423_((float)0.3f, (float)21.2f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.5934119f));
        root.m_171599_("wing_right_front", CubeListBuilder.m_171558_().m_171514_(4, 8).m_171481_(-8.0f, 0.0f, -4.0f, 8.0f, 0.0f, 6.0f), PartPose.m_171423_((float)-0.3f, (float)21.4f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("wing_right", CubeListBuilder.m_171558_().m_171514_(4, 14).m_171481_(-8.0f, 0.0f, -1.0f, 8.0f, 0.0f, 6.0f), PartPose.m_171423_((float)-0.3f, (float)21.5f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("wing_right_back", CubeListBuilder.m_171558_().m_171514_(14, 0).m_171481_(-5.0f, 0.0f, -1.0f, 5.0f, 0.0f, 8.0f), PartPose.m_171423_((float)0.3f, (float)21.2f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.5934119f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }

    public void prepareMobModel(T p_102614_, float p_102615_, float p_102616_, float p_102617_) {
        this.getIsFlying = ((MoCEntityInsect)p_102614_).getIsFlying() || p_102614_.m_20184_().f_82480_ < -0.1;
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float legMovB;
        float legMov;
        float f2a = ageInTicks % 100.0f;
        float wingRot = 0.0f;
        if (((MoCEntityInsect)entityIn).getIsFlying() || entityIn.m_20184_().f_82480_ < -0.1) {
            wingRot = Mth.m_14089_((float)(ageInTicks * 0.9f)) * 0.9f;
            legMovB = legMov = limbSwingAmount * 1.5f;
        } else {
            legMov = Mth.m_14089_((float)(limbSwing * 1.5f + (float)Math.PI)) * 2.0f * limbSwingAmount;
            legMovB = Mth.m_14089_((float)(limbSwing * 1.5f)) * 2.0f * limbSwingAmount;
            if (f2a > 40.0f && f2a < 60.0f) {
                wingRot = Mth.m_14089_((float)(ageInTicks * 0.15f)) * 0.9f;
            }
        }
        float baseAngle = 0.52359f;
        this.wing_left.f_104205_ = -baseAngle + wingRot;
        this.wing_right.f_104205_ = baseAngle - wingRot;
        this.wing_left_front.f_104205_ = -baseAngle + wingRot;
        this.wing_left_back.f_104205_ = 0.5934119f - baseAngle + wingRot;
        this.wing_right_front.f_104205_ = baseAngle - wingRot;
        this.wing_right_back.f_104205_ = -0.5934119f + baseAngle - wingRot;
        this.front_legs.f_104203_ = 0.1487144f + legMov;
        this.mid_legs.f_104203_ = 0.5948578f + legMovB;
        this.rear_legs.f_104203_ = 1.070744f + legMov;
        float headX = -headPitch * ((float)Math.PI / 180);
        float headY = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headX;
        this.head.f_104204_ = headY;
        this.mouth.f_104203_ = 0.6548599f;
        this.mouth.f_104204_ = 0.0f;
        this.right_antenna.f_104203_ = -1.041001f + headX;
        this.right_antenna.f_104204_ = 0.7853982f + headY;
        this.left_antenna.f_104203_ = -1.041001f + headX;
        this.left_antenna.f_104204_ = -0.7853982f + headY;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.abdomen.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.front_legs.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_antenna.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_antenna.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rear_legs.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.mid_legs.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.thorax.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.mouth.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        if (this.getIsFlying) {
            poseStack.m_85836_();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.clearColor((float)0.8f, (float)0.8f, (float)0.8f, (float)0.8f);
            this.wing_right.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.wing_left.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.wing_right_front.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.wing_left_front.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.wing_right_back.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.wing_left_back.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            RenderSystem.disableBlend();
            poseStack.m_85849_();
        } else {
            this.wing_right.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.wing_left.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.wing_right_front.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.wing_left_front.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.wing_right_back.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.wing_left_back.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }
}

