/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import drzhark.mocreatures.entity.passive.MoCEntityDuck;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoCModelDuck<T extends MoCEntityDuck>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("mocreatures", "duck"), "main");
    private final ModelPart head;
    private final ModelPart bill;
    private final ModelPart chin;
    private final ModelPart body;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart rightWing;
    private final ModelPart leftWing;

    public MoCModelDuck(ModelPart root) {
        this.head = root.m_171324_("head");
        this.bill = root.m_171324_("bill");
        this.chin = root.m_171324_("chin");
        this.body = root.m_171324_("body");
        this.rightLeg = root.m_171324_("rightLeg");
        this.leftLeg = root.m_171324_("leftLeg");
        this.rightWing = root.m_171324_("rightWing");
        this.leftWing = root.m_171324_("leftWing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, -6.0f, -2.0f, 4.0f, 6.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)-4.0f));
        root.m_171599_("bill", CubeListBuilder.m_171558_().m_171514_(14, 0).m_171481_(-2.0f, -4.0f, -4.0f, 4.0f, 2.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)-4.0f));
        root.m_171599_("chin", CubeListBuilder.m_171558_().m_171514_(14, 4).m_171481_(-1.0f, -2.0f, -3.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)-4.0f));
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171481_(-3.0f, -4.0f, -3.0f, 6.0f, 8.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)0.0f));
        root.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171481_(-1.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f), PartPose.m_171419_((float)-2.0f, (float)19.0f, (float)1.0f));
        root.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171481_(-1.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f), PartPose.m_171419_((float)1.0f, (float)19.0f, (float)1.0f));
        root.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(24, 13).m_171481_(0.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f), PartPose.m_171419_((float)-4.0f, (float)13.0f, (float)0.0f));
        root.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(24, 13).m_171481_(-1.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f), PartPose.m_171419_((float)4.0f, (float)13.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = -headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.bill.f_104203_ = this.head.f_104203_;
        this.bill.f_104204_ = this.head.f_104204_;
        this.chin.f_104203_ = this.head.f_104203_;
        this.chin.f_104204_ = this.head.f_104204_;
        this.body.f_104203_ = 1.5707964f;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        if (!entity.m_20096_()) {
            float WingRot = Mth.m_14089_((float)(ageInTicks * 1.4f + (float)Math.PI)) * 0.6f;
            this.rightWing.f_104205_ = 0.5f + WingRot;
            this.leftWing.f_104205_ = -0.5f - WingRot;
        } else {
            this.rightWing.f_104205_ = 0.0f;
            this.leftWing.f_104205_ = 0.0f;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.bill.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.chin.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightWing.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftWing.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

