/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.model;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import drzhark.mocreatures.entity.MoCEntityInsect;
import drzhark.mocreatures.entity.ambient.MoCEntityFirefly;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoCModelFirefly<T extends MoCEntityFirefly>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("mocreatures", "firefly"), "main");
    private final ModelPart antenna;
    private final ModelPart rearLegs;
    private final ModelPart midLegs;
    private final ModelPart head;
    private final ModelPart tail;
    private final ModelPart abdomen;
    private final ModelPart frontLegs;
    private final ModelPart rightShellOpen;
    private final ModelPart leftShellOpen;
    private final ModelPart thorax;
    private final ModelPart rightShell;
    private final ModelPart leftShell;
    private final ModelPart leftWing;
    private final ModelPart rightWing;
    private boolean flying;
    private boolean day;

    public MoCModelFirefly(ModelPart root) {
        this.head = root.m_171324_("head");
        this.antenna = root.m_171324_("antenna");
        this.thorax = root.m_171324_("thorax");
        this.abdomen = root.m_171324_("abdomen");
        this.tail = root.m_171324_("tail");
        this.frontLegs = root.m_171324_("front_legs");
        this.midLegs = root.m_171324_("mid_legs");
        this.rearLegs = root.m_171324_("rear_legs");
        this.rightShellOpen = root.m_171324_("right_shell_open");
        this.leftShellOpen = root.m_171324_("left_shell_open");
        this.rightShell = root.m_171324_("right_shell");
        this.leftShell = root.m_171324_("left_shell");
        this.leftWing = root.m_171324_("left_wing");
        this.rightWing = root.m_171324_("right_wing");
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float legMovB;
        float legMov;
        this.flying = ((MoCEntityInsect)entity).getIsFlying() || entity.m_20184_().f_82480_ < -0.1;
        this.day = entity.m_9236_().m_46461_();
        float frontLegAdj = 0.0f;
        if (this.flying) {
            float wingRot;
            this.rightWing.f_104205_ = wingRot = Mth.m_14089_((float)(ageInTicks * 1.8f)) * 0.8f;
            this.leftWing.f_104205_ = -wingRot;
            legMovB = legMov = limbSwingAmount * 1.5f;
            frontLegAdj = 1.4f;
        } else {
            legMov = Mth.m_14089_((float)(limbSwing * 1.5f + (float)Math.PI)) * 2.0f * limbSwingAmount;
            legMovB = Mth.m_14089_((float)(limbSwing * 1.5f)) * 2.0f * limbSwingAmount;
        }
        this.frontLegs.f_104203_ = -0.8328009f + frontLegAdj + legMov;
        this.midLegs.f_104203_ = 1.070744f + legMovB;
        this.rearLegs.f_104203_ = 1.249201f + legMov;
        if (!this.flying) {
            this.frontLegs.f_104204_ = 0.0f;
            this.midLegs.f_104204_ = 0.0f;
            this.rearLegs.f_104204_ = 0.0f;
        }
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104205_ = 0.0f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.antenna.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rearLegs.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.midLegs.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.abdomen.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.frontLegs.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.thorax.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tail.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        if (!this.flying) {
            this.rightShell.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.leftShell.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        } else {
            this.rightShellOpen.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.leftShellOpen.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.m_85836_();
            RenderSystem.enableBlend();
            float transparency = 0.6f;
            RenderSystem.defaultBlendFunc();
            RenderSystem.clearColor((float)0.8f, (float)0.8f, (float)0.8f, (float)transparency);
            this.leftWing.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.rightWing.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            RenderSystem.disableBlend();
            poseStack.m_85849_();
        }
        poseStack.m_85836_();
        RenderSystem.enableBlend();
        if (!this.day) {
            float alphaGlow = 0.4f;
            RenderSystem.defaultBlendFunc();
            RenderSystem.clearColor((float)0.8f, (float)0.8f, (float)0.8f, (float)alphaGlow);
        } else {
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 4).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)22.5f, (float)-2.0f, (float)-2.171231f, (float)0.0f, (float)0.0f));
        root.m_171599_("antenna", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)22.5f, (float)-3.0f, (float)-1.665602f, (float)0.0f, (float)0.0f));
        root.m_171599_("thorax", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)-1.0f));
        root.m_171599_("abdomen", CubeListBuilder.m_171558_().m_171514_(8, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)22.0f, (float)0.0f, (float)1.427659f, (float)0.0f, (float)0.0f));
        root.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(8, 17).m_171488_(-1.0f, 0.5f, -1.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)21.3f, (float)1.5f, (float)1.13023f, (float)0.0f, (float)0.0f));
        root.m_171599_("front_legs", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)23.0f, (float)-1.8f, (float)-0.8328009f, (float)0.0f, (float)0.0f));
        root.m_171599_("mid_legs", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)23.0f, (float)-1.2f, (float)1.070744f, (float)0.0f, (float)0.0f));
        root.m_171599_("rear_legs", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)23.0f, (float)-0.4f, (float)1.249201f, (float)0.0f, (float)0.0f));
        root.m_171599_("right_shell_open", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)21.0f, (float)-2.0f, (float)1.22f, (float)0.0f, (float)-0.6457718f));
        root.m_171599_("left_shell_open", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)21.0f, (float)-2.0f, (float)1.22f, (float)0.0f, (float)0.6457718f));
        root.m_171599_("right_shell", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)21.0f, (float)-2.0f, (float)0.0174533f, (float)0.0f, (float)-0.6457718f));
        root.m_171599_("left_shell", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)21.0f, (float)-2.0f, (float)0.0174533f, (float)0.0f, (float)0.6457718f));
        root.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(15, 12).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)21.0f, (float)-1.0f, (float)0.0f, (float)1.047198f, (float)0.0f));
        root.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(15, 12).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)21.0f, (float)-1.0f, (float)0.0f, (float)-1.047198f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }
}

