/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.model;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import drzhark.mocreatures.entity.MoCEntityInsect;
import drzhark.mocreatures.entity.ambient.MoCEntityFly;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoCModelFly<T extends MoCEntityFly>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("mocreatures", "fly"), "main");
    private final ModelPart frontLegs;
    private final ModelPart rearLegs;
    private final ModelPart midLegs;
    private final ModelPart foldedWings;
    private final ModelPart head;
    private final ModelPart tail;
    private final ModelPart abdomen;
    private final ModelPart rightWing;
    private final ModelPart thorax;
    private final ModelPart leftWing;
    private boolean flying;

    public MoCModelFly(ModelPart root) {
        this.frontLegs = root.m_171324_("front_legs");
        this.rearLegs = root.m_171324_("rear_legs");
        this.midLegs = root.m_171324_("mid_legs");
        this.foldedWings = root.m_171324_("folded_wings");
        this.head = root.m_171324_("head");
        this.tail = root.m_171324_("tail");
        this.abdomen = root.m_171324_("abdomen");
        this.rightWing = root.m_171324_("right_wing");
        this.thorax = root.m_171324_("thorax");
        this.leftWing = root.m_171324_("left_wing");
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float legMovB;
        float legMov;
        float wingRot;
        this.flying = ((MoCEntityInsect)entity).getIsFlying() || entity.m_20184_().f_82480_ < -0.1;
        this.rightWing.f_104205_ = wingRot = Mth.m_14089_((float)(ageInTicks * 3.0f)) * 0.7f;
        this.leftWing.f_104205_ = -wingRot;
        if (this.flying) {
            legMovB = legMov = limbSwingAmount * 1.5f;
        } else {
            legMov = Mth.m_14089_((float)(limbSwing * 1.5f + (float)Math.PI)) * 2.0f * limbSwingAmount;
            legMovB = Mth.m_14089_((float)(limbSwing * 1.5f)) * 2.0f * limbSwingAmount;
        }
        this.frontLegs.f_104203_ = 0.1487144f + legMov;
        this.midLegs.f_104203_ = 0.5948578f + legMovB;
        this.rearLegs.f_104203_ = 1.070744f + legMov;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.frontLegs.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rearLegs.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.midLegs.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tail.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.abdomen.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.thorax.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        if (!this.flying) {
            this.foldedWings.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        } else {
            poseStack.m_85836_();
            RenderSystem.enableBlend();
            float transparency = 0.6f;
            RenderSystem.defaultBlendFunc();
            RenderSystem.clearColor((float)0.8f, (float)0.8f, (float)0.8f, (float)transparency);
            this.leftWing.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.rightWing.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            RenderSystem.disableBlend();
            poseStack.m_85849_();
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 4).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)21.5f, (float)-2.0f, (float)-2.171231f, (float)0.0f, (float)0.0f));
        root.m_171599_("thorax", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)20.5f, (float)-1.0f));
        root.m_171599_("abdomen", CubeListBuilder.m_171558_().m_171514_(8, 0).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)21.5f, (float)0.0f, (float)1.427659f, (float)0.0f, (float)0.0f));
        root.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(10, 2).m_171488_(-1.0f, 0.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)21.2f, (float)1.5f, (float)1.427659f, (float)0.0f, (float)0.0f));
        root.m_171599_("front_legs", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)22.5f, (float)-1.8f, (float)0.1487144f, (float)0.0f, (float)0.0f));
        root.m_171599_("rear_legs", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)22.5f, (float)-0.4f, (float)1.070744f, (float)0.0f, (float)0.0f));
        root.m_171599_("mid_legs", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)22.5f, (float)-1.2f, (float)0.5948578f, (float)0.0f, (float)0.0f));
        root.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(4, 4).m_171488_(-1.0f, 0.0f, 0.5f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)20.4f, (float)-1.0f, (float)0.0f, (float)1.047198f, (float)0.0f));
        root.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(4, 4).m_171488_(-1.0f, 0.0f, 0.5f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)20.4f, (float)-1.0f, (float)0.0f, (float)-1.047198f, (float)0.0f));
        root.m_171599_("folded_wings", CubeListBuilder.m_171558_().m_171514_(4, 4).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)20.5f, (float)-2.0f, (float)0.0872665f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }
}

