/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import drzhark.mocreatures.entity.hostile.MoCEntityGolem;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoCModelGolem<T extends MoCEntityGolem>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("mocreatures", "golem"), "main");
    private final ModelPart[][] blocks;
    private final ModelPart head;
    private final ModelPart headb;
    private final ModelPart chest;
    private final ModelPart chestb;
    private final float radianF = 57.29578f;
    private final int w = 32;
    private final int h = 16;
    private final int[] blocksText = new int[23];
    private MoCEntityGolem entityG;
    private boolean angry;

    public MoCModelGolem(ModelPart root) {
        this.blocks = new ModelPart[23][28];
        this.head = root.m_171324_("head");
        this.headb = root.m_171324_("headb");
        this.chest = root.m_171324_("chest");
        this.chestb = root.m_171324_("chestb");
        for (int g = 0; g < 23; ++g) {
            ModelPart groupPart = root.m_171324_("group_" + g);
            for (int v = 0; v < 28; ++v) {
                this.blocks[g][v] = groupPart.m_171324_("block_" + g + "_" + v);
            }
        }
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelPart p;
        float headYawRad;
        for (int i = 0; i < 23; ++i) {
            this.blocksText[i] = ((MoCEntityGolem)entity).getBlockText(i);
        }
        this.head.f_104204_ = headYawRad = (45.0f + netHeadYaw) / this.radianF;
        this.headb.f_104204_ = headYawRad;
        boolean isSummoning = ((MoCEntityGolem)entity).isMissingCubes();
        float chestYaw = 45.0f / this.radianF;
        if (isSummoning) {
            chestYaw += ageInTicks / 2.0f;
        }
        this.chest.f_104204_ = chestYaw;
        this.chestb.f_104204_ = chestYaw;
        boolean openChest = ((MoCEntityGolem)entity).openChest();
        if (openChest) {
            this.chest.m_104227_(0.0f, -3.0f, -7.0f);
            this.chestb.m_104227_(0.0f, -3.0f, -7.0f);
            if (this.blocksText[0] != 30) {
                this.blocks[0][this.blocksText[0]].f_104204_ = -60.0f / this.radianF;
            }
            if (this.blocksText[1] != 30) {
                this.blocks[1][this.blocksText[1]].f_104204_ = -55.0f / this.radianF;
            }
            if (this.blocksText[2] != 30) {
                this.blocks[2][this.blocksText[2]].f_104204_ = 60.0f / this.radianF;
            }
            if (this.blocksText[3] != 30) {
                this.blocks[3][this.blocksText[3]].f_104204_ = 55.0f / this.radianF;
            }
        } else {
            this.chest.m_104227_(0.0f, -3.0f, -4.0f);
            this.chestb.m_104227_(0.0f, -3.0f, -4.0f);
            if (this.blocksText[0] != 30) {
                this.blocks[0][this.blocksText[0]].f_104204_ = -40.0f / this.radianF;
            }
            if (this.blocksText[1] != 30) {
                this.blocks[1][this.blocksText[1]].f_104204_ = -41.0f / this.radianF;
            }
            if (this.blocksText[2] != 30) {
                this.blocks[2][this.blocksText[2]].f_104204_ = 40.0f / this.radianF;
            }
            if (this.blocksText[3] != 30) {
                this.blocks[3][this.blocksText[3]].f_104204_ = 41.0f / this.radianF;
            }
        }
        float RLegXRot = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.2f * limbSwingAmount;
        float LLegXRot = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.2f * limbSwingAmount;
        if (this.blocksText[15] != 30) {
            this.blocks[15][this.blocksText[15]].f_104203_ = -20.0f / this.radianF + LLegXRot;
        }
        if (this.blocksText[16] != 30) {
            this.blocks[16][this.blocksText[16]].f_104203_ = LLegXRot;
        }
        if (this.blocksText[17] != 30) {
            this.blocks[17][this.blocksText[17]].f_104203_ = LLegXRot;
        }
        if (this.blocksText[18] != 30) {
            this.blocks[18][this.blocksText[18]].f_104203_ = -20.0f / this.radianF + RLegXRot;
        }
        if (this.blocksText[19] != 30) {
            this.blocks[19][this.blocksText[19]].f_104203_ = RLegXRot;
        }
        if (this.blocksText[20] != 30) {
            this.blocks[20][this.blocksText[20]].f_104203_ = RLegXRot;
        }
        boolean throwing = ((MoCEntityGolem)entity).tCounter > 25;
        float RArmZRot = -(Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f) + 0.05f;
        float LArmZRot = Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f - 0.05f;
        if (throwing) {
            LLegXRot = -90.0f / this.radianF;
            RLegXRot = -90.0f / this.radianF;
            RArmZRot = 0.0f;
            LArmZRot = 0.0f;
        }
        if (this.blocksText[12] != 30) {
            p = this.blocks[12][this.blocksText[12]];
            p.f_104205_ = 40.0f / this.radianF + RArmZRot;
            p.f_104203_ = LLegXRot;
        }
        if (this.blocksText[13] != 30) {
            p = this.blocks[13][this.blocksText[13]];
            p.f_104205_ = 12.0f / this.radianF + RArmZRot;
            p.f_104203_ = LLegXRot;
        }
        if (this.blocksText[14] != 30) {
            p = this.blocks[14][this.blocksText[14]];
            p.f_104205_ = RArmZRot;
            p.f_104203_ = LLegXRot;
        }
        if (this.blocksText[9] != 30) {
            p = this.blocks[9][this.blocksText[9]];
            p.f_104205_ = -40.0f / this.radianF + LArmZRot;
            p.f_104203_ = RLegXRot;
        }
        if (this.blocksText[10] != 30) {
            p = this.blocks[10][this.blocksText[10]];
            p.f_104205_ = -12.0f / this.radianF + LArmZRot;
            p.f_104203_ = RLegXRot;
        }
        if (this.blocksText[11] != 30) {
            p = this.blocks[11][this.blocksText[11]];
            p.f_104205_ = LArmZRot;
            p.f_104203_ = RLegXRot;
        }
    }

    public void prepareMobModel(T p_102614_, float p_102615_, float p_102616_, float p_102617_) {
        this.entityG = p_102614_;
        this.angry = ((MoCEntityGolem)p_102614_).getGolemState() > 1;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float yOffset = this.entityG.getAdjustedYOffset();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, yOffset, 0.0f);
        for (int g = 0; g < 23; ++g) {
            int idx = this.blocksText[g];
            if (idx == 30) continue;
            this.blocks[g][idx].m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        if (this.angry) {
            this.headb.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.chestb.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        } else {
            this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.chest.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        poseStack.m_85849_();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(96, 64).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-10.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        root.m_171599_("headb", CubeListBuilder.m_171558_().m_171514_(96, 80).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-10.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        root.m_171599_("chest", CubeListBuilder.m_171558_().m_171514_(96, 96).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)-7.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        root.m_171599_("chestb", CubeListBuilder.m_171558_().m_171514_(96, 112).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)-7.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        for (int g = 0; g < 23; ++g) {
            PartDefinition groupPart = root.m_171599_("group_" + g, CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
            for (int v = 0; v < 28; ++v) {
                int textX = v / 8 * 32;
                int textY = v % 8 * 16;
                CubeListBuilder builder = CubeListBuilder.m_171558_().m_171514_(textX, textY);
                groupPart.m_171599_("block_" + g + "_" + v, builder, switch (g) {
                    case 0 -> {
                        builder.m_171488_(-4.0f, 3.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)-1.6929693f, (float)-0.6981317f, (float)0.0f);
                    }
                    case 1 -> {
                        builder.m_171488_(-4.0f, 3.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)-0.9599311f, (float)-0.715585f, (float)0.0f);
                    }
                    case 2 -> {
                        builder.m_171488_(-4.0f, 3.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)-1.6929693f, (float)0.6981317f, (float)0.0f);
                    }
                    case 3 -> {
                        builder.m_171488_(-4.0f, 3.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)-0.9599311f, (float)0.715585f, (float)0.0f);
                    }
                    case 4 -> {
                        builder.m_171488_(-7.0f, -14.0f, -1.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171423_((float)0.0f, (float)6.0f, (float)3.0f, (float)0.0f, (float)0.7853981f, (float)0.0f);
                    }
                    case 5 -> {
                        builder.m_171488_(-4.0f, 3.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)1.9198622f, (float)0.6981317f, (float)0.0f);
                    }
                    case 6 -> {
                        builder.m_171488_(-4.0f, 3.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)1.1833333f, (float)0.6981317f, (float)0.0f);
                    }
                    case 7 -> {
                        builder.m_171488_(-4.0f, 3.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)1.9198622f, (float)-0.6981317f, (float)0.0f);
                    }
                    case 8 -> {
                        builder.m_171488_(-4.0f, 3.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)0.0f, (float)1.1833333f, (float)-0.6981317f, (float)0.0f);
                    }
                    case 9 -> {
                        builder.m_171488_(0.0f, -2.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171423_((float)8.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6981317f);
                    }
                    case 10 -> {
                        builder.m_171488_(2.0f, 4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171423_((float)8.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2094395f);
                    }
                    case 11 -> {
                        builder.m_171488_(4.5f, 11.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171419_((float)8.0f, (float)-3.0f, (float)0.0f);
                    }
                    case 12 -> {
                        builder.m_171488_(-8.0f, -2.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171423_((float)-8.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6981317f);
                    }
                    case 13 -> {
                        builder.m_171488_(-10.0f, 4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171423_((float)-8.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2094395f);
                    }
                    case 14 -> {
                        builder.m_171488_(-12.5f, 11.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171419_((float)-8.0f, (float)-3.0f, (float)0.0f);
                    }
                    case 15 -> {
                        builder.m_171488_(-3.5f, 0.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171423_((float)5.0f, (float)4.0f, (float)0.0f, (float)-0.34906584f, (float)0.0f, (float)0.0f);
                    }
                    case 16 -> {
                        builder.m_171488_(-4.0f, 6.0f, -7.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171419_((float)5.0f, (float)4.0f, (float)0.0f);
                    }
                    case 17 -> {
                        builder.m_171488_(-3.5f, 12.0f, -5.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171419_((float)5.0f, (float)4.0f, (float)0.0f);
                    }
                    case 18 -> {
                        builder.m_171488_(-4.5f, 0.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171423_((float)-5.0f, (float)4.0f, (float)0.0f, (float)-0.34906584f, (float)0.0f, (float)0.0f);
                    }
                    case 19 -> {
                        builder.m_171488_(-4.0f, 6.0f, -7.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171419_((float)-5.0f, (float)4.0f, (float)0.0f);
                    }
                    case 20 -> {
                        builder.m_171488_(-4.5f, 12.0f, -5.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171419_((float)-5.0f, (float)4.0f, (float)0.0f);
                    }
                    case 21 -> {
                        builder.m_171488_(0.0f, -4.0f, -8.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171423_((float)0.0f, (float)6.0f, (float)3.0f, (float)0.0f, (float)0.7853981f, (float)0.0f);
                    }
                    case 22 -> {
                        builder.m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f));
                        yield PartPose.m_171423_((float)0.0f, (float)6.0f, (float)3.0f, (float)-0.74351025f, (float)0.0f, (float)0.0f);
                    }
                    default -> {
                        builder.m_171488_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, new CubeDeformation(0.0f));
                        yield PartPose.f_171404_;
                    }
                });
            }
        }
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)128);
    }
}

