/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import drzhark.mocreatures.entity.neutral.MoCEntityKitty;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoCModelKitty<T extends MoCEntityKitty>
extends EntityModel<T> {
    private ModelPart body;
    public boolean isSitting;
    public boolean isSwinging;
    public float swingProgress;
    public int kittystate;
    public ModelPart[] headParts;
    public ModelPart tail;
    public ModelPart rightArm;
    public ModelPart leftArm;
    public ModelPart rightLeg;
    public ModelPart leftLeg;
    private float inflation;
    private float yOffset;
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("mocreatures", "kitty"), "main");

    public MoCModelKitty() {
        this(0.0f);
    }

    public MoCModelKitty(float inflation) {
        this(inflation, 0.0f);
    }

    public MoCModelKitty(float inflation, float yOffset) {
        this.inflation = inflation;
        this.yOffset = yOffset;
        ModelPart root = MoCModelKitty.createBodyLayer(inflation, yOffset).m_171564_();
        this.setupParts(root);
    }

    public MoCModelKitty(ModelPart root, float inflation, float yOffset) {
        this.inflation = inflation;
        this.yOffset = yOffset;
        this.setupParts(root);
    }

    public MoCModelKitty(ModelPart root) {
        this.setupParts(root);
    }

    private void setupParts(ModelPart root) {
        this.headParts = new ModelPart[10];
        this.body = root.m_171324_("body");
        this.headParts[0] = root.m_171324_("head_0");
        this.headParts[1] = root.m_171324_("head_1");
        this.headParts[2] = root.m_171324_("head_2");
        this.headParts[3] = root.m_171324_("head_3");
        this.headParts[4] = root.m_171324_("head_4");
        this.headParts[5] = root.m_171324_("head_5");
        this.headParts[6] = root.m_171324_("head_6");
        this.headParts[7] = root.m_171324_("head_7");
        this.headParts[8] = root.m_171324_("head_8");
        this.headParts[9] = root.m_171324_("head_9");
        this.tail = root.m_171324_("tail");
        this.rightArm = root.m_171324_("right_arm");
        this.leftArm = root.m_171324_("left_arm");
        this.rightLeg = root.m_171324_("right_leg");
        this.leftLeg = root.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        return MoCModelKitty.createBodyLayer(0.0f, 0.0f);
    }

    public static LayerDefinition createBodyLayer(float inflation, float yOffset) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("head_0", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171488_(-2.0f, -5.0f, -3.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(inflation)), PartPose.m_171419_((float)0.0f, (float)(0.0f + yOffset), (float)-2.0f));
        partdefinition.m_171599_("head_1", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171555_(true).m_171488_(1.0f, -5.0f, -3.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(inflation)), PartPose.m_171419_((float)0.0f, (float)(0.0f + yOffset), (float)-2.0f));
        partdefinition.m_171599_("head_2", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171488_(-2.5f, -4.0f, -3.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(inflation)), PartPose.m_171419_((float)0.0f, (float)(0.0f + yOffset), (float)-2.0f));
        partdefinition.m_171599_("head_3", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171555_(true).m_171488_(0.5f, -4.0f, -3.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(inflation)), PartPose.m_171419_((float)0.0f, (float)(0.0f + yOffset), (float)-2.0f));
        partdefinition.m_171599_("head_4", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-4.0f, -1.5f, -5.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(inflation)), PartPose.m_171419_((float)0.0f, (float)(0.0f + yOffset), (float)-2.0f));
        partdefinition.m_171599_("head_5", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171555_(true).m_171488_(1.0f, -1.5f, -5.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(inflation)), PartPose.m_171419_((float)0.0f, (float)(0.0f + yOffset), (float)-2.0f));
        partdefinition.m_171599_("head_6", CubeListBuilder.m_171558_().m_171514_(21, 6).m_171488_(-1.0f, -1.0f, -5.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(inflation)), PartPose.m_171419_((float)0.0f, (float)(0.0f + yOffset), (float)-2.0f));
        partdefinition.m_171599_("head_7", CubeListBuilder.m_171558_().m_171514_(50, 0).m_171488_(-2.5f, 0.5f, -1.0f, 5.0f, 4.0f, 1.0f, new CubeDeformation(inflation)), PartPose.m_171419_((float)0.0f, (float)(0.0f + yOffset), (float)-2.0f));
        partdefinition.m_171599_("head_8", CubeListBuilder.m_171558_().m_171514_(60, 0).m_171488_(-1.5f, -2.0f, -4.1f, 3.0f, 1.0f, 1.0f, new CubeDeformation(inflation)), PartPose.m_171419_((float)0.0f, (float)(0.0f + yOffset), (float)-2.0f));
        partdefinition.m_171599_("head_9", CubeListBuilder.m_171558_().m_171514_(1, 1).m_171488_(-2.5f, -3.0f, -4.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(inflation)), PartPose.m_171419_((float)0.0f, (float)(0.0f + yOffset), (float)-2.0f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171488_(-2.5f, -2.0f, -0.0f, 5.0f, 5.0f, 10.0f, new CubeDeformation(inflation)), PartPose.m_171419_((float)0.0f, (float)(0.0f + yOffset), (float)-2.0f));
        partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(inflation)), PartPose.m_171419_((float)-1.5f, (float)(3.0f + yOffset), (float)-1.0f));
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171555_(true).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(inflation)), PartPose.m_171419_((float)1.5f, (float)(3.0f + yOffset), (float)-1.0f));
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(8, 9).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(inflation)), PartPose.m_171419_((float)-1.5f, (float)(3.0f + yOffset), (float)7.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(8, 9).m_171555_(true).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(inflation)), PartPose.m_171419_((float)1.5f, (float)(3.0f + yOffset), (float)7.0f));
        partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(16, 9).m_171555_(true).m_171488_(-0.5f, -8.0f, -1.0f, 1.0f, 8.0f, 1.0f, new CubeDeformation(inflation)), PartPose.m_171419_((float)0.0f, (float)(-0.5f + yOffset), (float)7.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.isSitting = ((MoCEntityKitty)entityIn).getIsSitting();
        this.isSwinging = ((MoCEntityKitty)entityIn).getIsSwinging();
        this.swingProgress = ((MoCEntityKitty)entityIn).f_20921_;
        this.kittystate = ((MoCEntityKitty)entityIn).getKittyState();
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float clampedYaw = Mth.m_14036_((float)netHeadYaw, (float)-45.0f, (float)45.0f);
        float clampedPitch = Mth.m_14036_((float)headPitch, (float)-30.0f, (float)30.0f);
        this.headParts[9].f_104204_ = (float)((double)clampedYaw * Math.PI / 180.0);
        this.headParts[9].f_104203_ = (float)((double)clampedPitch * Math.PI / 180.0);
        for (int i = 0; i < 9; ++i) {
            this.headParts[i].f_104204_ = this.headParts[9].f_104204_;
            this.headParts[i].f_104203_ = this.headParts[9].f_104203_;
        }
        this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + 3.141593f)) * 2.0f * limbSwingAmount * 0.5f;
        this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.rightArm.f_104205_ = 0.0f;
        this.leftArm.f_104205_ = 0.0f;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + 3.141593f)) * 1.4f * limbSwingAmount;
        this.rightLeg.f_104204_ = 0.0f;
        this.leftLeg.f_104204_ = 0.0f;
        if (this.isSwinging) {
            this.rightArm.f_104203_ = -2.0f + this.swingProgress;
            this.rightArm.f_104204_ = 2.25f - this.swingProgress * 2.0f;
        } else {
            this.rightArm.f_104204_ = 0.0f;
        }
        this.leftArm.f_104204_ = 0.0f;
        this.tail.f_104203_ = -0.5f;
        this.tail.f_104205_ = this.leftLeg.f_104203_ * 0.625f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        if (this.isSitting) {
            poseStack.m_252880_(0.0f, 0.25f, 0.0f);
            this.tail.f_104205_ = 0.0f;
            this.tail.f_104203_ = -2.3f;
        }
        for (int i = 0; i < 7; ++i) {
            this.headParts[i].m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        if (this.kittystate > 2) {
            this.headParts[7].m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        if (this.kittystate == 12) {
            this.headParts[8].m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        this.headParts[9].m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tail.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        if (this.isSitting) {
            float f6;
            poseStack.m_252880_(0.0f, 0.0625f, 0.0625f);
            this.rightArm.f_104203_ = f6 = -1.570796f;
            this.leftArm.f_104203_ = f6;
            this.rightLeg.f_104203_ = f6;
            this.leftLeg.f_104203_ = f6;
            this.rightLeg.f_104204_ = 0.1f;
            this.leftLeg.f_104204_ = -0.1f;
        }
        this.rightArm.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftArm.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }
}

