/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.model;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import drzhark.mocreatures.entity.ambient.MoCEntityMaggot;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoCModelMaggot<T extends MoCEntityMaggot>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("mocreatures", "maggot"), "main");
    private float limbSwing;
    private float limbSwingAmount;
    private final ModelPart Head;
    private final ModelPart Body;
    private final ModelPart Tail;
    private final ModelPart Tailtip;

    public MoCModelMaggot(ModelPart root) {
        this.Head = root.m_171324_("Head");
        this.Body = root.m_171324_("Body");
        this.Tail = root.m_171324_("Tail");
        this.Tailtip = root.m_171324_("Tailtip");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.m_171576_();
        part.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)-2.0f));
        part.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -2.0f, 0.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)-2.0f));
        part.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)2.0f));
        part.m_171599_("Tailtip", CubeListBuilder.m_171558_().m_171514_(8, 7).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.limbSwing = limbSwing;
        this.limbSwingAmount = limbSwingAmount;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float f9 = -Mth.m_14089_((float)(this.limbSwing * 3.0f)) * this.limbSwingAmount * 2.0f;
        poseStack.m_85841_(1.0f, 1.0f, 1.0f + f9);
        this.Head.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Body.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Tail.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Tailtip.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }
}

