/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import drzhark.mocreatures.entity.hostile.MoCEntityMiniGolem;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoCModelMiniGolem<T extends MoCEntityMiniGolem>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("mocreatures", "mini_golem"), "main");
    private static final float RADIAN_CONV = 57.29578f;
    private final ModelPart Head;
    private final ModelPart HeadRed;
    private final ModelPart Body;
    private final ModelPart BodyRed;
    private final ModelPart LeftShoulder;
    private final ModelPart LeftArm;
    private final ModelPart LeftArmRingA;
    private final ModelPart LeftArmRingB;
    private final ModelPart RightShoulder;
    private final ModelPart RightArm;
    private final ModelPart RightArmRingA;
    private final ModelPart RightArmRingB;
    private final ModelPart RightLeg;
    private final ModelPart RightFoot;
    private final ModelPart LeftLeg;
    private final ModelPart LeftFoot;
    private boolean angry;

    public MoCModelMiniGolem(ModelPart root) {
        this.Head = root.m_171324_("Head");
        this.HeadRed = root.m_171324_("HeadRed");
        this.Body = root.m_171324_("Body");
        this.BodyRed = root.m_171324_("BodyRed");
        this.LeftShoulder = root.m_171324_("LeftShoulder");
        this.LeftArm = root.m_171324_("LeftArm");
        this.LeftArmRingA = root.m_171324_("LeftArmRingA");
        this.LeftArmRingB = root.m_171324_("LeftArmRingB");
        this.RightShoulder = root.m_171324_("RightShoulder");
        this.RightArm = root.m_171324_("RightArm");
        this.RightArmRingA = root.m_171324_("RightArmRingA");
        this.RightArmRingB = root.m_171324_("RightArmRingB");
        this.RightLeg = root.m_171324_("RightLeg");
        this.RightFoot = root.m_171324_("RightFoot");
        this.LeftLeg = root.m_171324_("LeftLeg");
        this.LeftFoot = root.m_171324_("LeftFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(30, 0).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        root.m_171599_("HeadRed", CubeListBuilder.m_171558_().m_171514_(30, 29).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        root.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -10.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)0.0f));
        root.m_171599_("BodyRed", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-5.0f, -10.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)0.0f));
        root.m_171599_("LeftShoulder", CubeListBuilder.m_171558_().m_171514_(0, 4).m_171488_(0.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)11.0f, (float)0.0f));
        root.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)11.0f, (float)0.0f));
        root.m_171599_("LeftArmRingA", CubeListBuilder.m_171558_().m_171514_(20, 20).m_171488_(0.5f, 1.0f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)11.0f, (float)0.0f));
        root.m_171599_("LeftArmRingB", CubeListBuilder.m_171558_().m_171514_(20, 20).m_171488_(0.5f, 5.0f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)11.0f, (float)0.0f));
        root.m_171599_("RightShoulder", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)11.0f, (float)0.0f));
        root.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171488_(-5.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)11.0f, (float)0.0f));
        root.m_171599_("RightArmRingA", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-5.5f, 1.0f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)11.0f, (float)0.0f));
        root.m_171599_("RightArmRingB", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-5.5f, 5.0f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)11.0f, (float)0.0f));
        root.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(40, 9).m_171488_(-2.5f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)18.0f, (float)0.0f));
        root.m_171599_("RightFoot", CubeListBuilder.m_171558_().m_171514_(15, 22).m_171488_(-2.5f, 5.0f, -3.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)18.0f, (float)0.0f));
        root.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(40, 19).m_171488_(-1.5f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)18.0f, (float)0.0f));
        root.m_171599_("LeftFoot", CubeListBuilder.m_171558_().m_171514_(15, 20).m_171488_(-1.5f, 5.0f, -3.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)18.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.angry = entity.m_5912_();
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float hRotY = netHeadYaw / 57.29578f;
        float RLegXRot = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        float LLegXRot = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount;
        this.RightLeg.f_104203_ = RLegXRot;
        this.RightFoot.f_104203_ = RLegXRot;
        this.LeftLeg.f_104203_ = LLegXRot;
        this.LeftFoot.f_104203_ = LLegXRot;
        this.Head.f_104204_ = -0.7853982f + hRotY;
        this.HeadRed.f_104204_ = -0.7853982f + hRotY;
        if (((MoCEntityMiniGolem)entity).getHasRock()) {
            this.LeftShoulder.f_104205_ = 0.0f;
            this.LeftShoulder.f_104203_ = (float)(-Math.PI);
            this.RightShoulder.f_104205_ = 0.0f;
            this.RightShoulder.f_104203_ = (float)(-Math.PI);
        } else {
            this.LeftShoulder.f_104205_ = Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f - 0.05f;
            this.LeftShoulder.f_104203_ = RLegXRot;
            this.RightShoulder.f_104205_ = -(Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f) + 0.05f;
            this.RightShoulder.f_104203_ = LLegXRot;
        }
        this.LeftArmRingA.f_104203_ = this.LeftArmRingB.f_104203_ = this.LeftShoulder.f_104203_;
        this.LeftArm.f_104203_ = this.LeftArmRingB.f_104203_;
        this.LeftArmRingA.f_104205_ = this.LeftArmRingB.f_104205_ = this.LeftShoulder.f_104205_;
        this.LeftArm.f_104205_ = this.LeftArmRingB.f_104205_;
        this.RightArmRingA.f_104203_ = this.RightArmRingB.f_104203_ = this.RightShoulder.f_104203_;
        this.RightArm.f_104203_ = this.RightArmRingB.f_104203_;
        this.RightArmRingA.f_104205_ = this.RightArmRingB.f_104205_ = this.RightShoulder.f_104205_;
        this.RightArm.f_104205_ = this.RightArmRingB.f_104205_;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.angry) {
            this.HeadRed.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.BodyRed.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        } else {
            this.Head.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.Body.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        this.LeftShoulder.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftArm.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftArmRingA.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftArmRingB.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightShoulder.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightArm.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightArmRingA.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightArmRingB.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightFoot.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftFoot.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

