/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import drzhark.mocreatures.entity.passive.MoCEntityMole;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoCModelMole<T extends MoCEntityMole>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("mocreatures", "mole"), "main");
    private final ModelPart Nose;
    private final ModelPart Head;
    private final ModelPart Body;
    private final ModelPart Back;
    private final ModelPart Tail;
    private final ModelPart LLeg;
    private final ModelPart LFingers;
    private final ModelPart RLeg;
    private final ModelPart RFingers;
    private final ModelPart LRearLeg;
    private final ModelPart RRearLeg;
    private float yOffset;
    private final float RADIAN_CONV = 57.29578f;

    public MoCModelMole(ModelPart root) {
        this.Nose = root.m_171324_("Nose");
        this.Head = root.m_171324_("Head");
        this.Body = root.m_171324_("Body");
        this.Back = root.m_171324_("Back");
        this.Tail = root.m_171324_("Tail");
        this.LLeg = root.m_171324_("LLeg");
        this.LFingers = root.m_171324_("LFingers");
        this.RLeg = root.m_171324_("RLeg");
        this.RFingers = root.m_171324_("RFingers");
        this.LRearLeg = root.m_171324_("LRearLeg");
        this.RRearLeg = root.m_171324_("RRearLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("Nose", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(-1.0f, 0.0f, -4.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)20.0f, (float)-6.0f, (float)0.2617994f, (float)0.0f, (float)0.0f));
        root.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-3.0f, -2.0f, -2.0f, 6.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)-6.0f));
        root.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, 0.0f, 0.0f, 10.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)-6.0f));
        root.m_171599_("Back", CubeListBuilder.m_171558_().m_171514_(18, 16).m_171488_(-4.0f, -3.0f, 0.0f, 8.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)4.0f));
        root.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(52, 8).m_171488_(-0.5f, 0.0f, 1.0f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)21.0f, (float)6.0f, (float)-0.3490659f, (float)0.0f, (float)0.0f));
        root.m_171599_("LLeg", CubeListBuilder.m_171558_().m_171514_(10, 25).m_171488_(0.0f, -2.0f, -1.0f, 6.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)21.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.2268928f));
        root.m_171599_("LFingers", CubeListBuilder.m_171558_().m_171514_(44, 8).m_171488_(5.0f, -2.0f, 1.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)21.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.2268928f));
        root.m_171599_("RLeg", CubeListBuilder.m_171558_().m_171514_(26, 25).m_171488_(-6.0f, -2.0f, -1.0f, 6.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)21.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)-0.2268928f));
        root.m_171599_("RFingers", CubeListBuilder.m_171558_().m_171514_(48, 8).m_171488_(-6.0f, -2.0f, 1.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)21.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)-0.2268928f));
        root.m_171599_("LRearLeg", CubeListBuilder.m_171558_().m_171514_(36, 0).m_171488_(0.0f, -2.0f, -1.0f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)22.0f, (float)5.0f, (float)-0.2792527f, (float)0.5235988f, (float)0.0f));
        root.m_171599_("RRearLeg", CubeListBuilder.m_171558_().m_171514_(50, 0).m_171488_(-2.0f, -2.0f, -1.0f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)22.0f, (float)5.0f, (float)-0.2792527f, (float)-0.5235988f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.yOffset = ((MoCEntityMole)entity).getAdjustedYOffset();
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.f_104204_ = netHeadYaw / 57.29578f;
        this.Head.f_104203_ = headPitch / 57.29578f;
        this.Nose.f_104203_ = 0.2617994f + this.Head.f_104203_;
        this.Nose.f_104204_ = this.Head.f_104204_;
        float RLegXRot = Mth.m_14089_((float)(limbSwing + (float)Math.PI)) * 0.8f * limbSwingAmount;
        float LLegXRot = Mth.m_14089_((float)limbSwing) * 0.8f * limbSwingAmount;
        this.RFingers.f_104204_ = this.RLeg.f_104204_ = RLegXRot;
        this.LFingers.f_104204_ = this.LLeg.f_104204_ = LLegXRot;
        this.RRearLeg.f_104204_ = -0.5235988f + LLegXRot;
        this.LRearLeg.f_104204_ = 0.5235988f + RLegXRot;
        this.Tail.f_104205_ = this.LLeg.f_104203_ * 0.625f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, this.yOffset, 0.0f);
        this.Nose.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Head.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Body.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Back.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Tail.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LFingers.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RFingers.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LRearLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RRearLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }
}

