/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import drzhark.mocreatures.entity.passive.MoCEntityMouse;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoCModelMouse<T extends MoCEntityMouse>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("mocreatures", "mouse"), "main");
    private static final float RADIAN_CONV = 57.29578f;
    private final ModelPart Head;
    private final ModelPart EarR;
    private final ModelPart EarL;
    private final ModelPart WhiskerR;
    private final ModelPart WhiskerL;
    private final ModelPart Tail;
    private final ModelPart FrontL;
    private final ModelPart FrontR;
    private final ModelPart RearL;
    private final ModelPart RearR;
    private final ModelPart BodyF;

    public MoCModelMouse(ModelPart root) {
        this.Head = root.m_171324_("Head");
        this.EarR = root.m_171324_("EarR");
        this.EarL = root.m_171324_("EarL");
        this.WhiskerR = root.m_171324_("WhiskerR");
        this.WhiskerL = root.m_171324_("WhiskerL");
        this.Tail = root.m_171324_("Tail");
        this.FrontL = root.m_171324_("FrontL");
        this.FrontR = root.m_171324_("FrontR");
        this.RearL = root.m_171324_("RearL");
        this.RearR = root.m_171324_("RearR");
        this.BodyF = root.m_171324_("BodyF");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -1.0f, -6.0f, 3.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)-6.0f));
        root.m_171599_("EarR", CubeListBuilder.m_171558_().m_171514_(16, 26).m_171488_(-3.5f, -3.0f, -1.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)-6.0f));
        root.m_171599_("EarL", CubeListBuilder.m_171558_().m_171514_(24, 26).m_171488_(0.5f, -3.0f, -1.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)-6.0f));
        root.m_171599_("WhiskerR", CubeListBuilder.m_171558_().m_171514_(20, 20).m_171488_(-4.5f, -1.0f, -7.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)-6.0f));
        root.m_171599_("WhiskerL", CubeListBuilder.m_171558_().m_171514_(24, 20).m_171488_(1.5f, -1.0f, -6.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)-6.0f));
        root.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171488_(-0.5f, 0.0f, -1.0f, 1.0f, 14.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)20.0f, (float)6.0f, (float)1.570796f, (float)0.0f, (float)0.0f));
        root.m_171599_("FrontL", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-2.0f, 0.0f, -3.0f, 2.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)23.0f, (float)-4.0f));
        root.m_171599_("FrontR", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(0.0f, 0.0f, -3.0f, 2.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)23.0f, (float)-4.0f));
        root.m_171599_("RearL", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-2.0f, 0.0f, -4.0f, 2.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)23.0f, (float)5.0f));
        root.m_171599_("RearR", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(0.0f, 0.0f, -4.0f, 2.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)23.0f, (float)5.0f));
        root.m_171599_("BodyF", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171488_(-3.0f, -3.0f, -7.0f, 6.0f, 6.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.f_104203_ = -(headPitch / 57.29578f);
        this.Head.f_104204_ = netHeadYaw / 57.29578f;
        this.EarR.f_104203_ = this.Head.f_104203_;
        this.EarR.f_104204_ = this.Head.f_104204_;
        this.EarL.f_104203_ = this.Head.f_104203_;
        this.EarL.f_104204_ = this.Head.f_104204_;
        this.WhiskerR.f_104203_ = this.Head.f_104203_;
        this.WhiskerR.f_104204_ = this.Head.f_104204_;
        this.WhiskerL.f_104203_ = this.Head.f_104203_;
        this.WhiskerL.f_104204_ = this.Head.f_104204_;
        float frontLRot = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.6f * limbSwingAmount;
        float rearLRot = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        float rearRRot = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.6f * limbSwingAmount;
        float frontRRot = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        this.FrontL.f_104203_ = frontLRot;
        this.RearL.f_104203_ = rearLRot;
        this.RearR.f_104203_ = rearRRot;
        this.FrontR.f_104203_ = frontRRot;
        this.Tail.f_104204_ = this.FrontL.f_104203_ * 0.625f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Head.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.EarR.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.EarL.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.WhiskerR.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.WhiskerL.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Tail.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.FrontL.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.FrontR.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RearL.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RearR.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.BodyF.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

