/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import drzhark.mocreatures.entity.hostile.MoCEntityRat;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoCModelRat<T extends MoCEntityRat>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("mocreatures", "rat"), "main");
    private final ModelPart head;
    private final ModelPart earR;
    private final ModelPart earL;
    private final ModelPart whiskerR;
    private final ModelPart whiskerL;
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart frontL;
    private final ModelPart frontR;
    private final ModelPart rearL;
    private final ModelPart rearR;
    private final ModelPart bodyF;
    private final float radianF = 57.29578f;

    public MoCModelRat(ModelPart root) {
        this.head = root.m_171324_("head");
        this.earR = root.m_171324_("ear_r");
        this.earL = root.m_171324_("ear_l");
        this.whiskerR = root.m_171324_("whisker_r");
        this.whiskerL = root.m_171324_("whisker_l");
        this.body = root.m_171324_("body");
        this.tail = root.m_171324_("tail");
        this.frontL = root.m_171324_("front_l");
        this.frontR = root.m_171324_("front_r");
        this.rearL = root.m_171324_("rear_l");
        this.rearR = root.m_171324_("rear_r");
        this.bodyF = root.m_171324_("body_f");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.5f, -1.0f, -6.0f, 3.0f, 4.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)-6.0f));
        root.m_171599_("ear_r", CubeListBuilder.m_171558_().m_171514_(16, 26).m_171481_(-3.5f, -3.0f, -2.0f, 3.0f, 3.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)-6.0f));
        root.m_171599_("ear_l", CubeListBuilder.m_171558_().m_171514_(24, 26).m_171481_(0.5f, -3.0f, -2.0f, 3.0f, 3.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)-6.0f));
        root.m_171599_("whisker_r", CubeListBuilder.m_171558_().m_171514_(24, 16).m_171481_(-4.5f, -1.0f, -6.0f, 3.0f, 3.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)-6.0f));
        root.m_171599_("whisker_l", CubeListBuilder.m_171558_().m_171514_(24, 20).m_171481_(1.5f, -1.0f, -6.0f, 3.0f, 3.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)-6.0f));
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-4.0f, -3.0f, -3.0f, 8.0f, 8.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)20.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        root.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 18.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)20.0f, (float)7.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        root.m_171599_("front_l", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171481_(-2.0f, 0.0f, -3.0f, 2.0f, 1.0f, 4.0f), PartPose.m_171419_((float)3.0f, (float)23.0f, (float)-5.0f));
        root.m_171599_("front_r", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171481_(0.0f, 0.0f, -3.0f, 2.0f, 1.0f, 4.0f), PartPose.m_171419_((float)-3.0f, (float)23.0f, (float)-5.0f));
        root.m_171599_("rear_l", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171481_(-2.0f, 0.0f, -4.0f, 2.0f, 1.0f, 5.0f), PartPose.m_171419_((float)4.0f, (float)23.0f, (float)4.0f));
        root.m_171599_("rear_r", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171481_(0.0f, 0.0f, -4.0f, 2.0f, 1.0f, 5.0f), PartPose.m_171419_((float)-4.0f, (float)23.0f, (float)4.0f));
        root.m_171599_("body_f", CubeListBuilder.m_171558_().m_171514_(32, 16).m_171481_(-3.0f, -3.0f, -7.0f, 6.0f, 6.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.earR.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.earL.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.whiskerR.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.whiskerL.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tail.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.frontL.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.frontR.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rearL.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rearR.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.bodyF.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = -headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.earR.f_104203_ = this.head.f_104203_;
        this.earR.f_104204_ = this.head.f_104204_;
        this.earL.f_104203_ = this.head.f_104203_;
        this.earL.f_104204_ = this.head.f_104204_;
        this.whiskerR.f_104203_ = this.head.f_104203_;
        this.whiskerR.f_104204_ = this.head.f_104204_;
        this.whiskerL.f_104203_ = this.head.f_104203_;
        this.whiskerL.f_104204_ = this.head.f_104204_;
        float frontLegX = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.6f * limbSwingAmount;
        float rearLegX = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        float frontLegX2 = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        float rearLegX2 = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.6f * limbSwingAmount;
        this.frontL.f_104203_ = frontLegX;
        this.rearL.f_104203_ = rearLegX;
        this.rearR.f_104203_ = frontLegX2;
        this.frontR.f_104203_ = rearLegX2;
        this.tail.f_104204_ = this.frontL.f_104203_ * 0.625f;
    }
}

