/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.model;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import drzhark.mocreatures.entity.MoCEntityInsect;
import drzhark.mocreatures.entity.ambient.MoCEntityRoach;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoCModelRoach<T extends MoCEntityRoach>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("mocreatures", "roach"), "main");
    private static final float RADIAN = 57.29578f;
    private final ModelPart head;
    private final ModelPart lAntenna;
    private final ModelPart lAntennaB;
    private final ModelPart rAntenna;
    private final ModelPart rAntennaB;
    private final ModelPart thorax;
    private final ModelPart frontLegs;
    private final ModelPart midLegs;
    private final ModelPart rearLegs;
    private final ModelPart abdomen;
    private final ModelPart tailL;
    private final ModelPart tailR;
    private final ModelPart lShellClosed;
    private final ModelPart rShellClosed;
    private final ModelPart lShellOpen;
    private final ModelPart rShellOpen;
    private final ModelPart leftWing;
    private final ModelPart rightWing;
    private boolean flying;

    public MoCModelRoach(ModelPart root) {
        this.head = root.m_171324_("head");
        this.lAntenna = this.head.m_171324_("l_antenna");
        this.lAntennaB = this.lAntenna.m_171324_("l_antenna_b");
        this.rAntenna = this.head.m_171324_("r_antenna");
        this.rAntennaB = this.rAntenna.m_171324_("r_antenna_b");
        this.thorax = root.m_171324_("thorax");
        this.frontLegs = root.m_171324_("front_legs");
        this.midLegs = root.m_171324_("mid_legs");
        this.rearLegs = root.m_171324_("rear_legs");
        this.abdomen = root.m_171324_("abdomen");
        this.tailL = root.m_171324_("tail_l");
        this.tailR = root.m_171324_("tail_r");
        this.lShellClosed = root.m_171324_("l_shell_closed");
        this.rShellClosed = root.m_171324_("r_shell_closed");
        this.lShellOpen = root.m_171324_("l_shell_open");
        this.rShellOpen = root.m_171324_("r_shell_open");
        this.leftWing = root.m_171324_("left_wing");
        this.rightWing = root.m_171324_("right_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-0.5f, 0.0f, -1.0f, 1.0f, 1.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)-2.0f));
        head.m_171599_("l_antenna", CubeListBuilder.m_171558_().m_171514_(3, 21).m_171481_(0.0f, 0.0f, 0.0f, 4.0f, 0.0f, 1.0f), PartPose.m_171423_((float)0.5f, (float)0.0f, (float)0.0f, (float)-3.7420273f, (float)0.4363323f, (float)0.0f));
        PartDefinition lAntenna = head.m_171597_("l_antenna");
        lAntenna.m_171599_("l_antenna_b", CubeListBuilder.m_171558_().m_171514_(4, 21).m_171481_(0.0f, 0.0f, 1.0f, 3.0f, 0.0f, 1.0f), PartPose.m_171423_((float)2.5f, (float)0.0f, (float)-0.5f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        head.m_171599_("r_antenna", CubeListBuilder.m_171558_().m_171514_(3, 19).m_171481_(-4.5f, 0.0f, 0.0f, 4.0f, 0.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-3.7420273f, (float)-0.4363323f, (float)0.0f));
        PartDefinition rAntenna = head.m_171597_("r_antenna");
        rAntenna.m_171599_("r_antenna_b", CubeListBuilder.m_171558_().m_171514_(4, 19).m_171481_(-4.0f, 0.0f, 1.0f, 3.0f, 0.0f, 1.0f), PartPose.m_171423_((float)-2.5f, (float)0.0f, (float)0.5f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        root.m_171599_("thorax", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)22.0f, (float)-1.0f));
        root.m_171599_("front_legs", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171481_(-2.0f, 0.0f, 0.0f, 4.0f, 2.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)23.0f, (float)-1.8f, (float)-1.115358f, (float)0.0f, (float)0.0f));
        root.m_171599_("mid_legs", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171481_(-2.5f, 0.0f, 0.0f, 5.0f, 2.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)23.0f, (float)-1.2f, (float)1.264073f, (float)0.0f, (float)0.0f));
        root.m_171599_("rear_legs", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171481_(-2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)23.0f, (float)-0.4f, (float)1.368173f, (float)0.0f, (float)0.0f));
        root.m_171599_("abdomen", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)22.0f, (float)0.0f, (float)1.427659f, (float)0.0f, (float)0.0f));
        root.m_171599_("tail_l", CubeListBuilder.m_171558_().m_171514_(2, 29).m_171481_(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)23.0f, (float)3.6f, (float)1.554066f, (float)0.6457718f, (float)0.0f));
        root.m_171599_("tail_r", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171481_(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)23.0f, (float)3.6f, (float)1.554066f, (float)-0.6457718f, (float)0.0f));
        root.m_171599_("l_shell_closed", CubeListBuilder.m_171558_().m_171514_(4, 23).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)21.5f, (float)-1.5f, (float)-0.1487144f, (float)-0.0872665f, (float)0.1919862f));
        root.m_171599_("r_shell_closed", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171481_(-2.0f, 0.0f, 0.0f, 2.0f, 0.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)21.5f, (float)-1.5f, (float)-0.1487144f, (float)0.0872665f, (float)-0.1919862f));
        root.m_171599_("l_shell_open", CubeListBuilder.m_171558_().m_171514_(4, 23).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)21.5f, (float)-1.5f, (float)1.117011f, (float)-0.0872665f, (float)1.047198f));
        root.m_171599_("r_shell_open", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171481_(-2.0f, 0.0f, 0.0f, 2.0f, 0.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)21.5f, (float)-1.5f, (float)1.117011f, (float)0.0872665f, (float)-1.047198f));
        root.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(11, 21).m_171481_(0.0f, 1.0f, -1.0f, 6.0f, 0.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)21.5f, (float)-1.5f, (float)0.0f, (float)-1.047198f, (float)-0.4363323f));
        root.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(11, 19).m_171481_(-6.0f, 1.0f, -1.0f, 6.0f, 0.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)21.5f, (float)-1.5f, (float)0.0f, (float)1.047198f, (float)0.4363323f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.thorax.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.frontLegs.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.midLegs.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rearLegs.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.abdomen.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tailL.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tailR.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        if (!this.flying) {
            this.lShellClosed.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.rShellClosed.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        } else {
            this.lShellOpen.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.rShellOpen.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.m_85836_();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.clearColor((float)0.8f, (float)0.8f, (float)0.8f, (float)0.6f);
            this.leftWing.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.rightWing.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            RenderSystem.disableBlend();
            poseStack.m_85849_();
            RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float legMovB;
        float legMov;
        this.flying = ((MoCEntityInsect)entity).getIsFlying() || entity.m_20184_().m_7098_() < -0.1;
        this.head.f_104203_ = -2.171231f + headPitch / 57.29578f;
        float antMov = 0.08726646f + limbSwingAmount * 1.5f;
        this.lAntenna.f_104205_ = -antMov;
        this.rAntenna.f_104205_ = antMov;
        float frontLegAdj = 0.0f;
        if (this.flying) {
            float wingRot = Mth.m_14089_((float)(ageInTicks * 2.0f)) * 0.7f;
            this.rightWing.f_104204_ = 1.047198f + wingRot;
            this.leftWing.f_104204_ = -1.047198f - wingRot;
            legMovB = legMov = limbSwingAmount * 1.5f;
            frontLegAdj = 1.4f;
        } else {
            legMov = Mth.m_14089_((float)(limbSwing * 1.5f + (float)Math.PI)) * 0.6f * limbSwingAmount;
            legMovB = Mth.m_14089_((float)(limbSwing * 1.5f)) * 0.8f * limbSwingAmount;
        }
        this.frontLegs.f_104203_ = -1.115358f + frontLegAdj + legMov;
        this.midLegs.f_104203_ = 1.264073f + legMovB;
        this.rearLegs.f_104203_ = 1.368173f - frontLegAdj + legMov;
    }
}

