/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import drzhark.mocreatures.entity.hostile.MoCEntitySilverSkeleton;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoCModelSilverSkeleton<T extends MoCEntitySilverSkeleton>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("mocreatures", "silver_skeleton"), "main");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart back;
    private final ModelPart rightArm;
    private final ModelPart rightHand;
    private final ModelPart rightSwordA;
    private final ModelPart rightSwordB;
    private final ModelPart rightSwordC;
    private final ModelPart leftArm;
    private final ModelPart leftHand;
    private final ModelPart leftSwordA;
    private final ModelPart leftSwordB;
    private final ModelPart leftSwordC;
    private final ModelPart rightThigh;
    private final ModelPart rightKnee;
    private final ModelPart rightLeg;
    private final ModelPart rightFoot;
    private final ModelPart leftThigh;
    private final ModelPart leftKnee;
    private final ModelPart leftLeg;
    private final ModelPart leftFoot;
    private float limbSwingAmountStored;
    private boolean sprintingStored;
    private int leftAttackStored;
    private int rightAttackStored;
    private boolean ridingStored;

    public MoCModelSilverSkeleton(ModelPart root) {
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.back = this.body.m_171324_("back");
        this.rightArm = root.m_171324_("rightArm");
        this.rightHand = root.m_171324_("rightHand");
        this.rightSwordA = root.m_171324_("rightSwordA");
        this.rightSwordB = root.m_171324_("rightSwordB");
        this.rightSwordC = root.m_171324_("rightSwordC");
        this.leftArm = root.m_171324_("leftArm");
        this.leftHand = root.m_171324_("leftHand");
        this.leftSwordA = root.m_171324_("leftSwordA");
        this.leftSwordB = root.m_171324_("leftSwordB");
        this.leftSwordC = root.m_171324_("leftSwordC");
        this.rightThigh = root.m_171324_("rightThigh");
        this.rightKnee = root.m_171324_("rightKnee");
        this.rightLeg = this.rightThigh.m_171324_("rightLeg");
        this.rightFoot = this.rightLeg.m_171324_("rightFoot");
        this.leftThigh = root.m_171324_("leftThigh");
        this.leftKnee = root.m_171324_("leftKnee");
        this.leftLeg = this.leftThigh.m_171324_("leftLeg");
        this.leftFoot = this.leftLeg.m_171324_("leftFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition back = body.m_171599_("back", CubeListBuilder.m_171558_().m_171514_(44, 54).m_171488_(-4.0f, -4.0f, 0.5f, 8.0f, 8.0f, 2.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)2.0f, (float)-0.1570796f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = root.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(48, 31).m_171488_(-3.0f, -2.5f, -2.5f, 4.0f, 11.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)-5.0f, (float)1.0f, (float)0.0f));
        PartDefinition rightHand = root.m_171599_("rightHand", CubeListBuilder.m_171558_().m_171514_(24, 16).m_171488_(-2.5f, -2.0f, -2.0f, 3.0f, 12.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)-5.0f, (float)1.0f, (float)0.0f));
        PartDefinition rightSwordA = root.m_171599_("rightSwordA", CubeListBuilder.m_171558_().m_171514_(52, 46).m_171488_(-1.5f, 8.5f, -3.0f, 1.0f, 1.0f, 5.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)-5.0f, (float)1.0f, (float)0.0f));
        PartDefinition rightSwordB = root.m_171599_("rightSwordB", CubeListBuilder.m_171558_().m_171514_(48, 50).m_171488_(-1.5f, 7.5f, -4.0f, 1.0f, 3.0f, 1.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)-5.0f, (float)1.0f, (float)0.0f));
        PartDefinition rightSwordC = root.m_171599_("rightSwordC", CubeListBuilder.m_171558_().m_171514_(28, 28).m_171488_(-1.0f, 7.5f, -14.0f, 0.0f, 3.0f, 10.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)-5.0f, (float)1.0f, (float)0.0f));
        PartDefinition leftArm = root.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(48, 16).m_171488_(-1.0f, -2.5f, -2.5f, 4.0f, 11.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)5.0f, (float)1.0f, (float)0.0f));
        PartDefinition leftHand = root.m_171599_("leftHand", CubeListBuilder.m_171558_().m_171514_(36, 16).m_171488_(-0.5f, -2.0f, -2.0f, 3.0f, 12.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)5.0f, (float)1.0f, (float)0.0f));
        PartDefinition leftSwordA = root.m_171599_("leftSwordA", CubeListBuilder.m_171558_().m_171514_(52, 46).m_171488_(0.5f, 8.5f, -3.0f, 1.0f, 1.0f, 5.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)5.0f, (float)1.0f, (float)0.0f));
        PartDefinition leftSwordB = root.m_171599_("leftSwordB", CubeListBuilder.m_171558_().m_171514_(48, 46).m_171488_(0.5f, 7.5f, -4.0f, 1.0f, 3.0f, 1.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)5.0f, (float)1.0f, (float)0.0f));
        PartDefinition leftSwordC = root.m_171599_("leftSwordC", CubeListBuilder.m_171558_().m_171514_(28, 31).m_171488_(1.0f, 7.5f, -14.0f, 0.0f, 3.0f, 10.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)5.0f, (float)1.0f, (float)0.0f));
        PartDefinition rightThigh = root.m_171599_("rightThigh", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)-2.0f, (float)10.5f, (float)0.0f));
        PartDefinition rightKnee = root.m_171599_("rightKnee", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171488_(-2.0f, 1.0f, -2.0f, 4.0f, 4.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)-2.0f, (float)10.5f, (float)0.0f));
        PartDefinition rightLeg = rightThigh.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition rightFoot = rightLeg.m_171599_("rightFoot", CubeListBuilder.m_171558_().m_171514_(0, 54).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition leftThigh = root.m_171599_("leftThigh", CubeListBuilder.m_171558_().m_171514_(12, 16).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)2.0f, (float)10.5f, (float)0.0f));
        PartDefinition leftKnee = root.m_171599_("leftKnee", CubeListBuilder.m_171558_().m_171514_(16, 46).m_171488_(-2.0f, 1.0f, -2.0f, 4.0f, 4.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)2.0f, (float)10.5f, (float)0.0f));
        PartDefinition leftLeg = leftThigh.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(12, 25).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition leftFoot = leftLeg.m_171599_("leftFoot", CubeListBuilder.m_171558_().m_171514_(16, 54).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setLivingAnimations(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.limbSwingAmountStored = limbSwingAmount;
        this.sprintingStored = entityIn.m_20142_();
        this.leftAttackStored = ((MoCEntitySilverSkeleton)entityIn).attackCounterLeft;
        this.rightAttackStored = ((MoCEntitySilverSkeleton)entityIn).attackCounterRight;
        this.ridingStored = entityIn.m_20202_() != null;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float hRotX;
        float radianF = 57.29578f;
        float hRotY = netHeadYaw / radianF;
        this.head.f_104203_ = hRotX = headPitch / radianF;
        this.head.f_104204_ = hRotY;
        float RLegXRot = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        float LLegXRot = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount;
        if (this.leftAttackStored == 0) {
            this.leftArm.f_104205_ = Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f - 0.05f;
            this.leftArm.f_104203_ = RLegXRot;
        } else {
            this.leftArm.f_104203_ = -(Mth.m_14089_((float)((float)this.leftAttackStored * 0.18f)) * 3.0f);
        }
        if (this.rightAttackStored == 0) {
            this.rightArm.f_104205_ = -(Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f) + 0.05f;
            this.rightArm.f_104203_ = LLegXRot;
        } else {
            this.rightArm.f_104203_ = -(Mth.m_14089_((float)((float)this.rightAttackStored * 0.18f)) * 3.0f);
        }
        this.leftSwordB.f_104203_ = this.leftSwordC.f_104203_ = this.leftArm.f_104203_;
        this.leftSwordA.f_104203_ = this.leftSwordC.f_104203_;
        this.leftHand.f_104203_ = this.leftSwordC.f_104203_;
        this.leftSwordB.f_104205_ = this.leftSwordC.f_104205_ = this.leftArm.f_104205_;
        this.leftSwordA.f_104205_ = this.leftSwordC.f_104205_;
        this.leftHand.f_104205_ = this.leftSwordC.f_104205_;
        this.rightSwordB.f_104203_ = this.rightSwordC.f_104203_ = this.rightArm.f_104203_;
        this.rightSwordA.f_104203_ = this.rightSwordC.f_104203_;
        this.rightHand.f_104203_ = this.rightSwordC.f_104203_;
        this.rightSwordB.f_104205_ = this.rightSwordC.f_104205_ = this.rightArm.f_104205_;
        this.rightSwordA.f_104205_ = this.rightSwordC.f_104205_;
        this.rightHand.f_104205_ = this.rightSwordC.f_104205_;
        if (this.ridingStored) {
            this.rightLeg.f_104203_ = 0.0f;
            this.rightThigh.f_104203_ = -60.0f / radianF;
            this.rightThigh.f_104204_ = 20.0f / radianF;
            this.rightKnee.f_104204_ = 20.0f / radianF;
            this.rightKnee.f_104203_ = -60.0f / radianF;
            this.leftLeg.f_104203_ = 0.0f;
            this.leftThigh.f_104204_ = -20.0f / radianF;
            this.leftKnee.f_104204_ = -20.0f / radianF;
            this.leftThigh.f_104203_ = -60.0f / radianF;
            this.leftKnee.f_104203_ = -60.0f / radianF;
        } else {
            this.rightThigh.f_104204_ = 0.0f;
            this.rightKnee.f_104204_ = 0.0f;
            this.leftThigh.f_104204_ = 0.0f;
            this.leftKnee.f_104204_ = 0.0f;
            this.rightThigh.f_104203_ = RLegXRot;
            this.leftThigh.f_104203_ = LLegXRot;
            this.rightKnee.f_104203_ = this.rightThigh.f_104203_;
            this.leftKnee.f_104203_ = this.leftThigh.f_104203_;
            float RLegXRot2 = Mth.m_14089_((float)((limbSwing + 0.1f) * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
            float LLegXRot2 = Mth.m_14089_((float)((limbSwing + 0.1f) * 0.6662f)) * 0.8f * limbSwingAmount;
            float RLegXRotB = RLegXRot;
            float LLegXRotB = LLegXRot;
            if (limbSwingAmount > 0.15f) {
                if (RLegXRot > RLegXRot2) {
                    RLegXRotB = RLegXRot + 25.0f / radianF;
                }
                if (LLegXRot > LLegXRot2) {
                    LLegXRotB = LLegXRot + 25.0f / radianF;
                }
            }
            this.rightLeg.f_104203_ = LLegXRotB;
            this.leftLeg.f_104203_ = RLegXRotB;
        }
        this.body.f_104203_ = this.sprintingStored && this.limbSwingAmountStored > 0.3f ? -this.limbSwingAmountStored * 20.0f / radianF : 0.0f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        if (this.ridingStored) {
            poseStack.m_85837_(0.0, 0.5, 0.0);
        }
        this.head.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.back.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightArm.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightHand.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightSwordA.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightSwordB.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightSwordC.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftArm.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftHand.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftSwordA.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftSwordB.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftSwordC.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightThigh.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightKnee.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftThigh.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftKnee.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }
}

