/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import drzhark.mocreatures.entity.MoCEntityAmbient;
import drzhark.mocreatures.entity.ambient.MoCEntitySnail;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoCModelSnail<T extends MoCEntitySnail>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("mocreatures", "snail"), "main");
    private final ModelPart head;
    private final ModelPart antenna;
    private final ModelPart body;
    private final ModelPart shellUp;
    private final ModelPart shellDown;
    private final ModelPart tail;
    private boolean isHiding;
    private int type;

    public MoCModelSnail(ModelPart root) {
        this.head = root.m_171324_("head");
        this.antenna = root.m_171324_("antenna");
        this.body = root.m_171324_("body");
        this.shellUp = root.m_171324_("shellUp");
        this.shellDown = root.m_171324_("shellDown");
        this.tail = root.m_171324_("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)21.8f, (float)-1.0f, (float)-0.4537856f, (float)0.0f, (float)0.0f));
        PartDefinition antenna = root.m_171599_("antenna", CubeListBuilder.m_171558_().m_171514_(8, 0).m_171481_(-1.5f, 0.0f, -1.0f, 3.0f, 2.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)19.4f, (float)-1.0f, (float)0.0523599f, (float)0.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)22.0f, (float)0.0f));
        PartDefinition shellUp = root.m_171599_("shellUp", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171481_(-1.0f, -3.0f, 0.0f, 2.0f, 3.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)22.3f, (float)-0.2f, (float)0.2268928f, (float)0.0f, (float)0.0f));
        PartDefinition shellDown = root.m_171599_("shellDown", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171481_(-1.0f, 0.0f, 0.0f, 2.0f, 3.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)0.0f));
        PartDefinition tail = root.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(1, 2).m_171481_(-1.0f, 0.0f, 0.0f, 2.0f, 1.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.isHiding = ((MoCEntitySnail)entity).getIsHiding();
        this.type = ((MoCEntityAmbient)entity).getTypeMoC();
        float tailMov = Mth.m_14089_((float)(ageInTicks * 0.3f)) * 0.8f;
        if (limbSwingAmount < 0.1f) {
            tailMov = 0.0f;
        }
        this.tail.m_104227_(0.0f, 23.0f, 3.0f + tailMov);
        this.shellUp.f_104203_ = 0.2268928f + tailMov / 10.0f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.isHiding && this.type < 5) {
            this.shellDown.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        } else {
            this.head.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.antenna.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.body.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.shellUp.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.tail.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }
}

