/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import drzhark.mocreatures.entity.MoCEntityAnimal;
import drzhark.mocreatures.entity.passive.MoCEntityTurkey;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoCModelTurkey<T extends MoCEntityTurkey>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("mocreatures", "turkey"), "main");
    private final ModelPart beak;
    private final ModelPart head;
    private final ModelPart neck;
    private final ModelPart chest;
    private final ModelPart rWing;
    private final ModelPart lWing;
    private final ModelPart uBody;
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart rLeg;
    private final ModelPart rFoot;
    private final ModelPart lLeg;
    private final ModelPart lFoot;
    private boolean male;

    public MoCModelTurkey(ModelPart root) {
        this.beak = root.m_171324_("beak");
        this.head = root.m_171324_("head");
        this.neck = root.m_171324_("neck");
        this.chest = root.m_171324_("chest");
        this.rWing = root.m_171324_("rWing");
        this.lWing = root.m_171324_("lWing");
        this.uBody = root.m_171324_("uBody");
        this.body = root.m_171324_("body");
        this.tail = root.m_171324_("tail");
        this.rLeg = root.m_171324_("rLeg");
        this.rFoot = root.m_171324_("rFoot");
        this.lLeg = root.m_171324_("lLeg");
        this.lFoot = root.m_171324_("lFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(17, 17).m_171481_(-0.5f, -1.866667f, -3.366667f, 1.0f, 1.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)9.7f, (float)-5.1f, (float)0.7807508f, (float)0.0f, (float)0.0f));
        root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171481_(-1.0f, -2.0f, -2.0f, 2.0f, 2.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)9.7f, (float)-5.1f, (float)0.4833219f, (float)0.0f, (float)0.0f));
        root.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-1.0f, -6.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)14.7f, (float)-6.5f, (float)-0.2246208f, (float)0.0f, (float)0.0f));
        root.m_171599_("chest", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171481_(-3.0f, 0.0f, -4.0f, 6.0f, 6.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)12.5f, (float)-4.0f, (float)0.5934119f, (float)0.0f, (float)0.0f));
        root.m_171599_("rWing", CubeListBuilder.m_171558_().m_171514_(32, 30).m_171481_(-1.0f, -2.0f, 0.0f, 1.0f, 6.0f, 7.0f), PartPose.m_171423_((float)-4.0f, (float)14.0f, (float)-3.0f, (float)-0.3346075f, (float)0.0f, (float)0.0f));
        root.m_171599_("lWing", CubeListBuilder.m_171558_().m_171514_(48, 30).m_171481_(0.0f, -2.0f, 0.0f, 1.0f, 6.0f, 7.0f), PartPose.m_171423_((float)4.0f, (float)14.0f, (float)-3.0f, (float)-0.3346075f, (float)0.0f, (float)0.0f));
        root.m_171599_("uBody", CubeListBuilder.m_171558_().m_171514_(34, 0).m_171481_(-2.5f, -4.0f, 0.0f, 5.0f, 7.0f, 9.0f), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)-3.0f));
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 9.0f), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)-4.0f));
        root.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(32, 17).m_171481_(-8.0f, -9.0f, 0.0f, 16.0f, 12.0f, 0.0f), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)6.0f, (float)-0.2974289f, (float)0.0f, (float)0.0f));
        root.m_171599_("rLeg", CubeListBuilder.m_171558_().m_171514_(27, 17).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f), PartPose.m_171419_((float)-2.0f, (float)19.0f, (float)0.5f));
        root.m_171599_("rFoot", CubeListBuilder.m_171558_().m_171514_(20, 23).m_171481_(-1.5f, 5.0f, -2.5f, 3.0f, 0.0f, 3.0f), PartPose.m_171419_((float)-2.0f, (float)19.0f, (float)0.5f));
        root.m_171599_("lLeg", CubeListBuilder.m_171558_().m_171514_(23, 17).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 5.0f, 1.0f), PartPose.m_171419_((float)2.0f, (float)19.0f, (float)0.5f));
        root.m_171599_("lFoot", CubeListBuilder.m_171558_().m_171514_(20, 26).m_171481_(-1.5f, 5.0f, -2.5f, 3.0f, 0.0f, 3.0f), PartPose.m_171419_((float)2.0f, (float)19.0f, (float)0.5f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.male = ((MoCEntityAnimal)entity).getTypeMoC() == 1;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setRotationAngles(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    public void setRotationAngles(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float LLegXRot = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float RLegXRot = Mth.m_14089_((float)(limbSwing * 0.6662f + 3.141593f)) * 1.4f * limbSwingAmount;
        float wingF = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount / 4.0f;
        this.head.f_104203_ = 0.4833219f + headPitch / 57.29578f;
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.beak.f_104203_ = 0.2974f + this.head.f_104203_;
        this.beak.f_104204_ = this.head.f_104204_;
        this.lFoot.f_104203_ = this.lLeg.f_104203_ = LLegXRot;
        this.rFoot.f_104203_ = this.rLeg.f_104203_ = RLegXRot;
        this.lWing.f_104204_ = wingF;
        this.rWing.f_104204_ = -wingF;
        if (this.male) {
            this.tail.f_104203_ = -0.2974289f + wingF;
            this.tail.f_104201_ = 14.0f;
            this.tail.f_104202_ = 6.0f;
            this.chest.f_104201_ = 12.5f;
            this.body.f_104201_ = 16.0f;
            this.lWing.f_104200_ = 4.0f;
            this.rWing.f_104200_ = -4.0f;
        } else {
            this.tail.f_104203_ = wingF - 1.9198622f;
            this.tail.f_104201_ = 17.0f;
            this.tail.f_104202_ = 7.0f;
            this.chest.f_104201_ = 16.0f;
            this.body.f_104201_ = 20.0f;
            this.lWing.f_104200_ = 3.2f;
            this.rWing.f_104200_ = -3.2f;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 5.0f, 2.0f);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_252880_(0.0f, 24.0f, 0.0f);
            this.beak.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.head.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.neck.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.rWing.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.lWing.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.tail.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.rLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.rFoot.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.lLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.lFoot.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.m_85836_();
            poseStack.m_85841_(0.8f, 0.8f, 1.0f);
            this.body.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.chest.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.m_85849_();
            poseStack.m_85849_();
        } else {
            this.beak.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.head.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.neck.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.rWing.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.lWing.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.tail.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.rLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.rFoot.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.lLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            this.lFoot.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            if (this.male) {
                this.uBody.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                this.body.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                this.chest.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            } else {
                poseStack.m_85836_();
                poseStack.m_85841_(0.8f, 0.8f, 1.0f);
                this.body.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                this.chest.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                poseStack.m_85849_();
            }
        }
    }
}

