/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import drzhark.mocreatures.entity.passive.MoCEntityTurtle;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class MoCModelTurtle<T extends MoCEntityTurtle>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("mocreatures", "turtle"), "main");
    private final ModelPart Shell;
    private final ModelPart ShellUp;
    private final ModelPart ShellTop;
    private final ModelPart Belly;
    private final ModelPart Leg1;
    private final ModelPart Leg2;
    private final ModelPart Leg3;
    private final ModelPart Leg4;
    private final ModelPart Head;
    private final ModelPart Tail;
    public boolean isHiding;
    public boolean upsidedown;
    public float swingProgress;
    public boolean turtleHat;
    public boolean TMNT;
    public boolean isSwimming;

    public MoCModelTurtle(ModelPart root) {
        this.Shell = root.m_171324_("Shell");
        this.ShellUp = root.m_171324_("ShellUp");
        this.ShellTop = root.m_171324_("ShellTop");
        this.Belly = root.m_171324_("Belly");
        this.Leg1 = root.m_171324_("Leg1");
        this.Leg2 = root.m_171324_("Leg2");
        this.Leg3 = root.m_171324_("Leg3");
        this.Leg4 = root.m_171324_("Leg4");
        this.Head = root.m_171324_("Head");
        this.Tail = root.m_171324_("Tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.m_171576_();
        part.m_171599_("Shell", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171481_(0.0f, 0.0f, 0.0f, 9.0f, 1.0f, 9.0f), PartPose.m_171419_((float)-4.5f, (float)19.0f, (float)-4.5f));
        part.m_171599_("ShellUp", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171481_(0.0f, 0.0f, 0.0f, 8.0f, 2.0f, 8.0f), PartPose.m_171419_((float)-4.0f, (float)17.0f, (float)-4.0f));
        part.m_171599_("ShellTop", CubeListBuilder.m_171558_().m_171514_(40, 10).m_171481_(0.0f, 0.0f, 0.0f, 6.0f, 1.0f, 6.0f), PartPose.m_171419_((float)-3.0f, (float)16.0f, (float)-3.0f));
        part.m_171599_("Belly", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(0.0f, 0.0f, 0.0f, 8.0f, 1.0f, 8.0f), PartPose.m_171419_((float)-4.0f, (float)20.0f, (float)-4.0f));
        part.m_171599_("Leg1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.m_171419_((float)3.5f, (float)20.0f, (float)-3.5f));
        part.m_171599_("Leg2", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.m_171419_((float)-3.5f, (float)20.0f, (float)-3.5f));
        part.m_171599_("Leg3", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.m_171419_((float)3.5f, (float)20.0f, (float)3.5f));
        part.m_171599_("Leg4", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.m_171419_((float)-3.5f, (float)20.0f, (float)3.5f));
        part.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(10, 0).m_171481_(-1.5f, -1.0f, -4.0f, 3.0f, 2.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)-4.5f));
        part.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(0, 5).m_171481_(-1.0f, -1.0f, 0.0f, 2.0f, 1.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.TMNT = ((MoCEntityTurtle)entity).isTMNT();
        this.turtleHat = entity.m_20202_() != null;
        this.isSwimming = entity.m_20069_();
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.upsidedown) {
            float f25;
            float f26 = f25 = this.swingProgress;
            if (f25 >= 0.8f) {
                f26 = 0.6f - (f25 - 0.8f);
            }
            if (f26 > 1.6f) {
                f26 = 1.6f;
            }
            if (f26 < -1.6f) {
                f26 = -1.6f;
            }
            this.Leg1.f_104203_ = -f26;
            this.Leg2.f_104203_ = f26;
            this.Leg3.f_104203_ = f26;
            this.Leg4.f_104203_ = -f26;
            this.Tail.f_104204_ = -f26;
        } else if (this.turtleHat) {
            this.Leg1.f_104203_ = 0.0f;
            this.Leg2.f_104203_ = 0.0f;
            this.Leg3.f_104203_ = 0.0f;
            this.Leg4.f_104203_ = 0.0f;
            this.Tail.f_104204_ = 0.0f;
        } else if (this.isSwimming) {
            float swimmLegs = Mth.m_14089_((float)(limbSwing * 0.5f)) * 6.0f * limbSwingAmount;
            this.Leg1.f_104203_ = -1.2f;
            this.Leg1.f_104204_ = -1.2f + swimmLegs;
            this.Leg2.f_104203_ = -1.2f;
            this.Leg2.f_104204_ = 1.2f - swimmLegs;
            this.Leg3.f_104203_ = 1.2f;
            this.Leg4.f_104203_ = 1.2f;
            this.Tail.f_104204_ = 0.0f;
        } else {
            this.Leg1.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f)) * 2.0f * limbSwingAmount;
            this.Leg2.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f + (float)Math.PI)) * 2.0f * limbSwingAmount;
            this.Leg3.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f + (float)Math.PI)) * 2.0f * limbSwingAmount;
            this.Leg4.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f)) * 2.0f * limbSwingAmount;
            this.Tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.7f * limbSwingAmount;
            this.Leg1.f_104204_ = 0.0f;
            this.Leg2.f_104204_ = 0.0f;
        }
        if (this.isHiding && !this.isSwimming) {
            this.Head.f_104203_ = 0.0f;
            this.Head.f_104204_ = 0.0f;
            this.Leg1.m_104227_(2.9f, 18.5f, -2.9f);
            this.Leg2.m_104227_(-2.9f, 18.5f, -2.9f);
            this.Leg3.m_104227_(2.9f, 18.5f, 2.9f);
            this.Leg4.m_104227_(-2.9f, 18.5f, 2.9f);
            this.Head.m_104227_(0.0f, 19.5f, -1.0f);
            this.Tail.m_104227_(0.0f, 21.0f, 2.0f);
        } else {
            this.Head.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.Leg1.m_104227_(3.5f, 20.0f, -3.5f);
            this.Leg2.m_104227_(-3.5f, 20.0f, -3.5f);
            this.Leg3.m_104227_(3.5f, 20.0f, 3.5f);
            this.Leg4.m_104227_(-3.5f, 20.0f, 3.5f);
            this.Head.m_104227_(0.0f, 20.0f, -4.5f);
            this.Tail.m_104227_(0.0f, 21.0f, 4.0f);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Shell.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.ShellUp.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        if (!this.TMNT) {
            this.ShellTop.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }
        this.Belly.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Leg1.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Leg2.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Leg3.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Leg4.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Head.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Tail.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

