/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import drzhark.mocreatures.client.model.MoCModelCrocodile;
import drzhark.mocreatures.entity.hunter.MoCEntityCrocodile;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoCRenderCrocodile
extends MobRenderer<MoCEntityCrocodile, MoCModelCrocodile<MoCEntityCrocodile>> {
    public MoCModelCrocodile croc;

    public MoCRenderCrocodile(EntityRendererProvider.Context renderManagerIn, MoCModelCrocodile modelbase, float f) {
        super(renderManagerIn, (EntityModel)modelbase, f);
        this.croc = modelbase;
    }

    public ResourceLocation getTextureLocation(MoCEntityCrocodile entitycrocodile) {
        return entitycrocodile.getTexture();
    }

    public void render(MoCEntityCrocodile entitycrocodile, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLightIn) {
        super.m_7392_((Mob)entitycrocodile, entityYaw, partialTicks, poseStack, buffer, packedLightIn);
    }

    protected void scale(MoCEntityCrocodile entitycrocodile, PoseStack poseStack, float f) {
        this.croc.biteProgress = entitycrocodile.biteProgress;
        this.croc.swimming = entitycrocodile.m_6069_();
        this.croc.resting = entitycrocodile.getIsSitting();
        if (entitycrocodile.isSpinning()) {
            this.spinCroc(entitycrocodile, (Mob)entitycrocodile.m_20202_(), poseStack);
        }
        this.stretch(entitycrocodile, poseStack);
        if (entitycrocodile.getIsSitting() && !entitycrocodile.m_204029_(FluidTags.f_13131_)) {
            this.adjustHeight(entitycrocodile, 0.2f, poseStack);
        }
    }

    protected void rotateAnimal(MoCEntityCrocodile entitycrocodile, PoseStack poseStack) {
    }

    protected void adjustHeight(MoCEntityCrocodile entitycrocodile, float FHeight, PoseStack poseStack) {
        poseStack.m_252880_(0.0f, FHeight, 0.0f);
    }

    protected void spinCroc(MoCEntityCrocodile entitycrocodile, Mob prey, PoseStack poseStack) {
        int intSpin = entitycrocodile.spinInt;
        int direction = 1;
        if (intSpin > 40) {
            intSpin -= 40;
            direction = -1;
        }
        int intEndSpin = intSpin;
        if (intSpin >= 20) {
            intEndSpin = 20 - (intSpin - 20);
        }
        if (intEndSpin == 0) {
            intEndSpin = 1;
        }
        float f3 = ((float)intEndSpin - 1.0f) / 20.0f * 1.6f;
        if ((f3 = Mth.m_14116_((float)f3)) > 1.0f) {
            f3 = 1.0f;
        }
        poseStack.m_252781_(Axis.f_252403_.m_252977_((f3 *= (float)direction) * 90.0f));
        if (prey != null) {
            prey.f_20919_ = intEndSpin;
        }
    }

    protected void stretch(MoCEntityCrocodile entitycrocodile, PoseStack poseStack) {
        float f = (float)entitycrocodile.getMoCAge() * 0.01f;
        poseStack.m_85841_(f, f, f);
    }
}

