/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import org.joml.Matrix4f;

public class MoCRenderMoC<T extends Mob, M extends EntityModel<T>>
extends MobRenderer<T, M> {
    private float prevPitch;
    private float prevRoll;
    private float prevYaw;

    public MoCRenderMoC(EntityRendererProvider.Context context, M model, float shadowSize) {
        super(context, model, shadowSize);
    }

    public void m_7392_(T entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        this.renderMoC(entityIn, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public void renderMoC(T entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        boolean showHealth;
        super.m_7392_(entityIn, entityYaw, partialTicks, poseStack, buffer, packedLight);
        IMoCEntity entityMoC = (IMoCEntity)entityIn;
        boolean showName = MoCreatures.proxy.getDisplayPetName() && !entityMoC.getPetName().isEmpty() && entityIn.m_20197_().isEmpty();
        boolean bl = showHealth = MoCreatures.proxy.getDisplayPetHealth() && entityIn.m_20197_().isEmpty();
        if (entityMoC.getIsTamed() && entityIn.m_20197_().isEmpty()) {
            float f2 = 1.6f;
            float f3 = 0.01666667f * f2;
            float f5 = (float)this.f_114476_.m_114471_(entityIn);
            if (f5 < 256.0f) {
                Object s = "";
                s = (String)s + entityMoC.getPetName();
                float f7 = 0.1f;
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, f7, 0.0f);
                poseStack.m_252781_(this.f_114476_.m_253208_());
                poseStack.m_85841_(-f3, -f3, f3);
                int yOff = entityMoC.nameYOffset();
                if (showHealth) {
                    if (!showName) {
                        yOff += 8;
                    }
                    Matrix4f matrix = poseStack.m_85850_().m_252922_();
                    float health = entityIn.m_21223_();
                    float maxHealth = entityIn.m_21233_();
                    float healthRatio = health / maxHealth;
                    float barWidth = 40.0f * healthRatio;
                    ResourceLocation WHITE_TEXTURE = new ResourceLocation("textures/misc/white.png");
                    VertexConsumer vertexconsumer = buffer.m_6299_(RenderType.m_110497_((ResourceLocation)WHITE_TEXTURE));
                    vertexconsumer.m_252986_(matrix, -20.0f + barWidth, (float)(-10 + yOff), 0.0f).m_85950_(0.7f, 0.0f, 0.0f, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(0).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    vertexconsumer.m_252986_(matrix, -20.0f + barWidth, (float)(-6 + yOff), 0.0f).m_85950_(0.7f, 0.0f, 0.0f, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(0).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    vertexconsumer.m_252986_(matrix, 20.0f, (float)(-6 + yOff), 0.0f).m_85950_(0.7f, 0.0f, 0.0f, 1.0f).m_7421_(1.0f, 1.0f).m_86008_(0).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    vertexconsumer.m_252986_(matrix, 20.0f, (float)(-10 + yOff), 0.0f).m_85950_(0.7f, 0.0f, 0.0f, 1.0f).m_7421_(1.0f, 0.0f).m_86008_(0).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    vertexconsumer = buffer.m_6299_(RenderType.m_110497_((ResourceLocation)WHITE_TEXTURE));
                    vertexconsumer.m_252986_(matrix, -20.0f, (float)(-10 + yOff), 0.01f).m_85950_(0.0f, 0.7f, 0.0f, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(0).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    vertexconsumer.m_252986_(matrix, -20.0f, (float)(-6 + yOff), 0.01f).m_85950_(0.0f, 0.7f, 0.0f, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(0).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    vertexconsumer.m_252986_(matrix, barWidth - 20.0f, (float)(-6 + yOff), 0.01f).m_85950_(0.0f, 0.7f, 0.0f, 1.0f).m_7421_(1.0f, 1.0f).m_86008_(0).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    vertexconsumer.m_252986_(matrix, barWidth - 20.0f, (float)(-10 + yOff), 0.01f).m_85950_(0.0f, 0.7f, 0.0f, 1.0f).m_7421_(1.0f, 0.0f).m_86008_(0).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                }
                if (showName) {
                    Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                    Font font = this.m_114481_();
                    float textWidth = font.m_92852_((FormattedText)Component.m_237113_((String)s));
                    float textX = -textWidth / 2.0f;
                    VertexConsumer vertexconsumer = buffer.m_6299_(RenderType.m_285907_());
                    int left = (int)(textX - 1.0f);
                    int top = yOff - 1;
                    int right = (int)(textX + textWidth + 1.0f);
                    int bottom = yOff + 8;
                    vertexconsumer.m_252986_(matrix4f, (float)left, (float)top, 0.0f).m_6122_(0, 0, 0, 64).m_5752_();
                    vertexconsumer.m_252986_(matrix4f, (float)left, (float)bottom, 0.0f).m_6122_(0, 0, 0, 64).m_5752_();
                    vertexconsumer.m_252986_(matrix4f, (float)right, (float)bottom, 0.0f).m_6122_(0, 0, 0, 64).m_5752_();
                    vertexconsumer.m_252986_(matrix4f, (float)right, (float)top, 0.0f).m_6122_(0, 0, 0, 64).m_5752_();
                    font.m_272077_((Component)Component.m_237113_((String)s), textX, (float)yOff, 0x20FFFFFF, false, matrix4f, buffer, Font.DisplayMode.SEE_THROUGH, 0, packedLight);
                    font.m_272077_((Component)Component.m_237113_((String)s), textX, (float)yOff, -1, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLight);
                }
                poseStack.m_85849_();
            }
        }
    }

    protected void scale(T entityliving, PoseStack matrixStackIn, float f) {
        IMoCEntity mocreature = (IMoCEntity)entityliving;
        super.m_7546_(entityliving, matrixStackIn, f);
        float interpolationFactor = 0.05f;
        float interpolatedPitch = this.prevPitch + (mocreature.pitchRotationOffset() - this.prevPitch) * interpolationFactor;
        float interpolatedRoll = this.prevRoll + (mocreature.rollRotationOffset() - this.prevRoll) * interpolationFactor;
        float interpolatedYaw = this.prevYaw + (mocreature.yawRotationOffset() - this.prevYaw) * interpolationFactor;
        if (interpolatedPitch != 0.0f) {
            matrixStackIn.m_252781_(Axis.f_252495_.m_252977_(interpolatedPitch));
        }
        if (interpolatedRoll != 0.0f) {
            matrixStackIn.m_252781_(Axis.f_252393_.m_252977_(interpolatedRoll));
        }
        if (interpolatedYaw != 0.0f) {
            matrixStackIn.m_252781_(Axis.f_252392_.m_252977_(interpolatedYaw));
        }
        this.prevPitch = interpolatedPitch;
        this.prevRoll = interpolatedRoll;
        this.prevYaw = interpolatedYaw;
        this.adjustPitch(mocreature, matrixStackIn);
        this.adjustRoll(mocreature, matrixStackIn);
        this.adjustYaw(mocreature, matrixStackIn);
        this.stretch(mocreature, matrixStackIn);
    }

    public boolean m_6512_(T entity) {
        return false;
    }

    protected void adjustPitch(IMoCEntity mocreature, PoseStack matrixStackIn) {
        float f = mocreature.pitchRotationOffset();
        if (f != 0.0f) {
            matrixStackIn.m_252781_(Axis.f_252495_.m_252977_(f));
        }
    }

    protected void adjustRoll(IMoCEntity mocreature, PoseStack matrixStackIn) {
        float f = mocreature.rollRotationOffset();
        if (f != 0.0f) {
            matrixStackIn.m_252781_(Axis.f_252393_.m_252977_(f));
        }
    }

    protected void adjustYaw(IMoCEntity mocreature, PoseStack matrixStackIn) {
        float f = mocreature.yawRotationOffset();
        if (f != 0.0f) {
            matrixStackIn.m_252781_(Axis.f_252392_.m_252977_(f));
        }
    }

    protected void stretch(IMoCEntity mocreature, PoseStack poseStack) {
        float f = mocreature.getSizeFactor();
        if (f != 0.0f) {
            poseStack.m_85841_(f, f, f);
        }
    }

    protected void adjustOffsets(float xOffset, float yOffset, float zOffset, PoseStack matrixStackIn) {
        matrixStackIn.m_252880_(xOffset, yOffset, zOffset);
    }

    public ResourceLocation getTextureLocation(Mob entity) {
        return ((IMoCEntity)entity).getTexture();
    }
}

