/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.client.model.MoCModelWerehuman;
import drzhark.mocreatures.client.model.MoCModelWerewolf;
import drzhark.mocreatures.entity.hostile.MoCEntityWerewolf;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoCRenderWerewolf<M extends EntityModel<MoCEntityWerewolf>>
extends MobRenderer<MoCEntityWerewolf, M> {
    private final MoCModelWerewolf tempWerewolf;

    public MoCRenderWerewolf(EntityRendererProvider.Context context, MoCModelWerehuman<MoCEntityWerewolf> modelwerehuman, M modelbase, float f) {
        super(context, modelbase, f);
        this.tempWerewolf = (MoCModelWerewolf)((Object)modelbase);
        this.m_115326_(new LayerMoCWereHuman(this));
    }

    public void render(MoCEntityWerewolf entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLightIn) {
        this.tempWerewolf.hunched = entity.getIsHunched();
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLightIn);
    }

    public ResourceLocation getTextureLocation(MoCEntityWerewolf entity) {
        return entity.getTexture();
    }

    private class LayerMoCWereHuman
    extends RenderLayer<MoCEntityWerewolf, M> {
        private final MoCRenderWerewolf<M> renderer;
        private MoCModelWerehuman<MoCEntityWerewolf> humanModel;

        public LayerMoCWereHuman(MoCRenderWerewolf<M> renderer) {
            super(renderer);
            this.renderer = renderer;
            try {
                Object context = null;
                ModelPart root = MoCModelWerehuman.createBodyLayer().m_171564_();
                this.humanModel = new MoCModelWerehuman(root);
            }
            catch (Exception e) {
                MoCreatures.LOGGER.error("Failed to initialize werehuman model: {}", (Object)e.getMessage());
                ModelPart root = MoCModelWerehuman.createBodyLayer().m_171564_();
                this.humanModel = new MoCModelWerehuman(root);
            }
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLightIn, MoCEntityWerewolf entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!entity.getIsHumanForm() || this.humanModel == null) {
                return;
            }
            ResourceLocation texture = switch (entity.getTypeMoC()) {
                case 1 -> MoCreatures.proxy.getModelTexture("werehuman_dude.png");
                case 2 -> MoCreatures.proxy.getModelTexture("werehuman_classic.png");
                case 4 -> MoCreatures.proxy.getModelTexture("werehuman_woman.png");
                default -> MoCreatures.proxy.getModelTexture("werehuman_oldie.png");
            };
            try {
                this.humanModel.m_6973_((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                this.m_117386_().m_102624_(this.humanModel);
                poseStack.m_85836_();
                poseStack.m_85841_(1.0f, 1.0f, 1.0f);
                VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)texture));
                this.humanModel.m_7695_(poseStack, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                poseStack.m_85849_();
            }
            catch (Exception e) {
                MoCreatures.LOGGER.error("Error rendering werehuman model: {}", (Object)e.getMessage());
            }
        }
    }
}

