/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.renderer.fx.data;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import drzhark.mocreatures.client.renderer.fx.MoCParticles;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class StarParticleData
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<StarParticleData> DESERIALIZER = new ParticleOptions.Deserializer<StarParticleData>(){

        public StarParticleData fromCommand(ParticleType<StarParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            return new StarParticleData(r, g, b);
        }

        public StarParticleData fromNetwork(ParticleType<StarParticleData> type, FriendlyByteBuf buffer) {
            return new StarParticleData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    public final float red;
    public final float green;
    public final float blue;

    public StarParticleData(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", this.m_6012_(), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
    }

    public ParticleType<StarParticleData> m_6012_() {
        return (ParticleType)MoCParticles.STAR_FX.get();
    }
}

