/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.renderer.fx.data;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import drzhark.mocreatures.client.renderer.fx.MoCParticles;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class VacuumParticleData
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<VacuumParticleData> DESERIALIZER = new ParticleOptions.Deserializer<VacuumParticleData>(){

        public VacuumParticleData fromCommand(ParticleType<VacuumParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            return new VacuumParticleData(r, g, b);
        }

        public VacuumParticleData fromNetwork(ParticleType<VacuumParticleData> type, FriendlyByteBuf buffer) {
            return new VacuumParticleData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    public final float red;
    public final float green;
    public final float blue;

    public VacuumParticleData(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", this.m_6012_(), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
    }

    public ParticleType<VacuumParticleData> m_6012_() {
        return (ParticleType)MoCParticles.VACUUM_FX.get();
    }
}

