/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.renderer.fx.data;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import drzhark.mocreatures.client.renderer.fx.MoCParticles;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class VanishParticleData
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<VanishParticleData> DESERIALIZER = new ParticleOptions.Deserializer<VanishParticleData>(){

        public VanishParticleData fromCommand(ParticleType<VanishParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            reader.expect(' ');
            boolean implode = reader.readBoolean();
            return new VanishParticleData(r, g, b, implode);
        }

        public VanishParticleData fromNetwork(ParticleType<VanishParticleData> type, FriendlyByteBuf buffer) {
            return new VanishParticleData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readBoolean());
        }
    };
    public final float red;
    public final float green;
    public final float blue;
    public final boolean implode;

    public VanishParticleData(float red, float green, float blue, boolean implode) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.implode = implode;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
        buffer.writeBoolean(this.implode);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %b", this.m_6012_(), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), this.implode);
    }

    public ParticleType<VanishParticleData> m_6012_() {
        return (ParticleType)MoCParticles.VANISH_FX.get();
    }
}

