/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.client.renderer.fx.impl;

import drzhark.mocreatures.client.renderer.fx.data.VacuumParticleData;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoCEntityFXVacuum
extends TextureSheetParticle {
    private final float initialScale;
    private final double startX;
    private final double startY;
    private final double startZ;

    public MoCEntityFXVacuum(ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, float red, float green, float blue, SpriteSet spriteSet) {
        super(world, x, y, z, xSpeed, ySpeed, zSpeed);
        this.f_107227_ = red;
        this.f_107228_ = green;
        this.f_107229_ = blue;
        this.startX = x;
        this.startY = y;
        this.startZ = z;
        this.initialScale = this.f_107663_ = this.f_107223_.m_188501_() * 0.2f + 0.5f;
        this.f_107225_ = (int)(Math.random() * 10.0) + 30;
        this.m_108337_(spriteSet.m_5819_(0, this.f_107225_));
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        float t = (float)this.f_107224_ / (float)this.f_107225_;
        float scaleFactor = -t + t * t * 2.0f;
        scaleFactor = 1.0f - scaleFactor;
        this.f_107212_ = this.startX + this.f_107215_ * (double)scaleFactor;
        this.f_107213_ = this.startY + this.f_107216_ * (double)scaleFactor + (double)(1.0f - t);
        this.f_107214_ = this.startZ + this.f_107217_ * (double)scaleFactor;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    public int m_6355_(float partialTick) {
        int base = super.m_6355_(partialTick);
        float t = (float)this.f_107224_ / (float)this.f_107225_;
        t = t * t * t;
        int low = base & 0xFF;
        int high = base >> 16 & 0xFF;
        if ((high += (int)(t * 15.0f * 16.0f)) > 240) {
            high = 240;
        }
        return low | high << 16;
    }

    public float m_5902_(float partialTicks) {
        float lifeRatio = ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
        lifeRatio = 1.0f - lifeRatio;
        lifeRatio *= lifeRatio;
        lifeRatio = 1.0f - lifeRatio;
        return this.initialScale * lifeRatio;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public static class Factory
    implements ParticleProvider<VacuumParticleData> {
        private final SpriteSet sprite;

        public Factory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(VacuumParticleData data, ClientLevel world, double x, double y, double z, double dx, double dy, double dz) {
            return new MoCEntityFXVacuum(world, x, y, z, dx, dy, dz, data.red, data.green, data.blue, this.sprite);
        }
    }
}

