/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.compat.datafixes;

import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;

public class BlockIDFixer
extends DataFix {
    private static final Map<ResourceLocation, ResourceLocation> BLOCK_NAME_MAPPINGS = new HashMap<ResourceLocation, ResourceLocation>();

    public BlockIDFixer(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public TypeRewriteRule makeRule() {
        return null;
    }

    @SubscribeEvent
    public void onMissingBlockMappings(MissingMappingsEvent event) {
        event.getMappings(ForgeRegistries.BLOCKS.getRegistryKey(), "mocreatures").forEach(mapping -> {
            Block newBlock;
            ResourceLocation oldName = mapping.getKey();
            ResourceLocation newName = BLOCK_NAME_MAPPINGS.get(oldName);
            if (newName != null && (newBlock = (Block)ForgeRegistries.BLOCKS.getValue(newName)) != null) {
                mapping.remap((Object)newBlock);
            }
        });
    }

    @SubscribeEvent
    public void onMissingItemMappings(MissingMappingsEvent event) {
        event.getMappings(ForgeRegistries.ITEMS.getRegistryKey(), "mocreatures").forEach(mapping -> {
            Item newItem;
            ResourceLocation oldName = mapping.getKey();
            ResourceLocation newName = BLOCK_NAME_MAPPINGS.get(oldName);
            if (newName != null && (newItem = (Item)ForgeRegistries.ITEMS.getValue(newName)) != null) {
                mapping.remap((Object)newItem);
            }
        });
    }

    static {
        BLOCK_NAME_MAPPINGS.put(new ResourceLocation("mocreatures", "MoCStone"), new ResourceLocation("mocreatures", "wyvstone"));
        BLOCK_NAME_MAPPINGS.put(new ResourceLocation("mocreatures", "MoCGrass"), new ResourceLocation("mocreatures", "wyvgrass"));
        BLOCK_NAME_MAPPINGS.put(new ResourceLocation("mocreatures", "MoCDirt"), new ResourceLocation("mocreatures", "wyvdirt"));
        BLOCK_NAME_MAPPINGS.put(new ResourceLocation("mocreatures", "MoCLeaves"), new ResourceLocation("mocreatures", "wyvwood_leaves"));
        BLOCK_NAME_MAPPINGS.put(new ResourceLocation("mocreatures", "MoCLog"), new ResourceLocation("mocreatures", "wyvwood_log"));
        BLOCK_NAME_MAPPINGS.put(new ResourceLocation("mocreatures", "MoCTallGrass"), new ResourceLocation("mocreatures", "tall_wyvgrass"));
        BLOCK_NAME_MAPPINGS.put(new ResourceLocation("mocreatures", "MoCWoodPlank"), new ResourceLocation("mocreatures", "wyvwood_planks"));
    }
}

