/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.config.biome;

import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.config.biome.BiomeSpawnConfig;
import drzhark.mocreatures.config.biome.DefaultBiomes;
import drzhark.mocreatures.config.biome.SpawnBiomeConfig;
import drzhark.mocreatures.config.biome.SpawnBiomeData;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Deprecated(forRemoval=true)
public class BiomeConfig {
    public static final Pair<String, SpawnBiomeData> blackBear = Pair.of((Object)"mocreatures:black_bear_spawns", (Object)DefaultBiomes.BLACK_BEAR);
    public static final Pair<String, SpawnBiomeData> grizzlyBear = Pair.of((Object)"mocreatures:grizzly_bear_spawns", (Object)DefaultBiomes.GRIZZLY_BEAR);
    public static final Pair<String, SpawnBiomeData> polarBear = Pair.of((Object)"mocreatures:polar_bear_spawns", (Object)DefaultBiomes.POLAR_BEAR);
    public static final Pair<String, SpawnBiomeData> pandaBear = Pair.of((Object)"mocreatures:panda_bear_spawns", (Object)DefaultBiomes.PANDA_BEAR);
    public static final Pair<String, SpawnBiomeData> bird = Pair.of((Object)"mocreatures:bird_spawns", (Object)DefaultBiomes.BIRD);
    public static final Pair<String, SpawnBiomeData> duck = Pair.of((Object)"mocreatures:duck_spawns", (Object)DefaultBiomes.DUCK);
    public static final Pair<String, SpawnBiomeData> turkey = Pair.of((Object)"mocreatures:turkey_spawns", (Object)DefaultBiomes.TURKEY);
    public static final Pair<String, SpawnBiomeData> boar = Pair.of((Object)"mocreatures:boar_spawns", (Object)DefaultBiomes.BOAR);
    public static final Pair<String, SpawnBiomeData> bunny = Pair.of((Object)"mocreatures:bunny_spawns", (Object)DefaultBiomes.BUNNY);
    public static final Pair<String, SpawnBiomeData> deer = Pair.of((Object)"mocreatures:deer_spawns", (Object)DefaultBiomes.DEER);
    public static final Pair<String, SpawnBiomeData> goat = Pair.of((Object)"mocreatures:goat_spawns", (Object)DefaultBiomes.GOAT);
    public static final Pair<String, SpawnBiomeData> kitty = Pair.of((Object)"mocreatures:kitty_spawns", (Object)DefaultBiomes.KITTY);
    public static final Pair<String, SpawnBiomeData> crocodile = Pair.of((Object)"mocreatures:crocodile_spawns", (Object)DefaultBiomes.MOC_CROCODILE);
    public static final Pair<String, SpawnBiomeData> turtle = Pair.of((Object)"mocreatures:turtle_spawns", (Object)DefaultBiomes.TURTLE);
    public static final Pair<String, SpawnBiomeData> elephant = Pair.of((Object)"mocreatures:elephant_spawns", (Object)DefaultBiomes.MOC_ELEPHANT);
    public static final Pair<String, SpawnBiomeData> filchLizard = Pair.of((Object)"mocreatures:filch_lizard_spawns", (Object)DefaultBiomes.FILCH_LIZARD);
    public static final Pair<String, SpawnBiomeData> ostrich = Pair.of((Object)"mocreatures:ostrich_spawns", (Object)DefaultBiomes.OSTRICH);
    public static final Pair<String, SpawnBiomeData> fox = Pair.of((Object)"mocreatures:fox_spawns", (Object)DefaultBiomes.MOC_FOX);
    public static final Pair<String, SpawnBiomeData> komodoDragon = Pair.of((Object)"mocreatures:komodo_dragon_spawns", (Object)DefaultBiomes.MOC_KOMODO_DRAGON);
    public static final Pair<String, SpawnBiomeData> snake = Pair.of((Object)"mocreatures:snake_spawns", (Object)DefaultBiomes.SNAKE);
    public static final Pair<String, SpawnBiomeData> leopard = Pair.of((Object)"mocreatures:leopard_spawns", (Object)DefaultBiomes.LEOPARD);
    public static final Pair<String, SpawnBiomeData> lion = Pair.of((Object)"mocreatures:lion_spawns", (Object)DefaultBiomes.LION);
    public static final Pair<String, SpawnBiomeData> panther = Pair.of((Object)"mocreatures:panther_spawns", (Object)DefaultBiomes.PANTHER);
    public static final Pair<String, SpawnBiomeData> tiger = Pair.of((Object)"mocreatures:tiger_spawns", (Object)DefaultBiomes.MOC_TIGER);
    public static final Pair<String, SpawnBiomeData> liger = Pair.of((Object)"mocreatures:liger_spawns", (Object)DefaultBiomes.LIGER);
    public static final Pair<String, SpawnBiomeData> lither = Pair.of((Object)"mocreatures:lither_spawns", (Object)DefaultBiomes.LITHER);
    public static final Pair<String, SpawnBiomeData> panthger = Pair.of((Object)"mocreatures:panthger_spawns", (Object)DefaultBiomes.PANTHGER);
    public static final Pair<String, SpawnBiomeData> panthard = Pair.of((Object)"mocreatures:panthard_spawns", (Object)DefaultBiomes.PANTHARD);
    public static final Pair<String, SpawnBiomeData> leoger = Pair.of((Object)"mocreatures:leoger_spawns", (Object)DefaultBiomes.LEOGER);
    public static final Pair<String, SpawnBiomeData> mouse = Pair.of((Object)"mocreatures:mouse_spawns", (Object)DefaultBiomes.MOUSE);
    public static final Pair<String, SpawnBiomeData> mole = Pair.of((Object)"mocreatures:mole_spawns", (Object)DefaultBiomes.MOLE);
    public static final Pair<String, SpawnBiomeData> raccoon = Pair.of((Object)"mocreatures:raccoon_spawns", (Object)DefaultBiomes.MOC_RACCOON);
    public static final Pair<String, SpawnBiomeData> wildHorse = Pair.of((Object)"mocreatures:wild_horse_spawns", (Object)DefaultBiomes.WILD_HORSE);
    public static final Pair<String, SpawnBiomeData> ent = Pair.of((Object)"mocreatures:ent_spawns", (Object)DefaultBiomes.ENT);
    public static final Pair<String, SpawnBiomeData> wyvern = Pair.of((Object)"mocreatures:wyvern_spawns", (Object)DefaultBiomes.WYVERN);
    public static final Pair<String, SpawnBiomeData> greenOgre = Pair.of((Object)"mocreatures:green_ogre_spawns", (Object)DefaultBiomes.GREEN_OGRE);
    public static final Pair<String, SpawnBiomeData> caveOgre = Pair.of((Object)"mocreatures:cave_ogre_spawns", (Object)DefaultBiomes.CAVE_OGRE);
    public static final Pair<String, SpawnBiomeData> fireOgre = Pair.of((Object)"mocreatures:fire_ogre_spawns", (Object)DefaultBiomes.FIRE_OGRE);
    public static final Pair<String, SpawnBiomeData> caveScorpion = Pair.of((Object)"mocreatures:cave_scorpion_spawns", (Object)DefaultBiomes.CAVE_SCORPION);
    public static final Pair<String, SpawnBiomeData> dirtScorpion = Pair.of((Object)"mocreatures:dirt_scorpion_spawns", (Object)DefaultBiomes.DIRT_SCORPION);
    public static final Pair<String, SpawnBiomeData> fireScorpion = Pair.of((Object)"mocreatures:fire_scorpion_spawns", (Object)DefaultBiomes.FIRE_SCORPION);
    public static final Pair<String, SpawnBiomeData> frostScorpion = Pair.of((Object)"mocreatures:frost_scorpion_spawns", (Object)DefaultBiomes.FROST_SCORPION);
    public static final Pair<String, SpawnBiomeData> undeadScorpion = Pair.of((Object)"mocreatures:undead_scorpion_spawns", (Object)DefaultBiomes.UNDEAD_SCORPION);
    public static final Pair<String, SpawnBiomeData> bigGolem = Pair.of((Object)"mocreatures:big_golem_spawns", (Object)DefaultBiomes.BIG_GOLEM);
    public static final Pair<String, SpawnBiomeData> miniGolem = Pair.of((Object)"mocreatures:mini_golem_spawns", (Object)DefaultBiomes.MINI_GOLEM);
    public static final Pair<String, SpawnBiomeData> darkManticore = Pair.of((Object)"mocreatures:dark_manticore_spawns", (Object)DefaultBiomes.DARK_MANTICORE);
    public static final Pair<String, SpawnBiomeData> fireManticore = Pair.of((Object)"mocreatures:fire_manticore_spawns", (Object)DefaultBiomes.FIRE_MANTICORE);
    public static final Pair<String, SpawnBiomeData> frostManticore = Pair.of((Object)"mocreatures:frost_manticore_spawns", (Object)DefaultBiomes.FROST_MANTICORE);
    public static final Pair<String, SpawnBiomeData> plainManticore = Pair.of((Object)"mocreatures:plain_manticore_spawns", (Object)DefaultBiomes.PLAIN_MANTICORE);
    public static final Pair<String, SpawnBiomeData> toxicManticore = Pair.of((Object)"mocreatures:toxic_manticore_spawns", (Object)DefaultBiomes.TOXIC_MANTICORE);
    public static final Pair<String, SpawnBiomeData> werewolf = Pair.of((Object)"mocreatures:werewolf_spawns", (Object)DefaultBiomes.WEREWOLF);
    public static final Pair<String, SpawnBiomeData> wwolf = Pair.of((Object)"mocreatures:wwolf_spawns", (Object)DefaultBiomes.WWOLF);
    public static final Pair<String, SpawnBiomeData> rat = Pair.of((Object)"mocreatures:rat_spawns", (Object)DefaultBiomes.RAT);
    public static final Pair<String, SpawnBiomeData> hellRat = Pair.of((Object)"mocreatures:hell_rat_spawns", (Object)DefaultBiomes.HELL_RAT);
    public static final Pair<String, SpawnBiomeData> silverSkeleton = Pair.of((Object)"mocreatures:silver_skeleton_spawns", (Object)DefaultBiomes.SILVER_SKELETON);
    public static final Pair<String, SpawnBiomeData> wraith = Pair.of((Object)"mocreatures:wraith_spawns", (Object)DefaultBiomes.WRAITH);
    public static final Pair<String, SpawnBiomeData> flameWraith = Pair.of((Object)"mocreatures:flame_wraith_spawns", (Object)DefaultBiomes.FLAME_WRAITH);
    public static final Pair<String, SpawnBiomeData> horseMob = Pair.of((Object)"mocreatures:horse_mob_spawns", (Object)DefaultBiomes.HORSE_MOB);
    public static final Pair<String, SpawnBiomeData> dolphin = Pair.of((Object)"mocreatures:dolphin_spawns", (Object)DefaultBiomes.DOLPHIN);
    public static final Pair<String, SpawnBiomeData> shark = Pair.of((Object)"mocreatures:shark_spawns", (Object)DefaultBiomes.SHARK);
    public static final Pair<String, SpawnBiomeData> mantaRay = Pair.of((Object)"mocreatures:manta_ray_spawns", (Object)DefaultBiomes.MANTA_RAY);
    public static final Pair<String, SpawnBiomeData> jellyfish = Pair.of((Object)"mocreatures:jellyfish_spawns", (Object)DefaultBiomes.JELLYFISH);
    public static final Pair<String, SpawnBiomeData> bass = Pair.of((Object)"mocreatures:bass_spawns", (Object)DefaultBiomes.BASS);
    public static final Pair<String, SpawnBiomeData> stingRay = Pair.of((Object)"mocreatures:sting_ray_spawns", (Object)DefaultBiomes.STING_RAY);
    public static final Pair<String, SpawnBiomeData> anchovy = Pair.of((Object)"mocreatures:anchovy_spawns", (Object)DefaultBiomes.ANCHOVY);
    public static final Pair<String, SpawnBiomeData> angelfish = Pair.of((Object)"mocreatures:angelfish_spawns", (Object)DefaultBiomes.ANGELFISH);
    public static final Pair<String, SpawnBiomeData> angler = Pair.of((Object)"mocreatures:angler_spawns", (Object)DefaultBiomes.ANGLER);
    public static final Pair<String, SpawnBiomeData> clownfish = Pair.of((Object)"mocreatures:clownfish_spawns", (Object)DefaultBiomes.CLOWNFISH);
    public static final Pair<String, SpawnBiomeData> goldfish = Pair.of((Object)"mocreatures:goldfish_spawns", (Object)DefaultBiomes.GOLDFISH);
    public static final Pair<String, SpawnBiomeData> hippotang = Pair.of((Object)"mocreatures:hippotang_spawns", (Object)DefaultBiomes.HIPPOTANG);
    public static final Pair<String, SpawnBiomeData> manderin = Pair.of((Object)"mocreatures:manderin_spawns", (Object)DefaultBiomes.MANDERIN);
    public static final Pair<String, SpawnBiomeData> cod = Pair.of((Object)"mocreatures:cod_spawns", (Object)DefaultBiomes.COD);
    public static final Pair<String, SpawnBiomeData> salmon = Pair.of((Object)"mocreatures:salmon_spawns", (Object)DefaultBiomes.SALMON);
    public static final Pair<String, SpawnBiomeData> piranha = Pair.of((Object)"mocreatures:piranha_spawns", (Object)DefaultBiomes.PIRANHA);
    public static final Pair<String, SpawnBiomeData> fishy = Pair.of((Object)"mocreatures:fishy_spawns", (Object)DefaultBiomes.FISHY);
    public static final Pair<String, SpawnBiomeData> ant = Pair.of((Object)"mocreatures:ant_spawns", (Object)DefaultBiomes.ANT);
    public static final Pair<String, SpawnBiomeData> bee = Pair.of((Object)"mocreatures:bee_spawns", (Object)DefaultBiomes.BEE);
    public static final Pair<String, SpawnBiomeData> butterfly = Pair.of((Object)"mocreatures:butterfly_spawns", (Object)DefaultBiomes.BUTTERFLY);
    public static final Pair<String, SpawnBiomeData> cricket = Pair.of((Object)"mocreatures:cricket_spawns", (Object)DefaultBiomes.CRICKET);
    public static final Pair<String, SpawnBiomeData> dragonfly = Pair.of((Object)"mocreatures:dragonfly_spawns", (Object)DefaultBiomes.DRAGONFLY);
    public static final Pair<String, SpawnBiomeData> firefly = Pair.of((Object)"mocreatures:firefly_spawns", (Object)DefaultBiomes.FIREFLY);
    public static final Pair<String, SpawnBiomeData> fly = Pair.of((Object)"mocreatures:fly_spawns", (Object)DefaultBiomes.MOC_FLY);
    public static final Pair<String, SpawnBiomeData> grasshopper = Pair.of((Object)"mocreatures:grasshopper_spawns", (Object)DefaultBiomes.GRASSHOPPER);
    public static final Pair<String, SpawnBiomeData> maggot = Pair.of((Object)"mocreatures:maggot_spawns", (Object)DefaultBiomes.MAGGOT);
    public static final Pair<String, SpawnBiomeData> roach = Pair.of((Object)"mocreatures:roach_spawns", (Object)DefaultBiomes.ROACH);
    public static final Pair<String, SpawnBiomeData> crab = Pair.of((Object)"mocreatures:crab_spawns", (Object)DefaultBiomes.CRAB);
    public static final Pair<String, SpawnBiomeData> snail = Pair.of((Object)"mocreatures:snail_spawns", (Object)DefaultBiomes.SNAIL);
    private static boolean init = false;
    private static final Map<String, SpawnBiomeData> biomeConfigValues = new HashMap<String, SpawnBiomeData>();

    public static void init() {
        try {
            MoCreatures.LOGGER.info("Initializing BiomeConfig...");
            BiomeSpawnConfig.init();
            for (Field f : BiomeConfig.class.getDeclaredFields()) {
                Object obj = f.get(null);
                if (!(obj instanceof Pair)) continue;
                String id = (String)((Pair)obj).getLeft();
                SpawnBiomeData data = (SpawnBiomeData)((Pair)obj).getRight();
                biomeConfigValues.put(id, SpawnBiomeConfig.create(new ResourceLocation(id), data));
                MoCreatures.LOGGER.debug("Registered biome config: {}", (Object)id);
            }
            MoCreatures.LOGGER.info("BiomeConfig initialized with {} entries", (Object)biomeConfigValues.size());
        }
        catch (Exception e) {
            MoCreatures.LOGGER.error("Encountered error building Mo' Creatures biome config .json files", (Throwable)e);
        }
        init = true;
    }

    public static boolean test(Pair<String, SpawnBiomeData> entry, Holder<Biome> biome, ResourceLocation name) {
        if (!init) {
            MoCreatures.LOGGER.warn("BiomeConfig test called before initialization!");
            return false;
        }
        SpawnBiomeData data = biomeConfigValues.get(entry.getKey());
        if (data == null) {
            MoCreatures.LOGGER.warn("No biome config data found for: {}", entry.getKey());
            return false;
        }
        boolean result = data.matches(biome, name);
        if (result) {
            MoCreatures.LOGGER.info("Biome {} matches config {}", (Object)name, entry.getKey());
        }
        return result;
    }

    public static boolean test(Pair<String, SpawnBiomeData> spawns, Holder<Biome> biome) {
        return BiomeConfig.test(spawns, biome, ForgeRegistries.BIOMES.getKey((Object)((Biome)biome.m_203334_())));
    }
}

