/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.dimension.worldgen;

import drzhark.mocreatures.dimension.worldgen.MoCWorldGenPortal;
import drzhark.mocreatures.registry.MoCPOI;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class MoCDirectTeleporter
implements ITeleporter {
    private final BlockPos pos;
    private final boolean generateStructure;

    public MoCDirectTeleporter(BlockPos pos, boolean generateStructure) {
        this.pos = pos;
        this.generateStructure = generateStructure;
    }

    public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        BlockState block;
        Entity newEntity = repositionEntity.apply(false);
        if (this.generateStructure && !(block = destWorld.m_8055_(this.pos)).m_60713_(Blocks.f_50333_)) {
            MoCWorldGenPortal portalGen = new MoCWorldGenPortal(Blocks.f_50283_.m_49966_(), Blocks.f_50284_.m_49966_(), Blocks.f_50333_.m_49966_(), Blocks.f_50333_.m_49966_());
            portalGen.generate(destWorld, destWorld.m_213780_(), this.pos);
            this.registerPortalPOI(destWorld, this.pos);
            this.ensureSafeLanding(destWorld, this.pos);
        }
        destWorld.m_7654_().m_6937_((Runnable)new TickTask(0, () -> {
            if (newEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)newEntity;
                player.f_8906_.m_9774_((double)this.pos.m_123341_() + 0.5, (double)(this.pos.m_123342_() + 1), (double)this.pos.m_123343_() + 0.5, yaw, player.m_146909_());
                player.f_19789_ = 0.0f;
                player.m_20256_(Vec3.f_82478_);
                System.out.println("[MoC Portal] Teleported player to " + this.pos);
            } else {
                newEntity.m_6021_((double)this.pos.m_123341_() + 0.5, (double)(this.pos.m_123342_() + 1), (double)this.pos.m_123343_() + 0.5);
                newEntity.m_146922_(yaw);
                newEntity.m_20256_(Vec3.f_82478_);
                newEntity.f_19789_ = 0.0f;
            }
        }));
        return newEntity;
    }

    private void ensureSafeLanding(ServerLevel world, BlockPos pos) {
        boolean needsPlatform = false;
        for (int y = 1; y <= 5; ++y) {
            BlockPos checkPos = pos.m_6625_(y);
            if (world.m_8055_(checkPos).m_60795_()) continue;
            return;
        }
        System.out.println("[MoC Portal] Creating safety platform at " + pos);
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                BlockPos platformPos = pos.m_7918_(dx, -1, dz);
                world.m_7731_(platformPos, Blocks.f_50333_.m_49966_(), 3);
            }
        }
    }

    private void registerPortalPOI(ServerLevel world, BlockPos pos) {
        PoiManager poiManager = world.m_8904_();
        poiManager.m_27056_((LevelReader)world, pos, 8);
        poiManager.m_217919_(pos, (Holder)MoCPOI.WYVERN_PORTAL.getHolder().get());
        System.out.println("[MoC Portal] Registered wyvern portal POI at " + pos);
    }
}

