/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.dimension.worldgen;

import drzhark.mocreatures.registry.MoCPOI;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MoCWorldGenPortal {
    private final BlockState pillarBlock;
    private final BlockState stairBlock;
    private final BlockState wallBlock;
    private final BlockState centerBlock;

    public MoCWorldGenPortal(BlockState pillar, BlockState stair, BlockState wall, BlockState center) {
        this.pillarBlock = pillar;
        this.stairBlock = stair;
        this.wallBlock = wall;
        this.centerBlock = center;
    }

    public void generatePillar(ServerLevel world, BlockPos pos) {
        for (int y = 0; y < 6; ++y) {
            BlockPos target = pos.m_6630_(y);
            world.m_7731_(target, this.pillarBlock, 2);
        }
    }

    public void generate(ServerLevel world, RandomSource rand, BlockPos pos) {
        int nZ;
        if (!world.m_46859_(pos)) {
            return;
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_() - 1;
        int z = pos.m_123343_();
        this.createFoundation(world, x, y, z);
        for (int nZ2 = z - 3; nZ2 <= z + 2; nZ2 += 5) {
            Direction facing = nZ2 < z ? Direction.SOUTH : Direction.NORTH;
            for (int nX = x - 2; nX < x + 2; ++nX) {
                BlockPos stairPos = new BlockPos(nX, y + 1, nZ2);
                BlockState facingStair = (BlockState)this.stairBlock.m_61124_((Property)StairBlock.f_56841_, (Comparable)facing);
                world.m_7731_(stairPos, facingStair, 2);
            }
        }
        for (int nX = x - 2; nX < x + 2; ++nX) {
            for (int nZ3 = z - 2; nZ3 < z + 2; ++nZ3) {
                world.m_7731_(new BlockPos(nX, y + 1, nZ3), this.wallBlock, 2);
            }
        }
        BlockPos centerPos = new BlockPos(x, y + 1, z);
        for (int nX = x - 1; nX < x + 1; ++nX) {
            for (nZ = z - 1; nZ < z + 1; ++nZ) {
                world.m_7731_(new BlockPos(nX, y + 1, nZ), this.centerBlock, 2);
            }
        }
        for (int j = x - 3; j < x + 3; j += 5) {
            for (nZ = z - 3; nZ < z + 3; ++nZ) {
                world.m_7731_(new BlockPos(j, y + 6, nZ), this.wallBlock, 2);
            }
        }
        this.generatePillar(world, new BlockPos(x - 3, y, z - 3));
        this.generatePillar(world, new BlockPos(x - 3, y, z + 2));
        this.generatePillar(world, new BlockPos(x + 2, y, z - 3));
        this.generatePillar(world, new BlockPos(x + 2, y, z + 2));
        this.registerPortalPOI(world, centerPos);
    }

    private void createFoundation(ServerLevel world, int x, int y, int z) {
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dz = -3; dz <= 3; ++dz) {
                int depth = Math.abs(dx) <= 2 && Math.abs(dz) <= 2 ? 3 : 2;
                for (int dy = 0; dy < depth; ++dy) {
                    BlockPos foundationPos = new BlockPos(x + dx, y - dy, z + dz);
                    BlockState existingState = world.m_8055_(foundationPos);
                    if (!existingState.m_60795_() && existingState.m_60734_() != Blocks.f_49990_ && !existingState.m_204336_(BlockTags.f_13035_) && existingState.m_60734_() != Blocks.f_50050_ && existingState.m_60734_() != Blocks.f_50052_ && existingState.m_60734_() != Blocks.f_50051_ && existingState.m_60734_() != Blocks.f_50053_ && existingState.m_60734_() != Blocks.f_50054_ && existingState.m_60734_() != Blocks.f_50055_) continue;
                    BlockState foundationBlock = dy == 0 ? this.wallBlock : ((dx + dz) % 2 == 0 ? Blocks.f_50333_.m_49966_() : Blocks.f_50714_.m_49966_());
                    world.m_7731_(foundationPos, foundationBlock, 2);
                }
            }
        }
    }

    private void registerPortalPOI(ServerLevel world, BlockPos pos) {
        PoiManager poiManager = world.m_8904_();
        poiManager.m_27056_((LevelReader)world, pos, 8);
        poiManager.m_217919_(pos, (Holder)MoCPOI.WYVERN_PORTAL.getHolder().get());
        System.out.println("[MoC Portal] Registered wyvern portal POI at " + pos);
    }
}

