/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public abstract class MoCEntityAmbient
extends PathfinderMob
implements IMoCEntity {
    private static final EntityDataAccessor<Boolean> ADULT = SynchedEntityData.m_135353_(MoCEntityAmbient.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(MoCEntityAmbient.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(MoCEntityAmbient.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> NAME_STR = SynchedEntityData.m_135353_(MoCEntityAmbient.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected String texture;
    protected boolean riderIsDisconnecting;

    protected MoCEntityAmbient(EntityType<? extends MoCEntityAmbient> type, Level world) {
        super(type, world);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component m_7755_() {
        String translated;
        String entityString = this.m_6095_().m_20675_();
        if (!MoCreatures.proxy.verboseEntityNames || entityString == null) {
            return super.m_7755_();
        }
        String registryName = this.m_6095_().m_20675_();
        String translationKey = "entity." + registryName + ".verbose.name";
        if (!translationKey.equals(translated = I18n.m_118938_((String)translationKey, (Object[])new Object[0]))) {
            return Component.m_237115_((String)translationKey);
        }
        return super.m_7755_();
    }

    @Override
    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getModelTexture(this.texture);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.selectType();
        return super.m_6518_(world, difficulty, reason, spawnData, dataTag);
    }

    @Override
    public void selectType() {
        this.setTypeMoC(1);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ADULT, (Object)false);
        this.f_19804_.m_135372_(TYPE, (Object)0);
        this.f_19804_.m_135372_(AGE, (Object)45);
        this.f_19804_.m_135372_(NAME_STR, (Object)"");
    }

    @Override
    public int getTypeMoC() {
        return (Integer)this.f_19804_.m_135370_(TYPE);
    }

    @Override
    public void setTypeMoC(int i) {
        this.f_19804_.m_135381_(TYPE, (Object)i);
    }

    @Override
    public boolean renderName() {
        return MoCreatures.proxy.getDisplayPetName() && this.getPetName() != null && !this.getPetName().isEmpty() && !this.m_20160_() && this.m_20202_() == null;
    }

    @Override
    public boolean getIsAdult() {
        return (Boolean)this.f_19804_.m_135370_(ADULT);
    }

    @Override
    public void setAdult(boolean flag) {
        this.f_19804_.m_135381_(ADULT, (Object)flag);
    }

    @Override
    public String getPetName() {
        return (String)this.f_19804_.m_135370_(NAME_STR);
    }

    @Override
    public void setPetName(String name) {
        this.f_19804_.m_135381_(NAME_STR, (Object)name);
    }

    @Override
    public int getMoCAge() {
        return (Integer)this.f_19804_.m_135370_(AGE);
    }

    @Override
    public void setMoCAge(int i) {
        this.f_19804_.m_135381_(AGE, (Object)i);
    }

    @Override
    public boolean getIsTamed() {
        return false;
    }

    @Override
    public int getOwnerPetId() {
        return 0;
    }

    @Override
    public void setOwnerPetId(int petId) {
    }

    @Override
    public UUID getOwnerId() {
        return null;
    }

    @Override
    public boolean checkSpawningBiome() {
        return true;
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_ && this.isMovementCeased()) {
            this.m_21573_().m_26573_();
        }
        super.m_8119_();
    }

    public void dropMyStuff() {
    }

    protected boolean isMyHealFood(ItemStack itemstack) {
        return false;
    }

    public void faceLocation(int x, int y, int z, float maxTurn) {
        double dx = (double)x + 0.5 - this.m_20185_();
        double dz = (double)z + 0.5 - this.m_20189_();
        double dy = (double)y + 0.5 - this.m_20186_();
        double horizontalDist = Mth.m_14116_((float)((float)(dx * dx + dz * dz)));
        float targetYaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        float targetPitch = (float)(-(Mth.m_14136_((double)dy, (double)horizontalDist) * 57.29577951308232));
        this.m_146926_(-this.updateRotation(this.m_146909_(), targetPitch, maxTurn));
        this.m_146922_(this.updateRotation(this.m_146908_(), targetYaw, maxTurn));
    }

    private float updateRotation(float current, float intended, float maxIncrement) {
        float diff;
        for (diff = intended - current; diff < -180.0f; diff += 360.0f) {
        }
        while (diff >= 180.0f) {
            diff -= 360.0f;
        }
        if (diff > maxIncrement) {
            diff = maxIncrement;
        }
        if (diff < -maxIncrement) {
            diff = -maxIncrement;
        }
        return current + diff;
    }

    public void getMyOwnPath(Entity target, float speed) {
        PathNavigation nav = this.m_21573_();
        Path path = nav.m_6570_(target, 0);
        if (path != null) {
            nav.m_26536_(path, (double)speed);
        }
    }

    public static boolean getCanSpawnHere(EntityType<MoCEntityAmbient> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, Random randomIn) {
        boolean willSpawn = world.m_45527_(pos);
        if (willSpawn && MoCreatures.proxy.debug) {
            BlockState bs = world.m_8055_(pos);
            MoCreatures.LOGGER.info("Ambient: " + type.m_20676_() + " at: " + pos + " State: " + bs + " biome: " + MoCTools.biomeName((Level)world.m_6018_(), pos));
        }
        return willSpawn;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        CompoundTag entityData = MoCTools.getEntityData((Entity)this);
        entityData.m_128379_("Adult", this.getIsAdult());
        entityData.m_128405_("Edad", this.getMoCAge());
        entityData.m_128359_("Name", this.getPetName());
        entityData.m_128405_("TypeInt", this.getTypeMoC());
        compound.m_128365_("MoCData", (Tag)entityData);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        CompoundTag entityData = MoCTools.getEntityData((Entity)this);
        if (compound.m_128425_("MoCData", 10)) {
            CompoundTag mocTag = compound.m_128469_("MoCData");
            this.setAdult(mocTag.m_128471_("Adult"));
            this.setMoCAge(mocTag.m_128451_("Edad"));
            this.setPetName(mocTag.m_128461_("Name"));
            this.setTypeMoC(mocTag.m_128451_("TypeInt"));
        }
    }

    @Override
    public void makeEntityJump() {
    }

    @Override
    public boolean isFlyer() {
        return false;
    }

    @Override
    public void makeEntityDive() {
    }

    @Override
    public int nameYOffset() {
        return -80;
    }

    @Override
    public void performAnimation(int attackType) {
    }

    public boolean isMyFavoriteFood(ItemStack stack) {
        return false;
    }

    public boolean isOnAir() {
        BlockPos below1 = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)(this.m_20186_() - 0.2)), Mth.m_14107_((double)this.m_20189_()));
        BlockPos below2 = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)(this.m_20186_() - 1.2)), Mth.m_14107_((double)this.m_20189_()));
        return this.m_9236_().m_46859_(below1) && this.m_9236_().m_46859_(below2);
    }

    @Override
    public float getSizeFactor() {
        return 1.0f;
    }

    @Override
    public float getAdjustedYOffset() {
        return 0.0f;
    }

    public boolean getIsRideable() {
        return false;
    }

    public void setRideable(boolean b) {
    }

    @Override
    public void setArmorType(int i) {
    }

    protected LivingEntity getBoogey(double d) {
        LivingEntity result = null;
        AABB box = this.m_20191_().m_82377_(d, 4.0, d);
        List list = this.m_9236_().m_45933_((Entity)this, box);
        for (Entity entity : list) {
            if (!this.entitiesToInclude(entity)) continue;
            result = (LivingEntity)entity;
            break;
        }
        return result;
    }

    public boolean entitiesToInclude(Entity entity) {
        return entity instanceof LivingEntity && ((double)entity.m_20205_() >= 0.5 || (double)entity.m_20206_() >= 0.5);
    }

    @Override
    public float pitchRotationOffset() {
        return 0.0f;
    }

    @Override
    public float rollRotationOffset() {
        return 0.0f;
    }

    @Override
    public float yawRotationOffset() {
        return 0.0f;
    }

    @Override
    public float getAdjustedZOffset() {
        return 0.0f;
    }

    @Override
    public float getAdjustedXOffset() {
        return 0.0f;
    }

    protected boolean canBeTrappedInNet() {
        return this instanceof IMoCTameable && this.getIsTamed();
    }

    @Override
    public boolean canAttackTarget(LivingEntity entity) {
        return false;
    }

    public boolean m_6573_(Player player) {
        if (!this.m_9236_().f_46443_ && !MoCTools.isThisPlayerAnOP(player) && this.getIsTamed() && !player.m_20148_().equals(this.getOwnerId())) {
            return false;
        }
        return super.m_6573_(player);
    }

    @Override
    public boolean getIsSitting() {
        return false;
    }

    @Override
    public boolean isNotScared() {
        return false;
    }

    @Override
    public boolean isMovementCeased() {
        return this.getIsSitting();
    }

    @Override
    public boolean shouldAttackPlayers() {
        return this.m_9236_().m_46791_() != Difficulty.PEACEFUL;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    public double getDivingDepth() {
        return 0.5;
    }

    @Override
    public boolean isDiving() {
        return false;
    }

    @Override
    public void forceEntityJump() {
        this.m_6135_();
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    @Override
    public int minFlyingHeight() {
        return 2;
    }

    @Override
    public int maxFlyingHeight() {
        return 4;
    }

    public void m_7023_(Vec3 movementInput) {
        if (!this.getIsFlying()) {
            super.m_7023_(movementInput);
        } else {
            this.moveEntityWithHeadingFlying(movementInput);
        }
    }

    public void moveEntityWithHeadingFlying(Vec3 vec) {
        if (!this.m_9236_().f_46443_) {
            this.m_19920_(0.1f, vec);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82542_(0.9, 0.9, 0.9));
        } else {
            super.m_7023_(vec);
        }
    }

    @Override
    public boolean getIsFlying() {
        return false;
    }

    @Override
    public boolean getIsGhost() {
        return false;
    }

    public void m_21463_(Entity leashHolder, boolean sendAttachNotification) {
        if (this.getIsTamed() && leashHolder instanceof Player) {
            Player player = (Player)leashHolder;
            if (MoCreatures.proxy.enableOwnership && this.getOwnerId() != null && !player.m_20148_().equals(this.getOwnerId()) && !MoCTools.isThisPlayerAnOP(player)) {
                return;
            }
        }
        super.m_21463_(leashHolder, sendAttachNotification);
    }
}

