/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.ai.EntityAIMoverHelperMoC;
import drzhark.mocreatures.entity.ai.PathNavigateFlyer;
import drzhark.mocreatures.entity.item.MoCEntityEgg;
import drzhark.mocreatures.entity.item.MoCEntityKittyBed;
import drzhark.mocreatures.entity.item.MoCEntityLitterBox;
import drzhark.mocreatures.entity.passive.MoCEntityHorse;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class MoCEntityAnimal
extends Animal
implements IMoCEntity {
    private static final EntityDataAccessor<Boolean> ADULT = SynchedEntityData.m_135353_(MoCEntityAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(MoCEntityAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(MoCEntityAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> NAME_STR = SynchedEntityData.m_135353_(MoCEntityAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected boolean divePending;
    protected boolean jumpPending;
    protected int temper;
    protected boolean isEntityJumping;
    protected boolean riderIsDisconnecting = false;
    protected String texture = "blank.jpg";
    protected boolean isTameable = false;
    protected PathNavigation navigatorWater;
    protected PathNavigation navigatorFlyer;
    private int huntingCounter;
    private int followPlayerCounter;
    private double divingDepth;
    private boolean randomAttributesUpdated;

    protected MoCEntityAnimal(EntityType<? extends MoCEntityAnimal> type, Level world) {
        super(type, world);
        this.navigatorWater = new WaterBoundPathNavigation((Mob)this, world);
        this.f_21342_ = new EntityAIMoverHelperMoC((Mob)this);
        this.navigatorFlyer = new PathNavigateFlyer((Mob)this, world);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component m_7755_() {
        String translated;
        String entityString = this.m_6095_().m_20675_();
        if (!MoCreatures.proxy.verboseEntityNames || entityString == null) {
            return super.m_7755_();
        }
        String registryName = this.m_6095_().m_20675_();
        String translationKey = "entity." + registryName + ".verbose.name";
        if (!translationKey.equals(translated = I18n.m_118938_((String)translationKey, (Object[])new Object[0]))) {
            return Component.m_237115_((String)translationKey);
        }
        return super.m_7755_();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob mate) {
        return null;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 20.0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.selectType();
        return super.m_6518_(world, difficulty, reason, spawnData, dataTag);
    }

    @Override
    public void selectType() {
        this.setTypeMoC(1);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ADULT, (Object)false);
        this.f_19804_.m_135372_(TYPE, (Object)0);
        this.f_19804_.m_135372_(AGE, (Object)45);
        this.f_19804_.m_135372_(NAME_STR, (Object)"");
    }

    @Override
    public int getTypeMoC() {
        return (Integer)this.f_19804_.m_135370_(TYPE);
    }

    @Override
    public void setTypeMoC(int i) {
        this.f_19804_.m_135381_(TYPE, (Object)i);
    }

    public boolean isMale() {
        return this.getTypeMoC() == 1;
    }

    @Override
    public boolean renderName() {
        return MoCreatures.proxy.getDisplayPetName() && this.getPetName() != null && !this.getPetName().isEmpty() && !this.m_20160_() && this.m_20202_() == null;
    }

    @Override
    public boolean getIsAdult() {
        return (Boolean)this.f_19804_.m_135370_(ADULT);
    }

    @Override
    public void setAdult(boolean flag) {
        this.f_19804_.m_135381_(ADULT, (Object)flag);
    }

    @Override
    public String getPetName() {
        return (String)this.f_19804_.m_135370_(NAME_STR);
    }

    @Override
    public void setPetName(String name) {
        this.f_19804_.m_135381_(NAME_STR, (Object)name);
    }

    @Override
    public int getMoCAge() {
        return (Integer)this.f_19804_.m_135370_(AGE);
    }

    @Override
    public void setMoCAge(int i) {
        this.f_19804_.m_135381_(AGE, (Object)i);
        if (this.getMoCAge() >= this.getMoCMaxAge()) {
            this.setAdult(true);
        }
    }

    @Override
    public boolean getIsTamed() {
        return false;
    }

    @Override
    public int getOwnerPetId() {
        return 0;
    }

    @Override
    public void setOwnerPetId(int petId) {
    }

    @Override
    public UUID getOwnerId() {
        return null;
    }

    public boolean getIsJumping() {
        return this.isEntityJumping;
    }

    public void setIsJumping(boolean flag) {
        this.isEntityJumping = flag;
    }

    @Override
    public boolean checkSpawningBiome() {
        return true;
    }

    protected LivingEntity getClosestEntityLiving(Entity entity, double d) {
        double closestDistSq = -1.0;
        LivingEntity closest = null;
        AABB box = this.m_20191_().m_82400_(d);
        List list = this.m_9236_().m_45933_((Entity)this, box);
        for (Entity candidate : list) {
            if (this.entitiesToIgnore(candidate)) continue;
            double distSq = candidate.m_20280_(entity);
            if (!(d < 0.0) && !(distSq < d * d) || closestDistSq != -1.0 && !(distSq < closestDistSq) || !((LivingEntity)candidate).m_142582_(entity)) continue;
            closestDistSq = distSq;
            closest = (LivingEntity)candidate;
        }
        return closest;
    }

    public LivingEntity getClosestTarget(Entity entity, double d) {
        double closestDistSq = -1.0;
        LivingEntity closest = null;
        AABB box = this.m_20191_().m_82400_(d);
        List list = this.m_9236_().m_45933_((Entity)this, box);
        for (Entity candidate : list) {
            if (!(candidate instanceof LivingEntity) || candidate == entity || candidate == entity.m_20202_() || candidate instanceof Player || candidate instanceof Monster || this.m_20206_() <= candidate.m_20206_() || this.m_20205_() <= candidate.m_20205_()) continue;
            double distSq = candidate.m_20280_(entity);
            if (!(d < 0.0) && !(distSq < d * d) || closestDistSq != -1.0 && !(distSq < closestDistSq) || !((LivingEntity)candidate).m_142582_(entity)) continue;
            closestDistSq = distSq;
            closest = (LivingEntity)candidate;
        }
        return closest;
    }

    public boolean entitiesToIgnore(Entity entity) {
        return !(entity instanceof Mob) || entity instanceof Monster || entity instanceof MoCEntityKittyBed || entity instanceof MoCEntityLitterBox || this.getIsTamed() && entity instanceof IMoCEntity && ((IMoCEntity)entity).getIsTamed() || entity instanceof Wolf && !MoCreatures.proxy.attackWolves || entity instanceof MoCEntityHorse && !MoCreatures.proxy.attackHorses || entity.m_20205_() >= this.m_20205_() || entity.m_20206_() >= this.m_20206_() || entity instanceof MoCEntityEgg || entity instanceof IMoCEntity && !MoCreatures.proxy.enableHunters;
    }

    protected LivingEntity getBoogey(double d) {
        LivingEntity found = null;
        AABB box = this.m_20191_().m_82377_(d, 4.0, d);
        List list = this.m_9236_().m_45933_((Entity)this, box);
        for (Entity candidate : list) {
            if (!this.entitiesToInclude(candidate)) continue;
            found = (LivingEntity)candidate;
            break;
        }
        return found;
    }

    public boolean entitiesToInclude(Entity entity) {
        return entity.getClass() != this.getClass() && entity instanceof LivingEntity && ((double)entity.m_20205_() >= 0.5 || (double)entity.m_20206_() >= 0.5);
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            if (this.rideableEntity() && this.m_20160_()) {
                this.riding();
            }
            if (this.isMovementCeased()) {
                this.m_21573_().m_26573_();
            }
            if (this.getMoCAge() == 0) {
                this.setMoCAge(this.getMoCMaxAge() - 10);
            }
            if (!this.getIsAdult() && this.f_19796_.m_188503_(300) == 0 && this.getMoCAge() <= this.getMoCMaxAge()) {
                this.setMoCAge(this.getMoCAge() + 1);
                if (this.getMoCAge() >= this.getMoCMaxAge()) {
                    this.setAdult(true);
                }
            }
            if (MoCreatures.proxy.enableHunters && this.isReadyToHunt() && !this.getIsHunting() && this.f_19796_.m_188503_(500) == 0) {
                this.setIsHunting(true);
            } else if (!this.getIsHunting() && this.isReadyToFollowOwnerPlayer() && !this.getIsFollowingOwnerPlayer() && this.f_19796_.m_188503_(60) == 0) {
                this.setIsFollowingOwnerPlayer(true);
            }
            if (this.getIsHunting() && ++this.huntingCounter > 50) {
                this.setIsHunting(false);
            }
            if (this.getIsFollowingOwnerPlayer() && ++this.followPlayerCounter > 50) {
                this.setIsFollowingOwnerPlayer(false);
            }
        }
        if (this.m_20069_() && this.isAmphibian() && (this.f_19796_.m_188503_(500) == 0 || !this.randomAttributesUpdated)) {
            this.setNewDivingDepth();
            this.randomAttributesUpdated = true;
        }
        if (this.canRidePlayer() && this.m_20159_()) {
            MoCTools.dismountSneakingPlayer((Mob)this);
        }
        super.m_8119_();
    }

    public int getMoCMaxAge() {
        return 100;
    }

    @Override
    public boolean isNotScared() {
        return false;
    }

    public boolean swimmerEntity() {
        return false;
    }

    public boolean m_6069_() {
        return this.m_204029_(FluidTags.f_13131_);
    }

    public void dropMyStuff() {
    }

    protected boolean isMyHealFood(ItemStack itemstack) {
        return false;
    }

    public boolean m_6040_() {
        return this.isAmphibian();
    }

    public ItemEntity getClosestItem(Entity entity, double d, Ingredient ... items) {
        double closestDistSq = -1.0;
        ItemEntity found = null;
        AABB box = this.m_20191_().m_82400_(d);
        List list = this.m_9236_().m_45933_((Entity)this, box);
        for (Entity cand : list) {
            if (!(cand instanceof ItemEntity)) continue;
            ItemEntity itemEnt = (ItemEntity)cand;
            if (items.length > 0 && Arrays.stream(items).noneMatch(ing -> ing.test(itemEnt.m_32055_()))) continue;
            double distSq = itemEnt.m_20280_(entity);
            if (!(d < 0.0) && !(distSq < d * d) || closestDistSq != -1.0 && !(distSq < closestDistSq)) continue;
            closestDistSq = distSq;
            found = itemEnt;
        }
        return found;
    }

    public ItemEntity getClosestEntityItem(Entity entity, double d) {
        double closestDistSq = -1.0;
        ItemEntity found = null;
        AABB box = this.m_20191_().m_82400_(d);
        List list = this.m_9236_().m_45933_((Entity)this, box);
        for (Entity cand : list) {
            if (!(cand instanceof ItemEntity)) continue;
            ItemEntity itemEnt = (ItemEntity)cand;
            double distSq = itemEnt.m_20280_(entity);
            if (!(d < 0.0) && !(distSq < d * d) || closestDistSq != -1.0 && !(distSq < closestDistSq)) continue;
            closestDistSq = distSq;
            found = itemEnt;
        }
        return found;
    }

    public void faceLocation(double x, double y, double z, float maxTurn) {
        double dx = x - this.m_20185_();
        double dz = z - this.m_20189_();
        double dy = y - (this.m_20186_() + (double)this.m_20192_());
        double horiz = Math.sqrt(dx * dx + dz * dz);
        float targetYaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        float targetPitch = (float)(-(Mth.m_14136_((double)dy, (double)horiz) * 57.29577951308232));
        this.m_146922_(Mth.m_14148_((float)this.m_146908_(), (float)targetYaw, (float)maxTurn));
        this.m_146926_(Mth.m_14148_((float)this.m_146909_(), (float)targetPitch, (float)maxTurn));
        this.f_20885_ = this.m_146908_();
        this.f_20883_ = this.m_146908_();
    }

    public void setPathToEntity(Entity entity, float speed) {
        PathNavigation nav = this.m_21573_();
        Path path = nav.m_6570_(entity, 0);
        if (path != null) {
            nav.m_26536_(path, 1.0);
        }
    }

    public void riding() {
        if (this.m_20160_() && this.m_6688_() instanceof Player) {
            Player rider = (Player)this.m_6688_();
            List list = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82377_(1.0, 0.0, 1.0));
            for (Entity ent : list) {
                float dist;
                if (ent.m_213877_()) continue;
                ent.m_6123_(rider);
                if (!(ent instanceof Monster) || !((dist = this.m_20270_(ent)) < 2.0f) || this.f_19796_.m_188503_(10) != 0) continue;
                ent.m_6469_(ent.m_9236_().m_269111_().m_269333_((LivingEntity)ent), (float)((Monster)ent).m_21133_(Attributes.f_22281_));
            }
            if (rider.m_36341_()) {
                this.makeEntityDive();
            }
        }
    }

    protected void getPathOrWalkableBlock(Entity entity, float f) {
        PathNavigation nav = this.m_21573_();
        Path path = nav.m_7864_(entity.m_20183_(), 0);
        if (path == null && f > 8.0f) {
            int cx = Mth.m_14107_((double)entity.m_20185_()) - 2;
            int cz = Mth.m_14107_((double)entity.m_20189_()) - 2;
            int cy = Mth.m_14107_((double)entity.m_20191_().f_82289_);
            for (int dx = 0; dx <= 4; ++dx) {
                for (int dz = 0; dz <= 4; ++dz) {
                    BlockPos pos = new BlockPos(cx + dx, cy - 1, cz + dz);
                    BlockState bsBelow = this.m_9236_().m_8055_(pos);
                    BlockState bsAt = this.m_9236_().m_8055_(pos.m_7494_());
                    BlockState bsAbove = this.m_9236_().m_8055_(pos.m_6630_(2));
                    if (dx >= 1 && dz >= 1 && dx <= 3 && dz <= 3 || !bsBelow.m_60838_((BlockGetter)this.m_9236_(), pos) || bsAt.m_60838_((BlockGetter)this.m_9236_(), pos.m_7494_()) || bsAbove.m_60838_((BlockGetter)this.m_9236_(), pos.m_6630_(2))) continue;
                    this.m_7678_((double)(cx + dx) + 0.5, cy, (double)(cz + dz) + 0.5, this.m_146908_(), this.m_146909_());
                    return;
                }
            }
        } else {
            nav.m_26536_(path, 1.0);
        }
    }

    public static boolean getCanSpawnHere(EntityType<MoCEntityAnimal> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, Random randomIn) {
        boolean willSpawn;
        BlockState blockBelow = world.m_8055_(pos.m_7495_());
        boolean bl = willSpawn = world.m_45517_(LightLayer.SKY, pos) > 8 && blockBelow.m_60643_((BlockGetter)world, pos, type);
        if (MoCreatures.proxy.debug && willSpawn) {
            MoCreatures.LOGGER.info("Animal: " + type.m_20676_() + " at: " + pos + " State: " + world.m_8055_(pos) + " biome: " + MoCTools.biomeName((Level)world, pos));
        }
        return willSpawn;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        CompoundTag data = MoCTools.getEntityData((Entity)this);
        data.m_128379_("Adult", this.getIsAdult());
        data.m_128405_("Edad", this.getMoCAge());
        data.m_128359_("Name", this.getPetName());
        data.m_128405_("TypeInt", this.getTypeMoC());
        compound.m_128365_("MoCData", (Tag)data);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("MoCData", 10)) {
            CompoundTag data = compound.m_128469_("MoCData");
            this.setAdult(data.m_128471_("Adult"));
            this.setMoCAge(data.m_128451_("Edad"));
            this.setPetName(data.m_128461_("Name"));
            this.setTypeMoC(data.m_128451_("TypeInt"));
        }
    }

    public void m_7023_(Vec3 vec) {
        if (this.m_20160_()) {
            LivingEntity passenger = this.m_6688_();
            if (passenger instanceof LivingEntity) {
                this.moveWithRider(vec, passenger);
            }
            return;
        }
        if (this.isAmphibian() && this.m_20069_() || this.isFlyer() && this.getIsFlying()) {
            this.m_19920_(0.1f, vec);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82542_(0.9, 0.9, 0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82492_(0.0, 0.005, 0.0));
            }
        } else {
            super.m_7023_(vec);
        }
    }

    public void moveWithRider(Vec3 vec, LivingEntity passenger) {
        if (!this.m_20160_()) {
            return;
        }
        if (!this.getIsTamed()) {
            this.moveEntityWithRiderUntamed(vec, passenger);
            return;
        }
        boolean flySelfPropelled = this.selfPropelledFlyer() && this.isOnAir();
        boolean flyingMount = this.isFlyer() && this.m_20160_() && this.getIsTamed() && !this.m_20096_() && this.isOnAir();
        this.m_146922_(passenger.m_146908_());
        this.f_19859_ = this.m_146908_();
        this.m_146926_(passenger.m_146909_() * 0.5f);
        this.f_20885_ = this.f_20883_ = this.m_146908_();
        if (!this.selfPropelledFlyer() || this.selfPropelledFlyer() && !this.isOnAir()) {
            vec = new Vec3((double)(passenger.f_20900_ * 0.5f) * this.getCustomSpeed(), vec.f_82480_, (double)passenger.f_20902_ * this.getCustomSpeed());
        }
        if (this.jumpPending && this.isFlyer()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, this.flyerThrust(), 0.0));
            this.jumpPending = false;
            if (flySelfPropelled) {
                float velX = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                float velZ = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                this.m_20256_(this.m_20184_().m_82520_((double)(-0.5f * velX), 0.0, (double)(0.5f * velZ)));
            }
        } else if (this.jumpPending && !this.getIsJumping()) {
            this.m_20334_(this.m_20184_().f_82479_, this.getCustomJump() * 2.0, this.m_20184_().f_82481_);
            this.setIsJumping(true);
            this.jumpPending = false;
        }
        if (this.divePending) {
            this.divePending = false;
            this.m_20256_(this.m_20184_().m_82492_(0.0, 0.3, 0.0));
        }
        if (flyingMount) {
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_19920_(this.flyerFriction() / 10.0f, vec);
            this.m_20256_(this.m_20184_().m_82542_((double)this.flyerFriction(), this.myFallSpeed(), (double)this.flyerFriction()).m_82492_(0.0, 0.055, 0.0));
        } else {
            this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
            super.m_7023_(vec);
        }
        if (this.m_20096_()) {
            this.setIsJumping(false);
            this.divePending = false;
            this.jumpPending = false;
        }
    }

    public void moveEntityWithRiderUntamed(Vec3 vec, LivingEntity passenger) {
        if (!this.m_9236_().f_46443_) {
            if (this.f_19796_.m_188503_(10) == 0) {
                this.m_20334_(this.f_19796_.m_188583_() / 30.0, this.m_20184_().f_82480_, this.f_19796_.m_188583_() / 10.0);
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (this.f_19796_.m_188503_(50) == 0) {
                passenger.m_8127_();
                this.m_6135_();
            }
            if (this instanceof IMoCTameable && passenger instanceof Player) {
                int chance = this.getMaxTemper() - this.getTemper();
                if (chance <= 0) {
                    chance = 1;
                }
                if (this.f_19796_.m_188503_(chance * 8) == 0) {
                    MoCTools.tameWithName((Player)passenger, (IMoCTameable)((Object)this));
                }
            }
        }
    }

    @Override
    public int maxFlyingHeight() {
        return 5;
    }

    protected double myFallSpeed() {
        return 0.6;
    }

    protected double flyerThrust() {
        return 0.3;
    }

    protected float flyerFriction() {
        return 0.91f;
    }

    protected boolean selfPropelledFlyer() {
        return false;
    }

    @Override
    public void makeEntityJump() {
        this.jumpPending = true;
    }

    @Override
    public boolean isFlyer() {
        return false;
    }

    public int getTemper() {
        return this.temper;
    }

    public void setTemper(int i) {
        this.temper = i;
    }

    public int getMaxTemper() {
        return 100;
    }

    public double getCustomSpeed() {
        return 0.6;
    }

    public double getCustomJump() {
        return 0.4;
    }

    protected SoundEvent getAngrySound() {
        return null;
    }

    public boolean rideableEntity() {
        return false;
    }

    @Override
    public int nameYOffset() {
        return -80;
    }

    protected Entity findPlayerToAttack() {
        return null;
    }

    public boolean isFlyingAlone() {
        return false;
    }

    @Override
    public void performAnimation(int attackType) {
    }

    public boolean isMyFavoriteFood(ItemStack stack) {
        return false;
    }

    @Override
    public void makeEntityDive() {
        this.divePending = true;
    }

    public boolean isOnAir() {
        BlockPos pos1 = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)(this.m_20186_() - 0.2)), Mth.m_14107_((double)this.m_20189_()));
        BlockPos pos2 = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)(this.m_20186_() - 1.2)), Mth.m_14107_((double)this.m_20189_()));
        return this.m_9236_().m_46859_(pos1) && this.m_9236_().m_46859_(pos2);
    }

    @Override
    public float getSizeFactor() {
        return 1.0f;
    }

    @Override
    public float getAdjustedYOffset() {
        return 0.0f;
    }

    protected boolean canBeTrappedInNet() {
        return this instanceof IMoCTameable && this.getIsTamed();
    }

    public void m_6667_(DamageSource source) {
        if (!this.m_9236_().f_46443_) {
            this.dropMyStuff();
        }
        super.m_6667_(source);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isNotScared()) {
            LivingEntity tempTarget = this.m_5448_();
            boolean flag = super.m_6469_(source, amount);
            this.m_6710_(tempTarget);
            return flag;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = entityIn.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public boolean isReadyToHunt() {
        return false;
    }

    public boolean isReadyToFollowOwnerPlayer() {
        return false;
    }

    public boolean m_6573_(Player player) {
        if (!this.m_9236_().f_46443_ && !MoCTools.isThisPlayerAnOP(player) && this.getIsTamed() && !player.m_20148_().equals(this.getOwnerId())) {
            return false;
        }
        return super.m_6573_(player);
    }

    @Override
    public boolean getIsSitting() {
        return false;
    }

    @Override
    public boolean isMovementCeased() {
        return this.getIsSitting() || this.m_20160_();
    }

    public boolean getIsHunting() {
        return this.huntingCounter != 0;
    }

    public void setIsHunting(boolean flag) {
        this.huntingCounter = flag ? this.f_19796_.m_188503_(30) + 1 : 0;
    }

    public boolean getIsFollowingOwnerPlayer() {
        return this.followPlayerCounter != 0;
    }

    public void setIsFollowingOwnerPlayer(boolean flag) {
        this.followPlayerCounter = flag ? this.f_19796_.m_188503_(30) + 1 : 0;
    }

    @Override
    public boolean shouldAttackPlayers() {
        return !this.getIsTamed() && this.m_9236_().m_46791_() != Difficulty.PEACEFUL;
    }

    public boolean m_214076_(ServerLevel world, LivingEntity entityLivingIn) {
        if (!(entityLivingIn instanceof Player)) {
            MoCTools.destroyDrops((Entity)this, 3.0);
        }
        return true;
    }

    public PathNavigation m_21573_() {
        if (this.m_20069_() && this.isAmphibian()) {
            return this.navigatorWater;
        }
        if (this.isFlyer() && this.getIsFlying()) {
            return this.navigatorFlyer;
        }
        return super.m_21573_();
    }

    public boolean isAmphibian() {
        return false;
    }

    @Override
    public boolean isDiving() {
        return false;
    }

    @Override
    public double getDivingDepth() {
        return this.divingDepth;
    }

    protected void setNewDivingDepth(double setDepth) {
        if (setDepth != 0.0) {
            if (setDepth > this.maxDivingDepth()) {
                setDepth = this.maxDivingDepth();
            }
            if (setDepth < this.minDivingDepth()) {
                setDepth = this.minDivingDepth();
            }
            this.divingDepth = setDepth;
        } else {
            this.divingDepth = this.f_19796_.m_188500_() * (this.maxDivingDepth() - this.minDivingDepth()) + this.minDivingDepth();
        }
    }

    protected void setNewDivingDepth() {
        this.setNewDivingDepth(0.0);
    }

    protected double minDivingDepth() {
        return 0.2;
    }

    protected double maxDivingDepth() {
        return 1.0;
    }

    public void m_6135_() {
        super.m_6135_();
    }

    @Override
    public int minFlyingHeight() {
        return 1;
    }

    @Override
    public boolean getIsFlying() {
        return false;
    }

    @Nullable
    public LivingEntity m_6688_() {
        if (this.m_20197_().isEmpty()) {
            return null;
        }
        Entity passenger = (Entity)this.m_20197_().get(0);
        return passenger instanceof LivingEntity ? (LivingEntity)passenger : null;
    }

    public boolean canRidePlayer() {
        return false;
    }

    @Override
    public boolean getIsGhost() {
        return false;
    }

    public void m_21463_(Entity leashHolder, boolean sendAttachNotification) {
        if (this.getIsTamed() && leashHolder instanceof Player) {
            Player player = (Player)leashHolder;
            if (MoCreatures.proxy.enableOwnership && this.getOwnerId() != null && !player.m_20148_().equals(this.getOwnerId()) && !MoCTools.isThisPlayerAnOP(player)) {
                return;
            }
        }
        super.m_21463_(leashHolder, sendAttachNotification);
    }

    public boolean m_5830_() {
        return !this.m_20159_() && super.m_5830_();
    }

    @Override
    public void forceEntityJump() {
        this.m_6135_();
    }

    public boolean getIsRideable() {
        return false;
    }

    public void setRideable(boolean flag) {
    }

    public int getArmorType() {
        return 0;
    }

    public void dropArmor() {
    }

    @Override
    public float pitchRotationOffset() {
        return 0.0f;
    }

    @Override
    public float rollRotationOffset() {
        return 0.0f;
    }

    @Override
    public float yawRotationOffset() {
        return 0.0f;
    }

    @Override
    public float getAdjustedZOffset() {
        return 0.0f;
    }

    @Override
    public float getAdjustedXOffset() {
        return 0.0f;
    }

    @Override
    public void setArmorType(int i) {
    }

    @Override
    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getModelTexture(this.texture);
    }

    @Override
    public boolean canAttackTarget(LivingEntity entity) {
        return this.m_20206_() >= entity.m_20206_() && this.m_20205_() >= entity.m_20205_();
    }

    public boolean m_5545_(LevelAccessor world, MobSpawnType reason) {
        if (reason == MobSpawnType.SPAWN_EGG) {
            return true;
        }
        if (world.m_6425_(this.m_20183_()).m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        return super.m_5545_(world, reason);
    }
}

