/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public abstract class MoCEntityAquatic
extends WaterAnimal
implements IMoCEntity {
    private static final EntityDataAccessor<Boolean> ADULT = SynchedEntityData.m_135353_(MoCEntityAquatic.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(MoCEntityAquatic.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(MoCEntityAquatic.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> NAME_STR = SynchedEntityData.m_135353_(MoCEntityAquatic.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected boolean fishHooked;
    protected boolean divePending;
    protected boolean jumpPending;
    protected boolean isEntityJumping;
    protected int outOfWater = 0;
    protected boolean riderIsDisconnecting;
    protected float moveSpeed;
    protected String texture;
    protected PathNavigation navigatorWater;
    protected int temper;
    private boolean diving;
    private int divingCount;
    private int mountCount;
    private boolean updateDivingDepth = false;
    private double divingDepth;

    public MoCEntityAquatic(EntityType<? extends MoCEntityAquatic> type, Level level) {
        super(type, level);
        this.setTemper(50);
        this.setNewDivingDepth();
        this.riderIsDisconnecting = false;
        this.texture = "blank.jpg";
        this.navigatorWater = new WaterBoundPathNavigation((Mob)this, level);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 5, 0.01f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.7).m_22268_(Attributes.f_22276_, 6.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ADULT, (Object)false);
        this.f_19804_.m_135372_(TYPE, (Object)0);
        this.f_19804_.m_135372_(AGE, (Object)45);
        this.f_19804_.m_135372_(NAME_STR, (Object)"");
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component m_7755_() {
        String entityKey = this.m_6095_().m_20675_();
        if (!MoCreatures.proxy.verboseEntityNames || entityKey == null) {
            return super.m_7755_();
        }
        String translationKey = "entity." + entityKey + ".verbose.name";
        String localized = I18n.m_118938_((String)translationKey, (Object[])new Object[0]);
        if (!localized.equals(translationKey)) {
            return Component.m_237115_((String)translationKey);
        }
        return super.m_7755_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.selectType();
        return super.m_6518_(world, difficulty, reason, spawnData, dataTag);
    }

    @Override
    public void selectType() {
        this.setTypeMoC(1);
    }

    @Override
    public int getTypeMoC() {
        return (Integer)this.f_19804_.m_135370_(TYPE);
    }

    @Override
    public void setTypeMoC(int i) {
        this.f_19804_.m_135381_(TYPE, (Object)i);
    }

    @Override
    public int getOwnerPetId() {
        return -1;
    }

    @Override
    public void setOwnerPetId(int i) {
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        return null;
    }

    @Override
    public boolean getIsTamed() {
        return false;
    }

    @Override
    public boolean getIsAdult() {
        return (Boolean)this.f_19804_.m_135370_(ADULT);
    }

    @Override
    public void setAdult(boolean flag) {
        this.f_19804_.m_135381_(ADULT, (Object)flag);
    }

    @Override
    public String getPetName() {
        return (String)this.f_19804_.m_135370_(NAME_STR);
    }

    @Override
    public void setPetName(String name) {
        this.f_19804_.m_135381_(NAME_STR, (Object)name);
    }

    @Override
    public int getMoCAge() {
        return (Integer)this.f_19804_.m_135370_(AGE);
    }

    @Override
    public void setMoCAge(int i) {
        this.f_19804_.m_135381_(AGE, (Object)i);
        if (this.getMoCAge() >= this.getMaxAge()) {
            this.setAdult(true);
        }
    }

    public int getTemper() {
        return this.temper;
    }

    public void setTemper(int i) {
        this.temper = i;
    }

    public int getMaxTemper() {
        return 100;
    }

    public float clampAngle(float current, float target, float maxDelta) {
        float delta;
        for (delta = target - current; delta < -180.0f; delta += 360.0f) {
        }
        while (delta >= 180.0f) {
            delta -= 360.0f;
        }
        if (delta > maxDelta) {
            delta = maxDelta;
        }
        if (delta < -maxDelta) {
            delta = -maxDelta;
        }
        return current + delta;
    }

    public void faceItem(double x, double y, double z, float maxAngleDiff) {
        double dx = x - this.m_20185_();
        double dy = z - this.m_20189_();
        double dz = y - this.m_20186_();
        double horizontalDist = Math.sqrt(dx * dx + dy * dy);
        float yawTarget = (float)(Math.atan2(dy, dx) * 57.29577951308232) - 90.0f;
        float pitchTarget = (float)(Math.atan2(dz, horizontalDist) * 57.29577951308232);
        this.m_146926_(-this.clampAngle(this.m_146909_(), pitchTarget, maxAngleDiff));
        this.m_146922_(this.clampAngle(this.m_146908_(), yawTarget, maxAngleDiff));
    }

    public boolean m_5545_(LevelAccessor world, MobSpawnType reason) {
        if (reason == MobSpawnType.SPAWN_EGG) {
            return true;
        }
        BlockPos pos = this.m_20183_();
        return world.m_6425_(pos).m_205070_(FluidTags.f_13131_);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public ItemEntity getClosestFish(Entity seeker, double radius) {
        double closestSq = -1.0;
        ItemEntity closest = null;
        AABB searchBox = this.m_20191_().m_82400_(radius);
        List itemsInRange = this.m_9236_().m_6443_(ItemEntity.class, searchBox, itemEntity -> {
            ItemStack stack = itemEntity.m_32055_();
            return stack.m_204117_(ItemTags.f_13156_) && itemEntity.isInFluidType((FluidType)ForgeMod.WATER_TYPE.get());
        });
        for (ItemEntity fishEntity : itemsInRange) {
            double sqDist = fishEntity.m_20280_(seeker);
            if (!(radius < 0.0) && !(sqDist < radius * radius) || closest != null && !(sqDist < closestSq)) continue;
            closestSq = sqDist;
            closest = fishEntity;
        }
        return closest;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public double getCustomJump() {
        return 0.4;
    }

    public boolean getIsJumping() {
        return this.isEntityJumping;
    }

    public void setIsJumping(boolean flag) {
        this.isEntityJumping = flag;
    }

    public void m_6135_() {
        this.jumpPending = true;
    }

    protected void moveToNextEntity(Entity target) {
        if (target != null) {
            int i = Mth.m_14107_((double)target.m_20185_());
            int j = Mth.m_14107_((double)target.m_20186_());
            int k = Mth.m_14107_((double)target.m_20189_());
            this.faceItem(i, j, k, 30.0f);
            Vec3 motion = this.m_20184_();
            if (this.m_20185_() < (double)i) {
                dx = target.m_20185_() - this.m_20185_();
                if (dx > 0.5) {
                    motion = motion.m_82520_(0.05, 0.0, 0.0);
                }
            } else {
                dx = this.m_20185_() - target.m_20185_();
                if (dx > 0.5) {
                    motion = motion.m_82492_(0.05, 0.0, 0.0);
                }
            }
            if (this.m_20189_() < (double)k) {
                dz = target.m_20189_() - this.m_20189_();
                if (dz > 0.5) {
                    motion = motion.m_82520_(0.0, 0.0, 0.05);
                }
            } else {
                dz = this.m_20189_() - target.m_20189_();
                if (dz > 0.5) {
                    motion = motion.m_82492_(0.0, 0.0, 0.05);
                }
            }
            this.m_20256_(motion);
        }
    }

    public double getCustomSpeed() {
        return 1.5;
    }

    @Override
    public boolean isDiving() {
        return this.diving;
    }

    @Override
    public void makeEntityJump() {
    }

    public void riding() {
        if (this.m_20160_() && this.m_6688_() instanceof Player) {
            Player rider = (Player)this.m_6688_();
            List list = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82377_(1.0, 0.0, 1.0));
            for (Entity ent : list) {
                float dist;
                if (ent.m_213877_()) continue;
                ent.m_6123_(rider);
                if (!(ent instanceof Monster) || !((dist = this.m_20270_(ent)) < 2.0f) || this.f_19796_.m_188503_(10) != 0) continue;
                ent.m_6469_(ent.m_9236_().m_269111_().m_269333_((LivingEntity)ent), (float)((Monster)ent).m_21133_(Attributes.f_22281_));
            }
            if (rider.m_36341_()) {
                this.makeEntityDive();
            }
        }
    }

    public void m_8107_() {
        if (!this.m_9236_().f_46443_) {
            if (this.m_20160_() && this.m_6688_() instanceof Player) {
                this.riding();
                this.mountCount = 1;
            }
            if (this.mountCount > 0 && ++this.mountCount > 50) {
                this.mountCount = 0;
            }
            if (this.getMoCAge() == 0) {
                this.setMoCAge(this.getMaxAge() - 10);
            }
            if (!this.getIsAdult() && this.f_19796_.m_188503_(300) == 0) {
                this.setMoCAge(this.getMoCAge() + 1);
                if (this.getMoCAge() >= this.getMaxAge()) {
                    this.setAdult(true);
                }
            }
            if (this.m_20069_() && this.f_19797_ % 2 == 0) {
                this.m_21573_().m_7638_();
            }
            if (!this.m_21573_().m_26571_()) {
                if (this.f_19797_ % 3 == 0 && !this.updateDivingDepth) {
                    float targetDepth = MoCTools.distanceToSurface(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_(), this.m_9236_());
                    this.setNewDivingDepth(targetDepth);
                    this.updateDivingDepth = true;
                } else if (this.f_19797_ % 10 == 0) {
                    this.updateDivingDepth = false;
                }
            } else {
                this.updateDivingDepth = false;
            }
            if (this.isMovementCeased() || this.f_19796_.m_188503_(200) == 0) {
                this.m_21573_().m_26573_();
            }
            if (this.isFisheable() && !this.fishHooked && this.f_19796_.m_188503_(30) == 0) {
                this.getFished();
            }
            if (this.fishHooked && this.f_19796_.m_188503_(200) == 0) {
                this.fishHooked = false;
                List hooks = this.m_9236_().m_6443_(FishingHook.class, this.m_20191_().m_82400_(2.0), hook -> hook.m_37170_() == this);
                for (FishingHook fishingHook : hooks) {
                }
                hooks.clear();
            }
        }
        this.moveSpeed = 0.7f;
        if (this.m_6069_()) {
            this.outOfWater = 0;
            this.m_20301_(800);
        } else {
            ++this.outOfWater;
            Vec3 motion = this.m_20184_().m_82492_(0.0, 0.1, 0.0);
            this.m_20256_(motion);
            if (this.m_20096_() && this.outOfWater % 20 == 0) {
                Vec3 randomMotion = new Vec3((this.f_19796_.m_188500_() - 0.5) * 0.5, 0.4, (this.f_19796_.m_188500_() - 0.5) * 0.5);
                this.m_20256_(randomMotion);
                this.m_6853_(false);
            }
            if (this.outOfWater > 20) {
                this.m_21573_().m_26573_();
            }
            if (this.outOfWater > 300 && this.outOfWater % 40 == 0) {
                Vec3 randMotion = this.m_20184_().m_82520_(this.f_19796_.m_188500_() * 0.2 - 0.1, 0.3, this.f_19796_.m_188500_() * 0.2 - 0.1);
                this.m_20256_(randMotion);
                this.m_6469_(this.m_269291_().m_269063_(), 1.0f);
            }
        }
        if (!this.diving) {
            if (!this.m_20160_() && this.m_5448_() == null && !this.m_21573_().m_26571_() && this.f_19796_.m_188503_(500) == 0) {
                this.diving = true;
            }
        } else {
            ++this.divingCount;
            if (this.divingCount > 100 || this.m_20160_()) {
                this.diving = false;
                this.divingCount = 0;
            }
        }
        super.m_8107_();
    }

    public boolean m_6069_() {
        return this.m_204029_(FluidTags.f_13131_);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Adult", this.getIsAdult());
        compound.m_128405_("Edad", this.getMoCAge());
        compound.m_128359_("Name", this.getPetName());
        compound.m_128405_("TypeInt", this.getTypeMoC());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setAdult(compound.m_128471_("Adult"));
        this.setMoCAge(compound.m_128451_("Edad"));
        this.setPetName(compound.m_128461_("Name"));
        this.setTypeMoC(compound.m_128451_("TypeInt"));
    }

    public void setTypeInt(int i) {
        this.setTypeMoC(i);
        this.selectType();
    }

    @Override
    public void performAnimation(int attackType) {
    }

    public void m_6043_() {
        Player player = this.m_9236_().m_45930_((Entity)this, -1.0);
        if (player != null) {
            int instantDist;
            int j;
            double d0 = player.m_20280_((Entity)this);
            if (d0 > (double)(j = (instantDist = this.m_6095_().m_20674_().m_21611_()) * instantDist) && this.m_6785_(d0)) {
                this.m_6123_(player);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            int randomDist = this.m_6095_().m_20674_().m_21611_();
            int l = randomDist * randomDist;
            if (this.f_19797_ > 1800 && this.f_19796_.m_188503_(800) == 0 && d0 > (double)l && this.m_6785_(d0)) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            } else if (d0 < (double)l) {
                this.f_20891_ = 0;
            }
        }
    }

    @Override
    public int nameYOffset() {
        return 0;
    }

    @Override
    public boolean renderName() {
        return MoCreatures.proxy.getDisplayPetName() && !this.getPetName().isEmpty() && !this.m_20160_();
    }

    @Override
    public void makeEntityDive() {
        this.divePending = true;
    }

    @Override
    public float getSizeFactor() {
        return 1.0f;
    }

    @Override
    public float getAdjustedYOffset() {
        return 0.0f;
    }

    public static boolean getCanSpawnHere(EntityType<MoCEntityAquatic> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        if (reason == MobSpawnType.SPAWN_EGG) {
            return true;
        }
        boolean isInWater = world.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        boolean willSpawn = isInWater && pos.m_123342_() >= world.m_5736_() - 12;
        boolean debug = MoCreatures.proxy.debug;
        if (debug) {
            MoCreatures.LOGGER.info("Aquatic: {} at {} State: {} biome: {} isInWater: {}", (Object)type.m_20676_(), (Object)pos, (Object)world.m_8055_(pos), (Object)MoCTools.biomeName((Level)world, pos), (Object)isInWater);
        }
        return willSpawn;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.usesNewAI()) {
            return super.m_6469_(source, amount);
        }
        if (this.isNotScared()) {
            LivingEntity oldTarget = this.m_5448_();
            this.m_6710_(oldTarget);
            return super.m_6469_(source, amount);
        }
        return super.m_6469_(source, amount);
    }

    protected boolean canBeTrappedInNet() {
        return this instanceof IMoCTameable && this.getIsTamed();
    }

    protected void dropMyStuff() {
    }

    protected boolean isMyHealFood(ItemStack stack) {
        return false;
    }

    @Override
    public void setArmorType(int i) {
    }

    @Override
    public float pitchRotationOffset() {
        return 0.0f;
    }

    @Override
    public float rollRotationOffset() {
        return 0.0f;
    }

    private void getFished() {
        FishingHook fishHook;
        Player nearest = this.m_9236_().m_45930_((Entity)this, 18.0);
        if (nearest != null && (fishHook = nearest.f_36083_) != null && fishHook.m_37170_() == null) {
            float dist = fishHook.m_20270_((Entity)this);
            if (dist > 1.0f) {
                MoCTools.setPathToEntity((Mob)this, (Entity)fishHook, dist);
            } else {
                this.fishHooked = true;
            }
        }
    }

    protected boolean isFisheable() {
        return false;
    }

    @Override
    public float getAdjustedZOffset() {
        return 0.0f;
    }

    @Override
    public float getAdjustedXOffset() {
        return 0.0f;
    }

    @Override
    public boolean isNotScared() {
        return false;
    }

    @Override
    public boolean canAttackTarget(LivingEntity entity) {
        return false;
    }

    @Override
    public boolean getIsSitting() {
        return false;
    }

    @Override
    public boolean shouldAttackPlayers() {
        return !this.getIsTamed() && this.m_9236_().m_46791_() != Difficulty.PEACEFUL;
    }

    public void m_7023_(Vec3 movementInput) {
        LivingEntity passenger;
        if (this.m_20160_() && (passenger = this.m_6688_()) instanceof LivingEntity) {
            this.moveWithRider(movementInput, passenger);
            return;
        }
        if (this.m_20069_()) {
            this.m_19920_(0.1f, movementInput);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)0.9f));
            if (this.m_5448_() == null && this.m_21573_().m_26571_()) {
                this.m_20256_(this.m_20184_().m_82492_(0.0, 0.005, 0.0));
            }
            this.m_267651_(true);
        } else {
            super.m_7023_(movementInput);
        }
    }

    public void moveWithRider(Vec3 movementInput, LivingEntity passenger) {
        if (!this.m_20160_() || passenger == null) {
            return;
        }
        if (!this.getIsTamed()) {
            this.moveEntityWithRiderUntamed(movementInput, passenger);
            return;
        }
        this.m_146922_(passenger.m_146908_());
        this.f_19859_ = this.m_146908_();
        this.m_146926_(passenger.m_146909_() * 0.5f);
        this.f_20885_ = this.f_20883_ = this.m_146908_();
        movementInput = new Vec3((double)(passenger.f_20900_ * 0.2f), movementInput.f_82480_, (double)(passenger.f_20902_ * 0.4f));
        if (this.jumpPending) {
            if (this.m_6069_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, this.getCustomJump(), 0.0));
            }
            this.jumpPending = false;
        }
        if (this.divePending) {
            this.divePending = false;
            this.m_20256_(this.m_20184_().m_82492_(0.0, 0.3, 0.0));
        }
        if (this.m_20184_().f_82480_ < 0.0 && this.m_6069_() && movementInput.f_82481_ == 0.0) {
            this.m_20334_(this.m_20184_().f_82479_, 0.0, this.m_20184_().f_82481_);
        }
        if (this.m_20069_()) {
            this.m_19920_(0.1f, movementInput);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.85));
        } else {
            this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
            super.m_7023_(movementInput);
        }
    }

    public void moveEntityWithRiderUntamed(Vec3 movementInput, LivingEntity passenger) {
        if (this.f_19796_.m_188503_(20) == 0) {
            double deltaX = this.f_19796_.m_188583_() / 80.0;
            double deltaZ = this.f_19796_.m_188583_() / 80.0;
            Vec3 currentMovement = this.m_20184_();
            this.m_20334_(currentMovement.f_82479_ + deltaX, currentMovement.f_82480_, currentMovement.f_82481_ + deltaZ);
            if (Math.abs(deltaX) > 0.001 || Math.abs(deltaZ) > 0.001) {
                float currentYaw = this.m_146908_();
                float targetYaw = (float)(Math.atan2(deltaZ, deltaX) * 57.29577951308232) - 90.0f;
                float newYaw = currentYaw + (targetYaw - currentYaw) * 0.1f;
                this.m_146922_(newYaw);
                this.f_19859_ = newYaw;
                this.f_20883_ = newYaw;
                this.f_20885_ = newYaw;
            }
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    public int m_8100_() {
        return 300;
    }

    protected void m_6229_(int air) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(air - 1);
            if (this.m_20146_() == -30) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 1.0f);
                Vec3 kick = this.m_20184_().m_82520_(this.f_19796_.m_188500_() / 10.0, 0.0, this.f_19796_.m_188500_() / 10.0);
                this.m_20256_(kick);
            }
        } else {
            this.m_20301_(300);
        }
    }

    protected boolean usesNewAI() {
        return false;
    }

    public PathNavigation m_21573_() {
        if (this.m_20069_()) {
            return this.navigatorWater;
        }
        return super.m_21573_();
    }

    @Override
    public double getDivingDepth() {
        return this.divingDepth;
    }

    protected void setNewDivingDepth(double setDepth) {
        if (setDepth != 0.0) {
            if (setDepth > this.maxDivingDepth()) {
                setDepth = this.maxDivingDepth();
            }
            if (setDepth < this.minDivingDepth()) {
                setDepth = this.minDivingDepth();
            }
            this.divingDepth = setDepth;
        } else {
            this.divingDepth = this.f_19796_.m_188500_() * (this.maxDivingDepth() - this.minDivingDepth()) + this.minDivingDepth();
        }
    }

    protected void setNewDivingDepth() {
        this.setNewDivingDepth(0.0);
    }

    protected double minDivingDepth() {
        return 0.2;
    }

    protected double maxDivingDepth() {
        return 3.0;
    }

    @Override
    public void forceEntityJump() {
        this.makeEntityJump();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float yawRotationOffset() {
        double wobble = 0.0;
        if (this.m_20184_().f_82479_ != 0.0 || this.m_20184_().f_82481_ != 0.0) {
            wobble = Math.sin((double)this.f_19797_ * 0.5) * 8.0;
        }
        return (float)wobble;
    }

    public int getMaxAge() {
        return 100;
    }

    public boolean m_7327_(Entity target) {
        if (!(target instanceof LivingEntity)) {
            return false;
        }
        if (!target.m_20069_()) {
            return false;
        }
        boolean flag = ((LivingEntity)target).m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
        if (flag) {
            this.m_19970_((LivingEntity)this, target);
        }
        return flag;
    }

    public void m_21463_(Entity entity, boolean sendAttachNotification) {
        if (this.getIsTamed() && entity instanceof Player) {
            Player player = (Player)entity;
            if (MoCreatures.proxy.enableOwnership && this.getOwnerId() != null && !player.m_20148_().equals(this.getOwnerId()) && !MoCTools.isThisPlayerAnOP(player)) {
                return;
            }
        }
        super.m_6573_((Player)entity);
    }

    public boolean m_6072_() {
        return !this.m_20160_();
    }

    @Nullable
    public LivingEntity m_6688_() {
        return this.m_20197_().isEmpty() ? null : ((Entity)this.m_20197_().get(0)).m_6688_();
    }

    @Override
    public boolean getIsGhost() {
        return false;
    }

    @Override
    public int maxFlyingHeight() {
        return 1;
    }

    @Override
    public int minFlyingHeight() {
        return 1;
    }

    @Override
    public boolean isFlyer() {
        return false;
    }

    @Override
    public boolean getIsFlying() {
        return false;
    }

    protected SoundEvent getAngrySound() {
        return SoundEvents.f_11915_;
    }

    @Override
    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getModelTexture(this.texture);
    }

    @Override
    public boolean isMovementCeased() {
        return !this.m_6069_() && !this.m_20159_() || this.m_20159_() || this.getIsSitting();
    }

    @Override
    public boolean checkSpawningBiome() {
        return true;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (this.m_21573_() != null) {
            this.m_21573_().m_26573_();
        }
        this.fishHooked = false;
        this.updateDivingDepth = false;
        super.m_142687_(reason);
    }
}

