/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity;

import drzhark.mocreatures.MoCreatures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;

public class MoCEntityData {
    private final MobSpawnSettings.SpawnerData spawnListEntry;
    private List<TagKey<Biome>> biomeTags;
    private List<TagKey<Biome>> blockedBiomeTags = new ArrayList<TagKey<Biome>>();
    private MobCategory typeOfCreature;
    private String entityName;
    private boolean canSpawn = true;
    private int entityId;
    private int frequency;
    private int minGroup;
    private int maxGroup;
    private int maxSpawnInChunk;
    private ResourceKey<Level>[] dimensions;

    public MoCEntityData(String name, int maxChunk, ResourceKey<Level>[] dimensions, MobCategory type, MobSpawnSettings.SpawnerData spawnListEntry, List<TagKey<Biome>> biomeTags) {
        this.entityName = name;
        this.typeOfCreature = type;
        this.dimensions = dimensions;
        this.biomeTags = biomeTags;
        this.frequency = spawnListEntry.m_142631_().m_146281_();
        this.minGroup = spawnListEntry.f_48405_;
        this.maxGroup = spawnListEntry.f_48406_;
        this.maxSpawnInChunk = maxChunk;
        this.spawnListEntry = spawnListEntry;
        MoCreatures.entityMap.put((Object)spawnListEntry.f_48404_, (Object)this);
    }

    public MoCEntityData(String name, int maxChunk, ResourceKey<Level>[] dimensions, MobCategory type, MobSpawnSettings.SpawnerData spawnListEntry, List<TagKey<Biome>> biomeTags, List<TagKey<Biome>> blockedBiomeTags) {
        this.entityName = name;
        this.typeOfCreature = type;
        this.dimensions = dimensions;
        this.biomeTags = biomeTags;
        this.blockedBiomeTags = blockedBiomeTags;
        this.frequency = spawnListEntry.m_142631_().m_146281_();
        this.minGroup = spawnListEntry.f_48405_;
        this.maxGroup = spawnListEntry.f_48406_;
        this.maxSpawnInChunk = maxChunk;
        this.spawnListEntry = spawnListEntry;
        MoCreatures.entityMap.put((Object)spawnListEntry.f_48404_, (Object)this);
    }

    public EntityType<?> getEntityClass() {
        return this.spawnListEntry.f_48404_;
    }

    public MobCategory getType() {
        return this.typeOfCreature;
    }

    public void setTypeMoC(MobCategory type) {
        this.typeOfCreature = type;
    }

    public ResourceKey<Level>[] getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(ResourceKey<Level>[] dimensions) {
        this.dimensions = dimensions;
    }

    public List<TagKey<Biome>> getBiomeTags() {
        return this.biomeTags;
    }

    public void setBiomeTags(List<TagKey<Biome>> biomeTags) {
        this.biomeTags = biomeTags;
    }

    public List<TagKey<Biome>> getBlockedBiomeTags() {
        return this.blockedBiomeTags;
    }

    public void setBlockedBiomeTags(List<TagKey<Biome>> blockedBiomeTags) {
        this.blockedBiomeTags = blockedBiomeTags;
    }

    public int getEntityID() {
        return this.entityId;
    }

    public void setEntityID(int id) {
        this.entityId = id;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int freq) {
        this.frequency = Math.max(freq, 0);
    }

    public int getMinSpawn() {
        return this.minGroup;
    }

    public void setMinSpawn(int min) {
        this.minGroup = Math.max(min, 0);
    }

    public int getMaxSpawn() {
        return this.maxGroup;
    }

    public void setMaxSpawn(int max) {
        this.maxGroup = Math.max(max, 0);
    }

    public int getMaxInChunk() {
        return this.maxSpawnInChunk;
    }

    public void setMaxInChunk(int max) {
        this.maxSpawnInChunk = Math.max(max, 0);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String name) {
        this.entityName = name;
    }

    public boolean getCanSpawn() {
        return this.canSpawn;
    }

    public void setCanSpawn(boolean flag) {
        this.canSpawn = flag;
    }

    public MobSpawnSettings.SpawnerData getSpawnListEntry() {
        return this.spawnListEntry;
    }
}

