/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.ai.EntityAIMoverHelperMoC;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.item.MoCEntityEgg;
import drzhark.mocreatures.entity.item.MoCEntityKittyBed;
import drzhark.mocreatures.entity.item.MoCEntityLitterBox;
import drzhark.mocreatures.entity.passive.MoCEntityHorse;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageHealth;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public abstract class MoCEntityMob
extends Monster
implements IMoCEntity {
    protected static final EntityDataAccessor<Boolean> ADULT = SynchedEntityData.m_135353_(MoCEntityMob.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(MoCEntityMob.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(MoCEntityMob.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<String> NAME_STR = SynchedEntityData.m_135353_(MoCEntityMob.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected boolean divePending;
    protected String texture = "blank.jpg";
    protected PathNavigation navigatorWater;
    protected PathNavigation navigatorFlyer;
    protected EntityAIWanderMoC2 wander;

    protected MoCEntityMob(EntityType<? extends MoCEntityMob> type, Level world) {
        super(type, world);
        this.f_21342_ = new EntityAIMoverHelperMoC((Mob)this);
        this.navigatorWater = new WaterBoundPathNavigation((Mob)this, world);
        this.navigatorFlyer = new FlyingPathNavigation((Mob)this, world);
        this.wander = new EntityAIWanderMoC2((PathfinderMob)this, 1.0, 80);
        this.f_21345_.m_25352_(4, (Goal)this.wander);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component m_7755_() {
        String entityString = this.m_6095_().m_20675_();
        if (!MoCreatures.proxy.verboseEntityNames || entityString == null) {
            return super.m_7755_();
        }
        String translationKey = "entity." + entityString + ".verbose.name";
        String translatedString = I18n.m_118938_((String)translationKey, (Object[])new Object[0]);
        return !translatedString.equals(translationKey) ? Component.m_237115_((String)translationKey) : super.m_7755_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.7f).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22276_, 20.0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.selectType();
        return super.m_6518_(world, difficulty, reason, spawnData, dataTag);
    }

    @Override
    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getModelTexture(this.texture);
    }

    @Override
    public void selectType() {
        this.setTypeMoC(1);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ADULT, (Object)false);
        this.f_19804_.m_135372_(TYPE, (Object)0);
        this.f_19804_.m_135372_(AGE, (Object)45);
        this.f_19804_.m_135372_(NAME_STR, (Object)"");
    }

    @Override
    public int getTypeMoC() {
        return (Integer)this.f_19804_.m_135370_(TYPE);
    }

    @Override
    public void setTypeMoC(int i) {
        this.f_19804_.m_135381_(TYPE, (Object)i);
    }

    @Override
    public boolean getIsAdult() {
        return (Boolean)this.f_19804_.m_135370_(ADULT);
    }

    @Override
    public void setAdult(boolean flag) {
        this.f_19804_.m_135381_(ADULT, (Object)flag);
    }

    @Override
    public boolean getIsTamed() {
        return false;
    }

    @Override
    public String getPetName() {
        return (String)this.f_19804_.m_135370_(NAME_STR);
    }

    @Override
    public void setPetName(String name) {
        this.f_19804_.m_135381_(NAME_STR, (Object)(name == null ? "" : name));
    }

    @Override
    public int getMoCAge() {
        return (Integer)this.f_19804_.m_135370_(AGE);
    }

    @Override
    public void setMoCAge(int i) {
        this.f_19804_.m_135381_(AGE, (Object)i);
        if (this.getMoCAge() >= this.getMaxAge()) {
            this.setAdult(true);
        }
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        return null;
    }

    @Override
    public int getOwnerPetId() {
        return 0;
    }

    @Override
    public void setOwnerPetId(int petId) {
    }

    public static boolean getCanSpawnHere(EntityType<? extends MoCEntityMob> type, ServerLevel world, MobSpawnType reason, BlockPos pos, Random randomIn) {
        boolean willSpawn = Monster.m_219019_(type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)((RandomSource)randomIn));
        boolean debug = MoCreatures.proxy.debug;
        if (willSpawn && debug) {
            MoCreatures.LOGGER.info("Mob: {} at: {} State: {} biome: {}", (Object)type.m_20676_(), (Object)pos, (Object)world.m_8055_(pos), (Object)MoCTools.biomeName((Level)world, pos));
        }
        return willSpawn;
    }

    public boolean entitiesToIgnore(Entity entity) {
        return !(entity instanceof Mob) || entity instanceof Monster || entity instanceof MoCEntityEgg || entity instanceof MoCEntityKittyBed || entity instanceof MoCEntityLitterBox || this.getIsTamed() && entity instanceof IMoCEntity && ((IMoCEntity)entity).getIsTamed() || entity instanceof Wolf && !MoCreatures.proxy.attackWolves || entity instanceof MoCEntityHorse && !MoCreatures.proxy.attackHorses;
    }

    @Override
    public boolean checkSpawningBiome() {
        return true;
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            float brightness;
            if (this.getIsTamed() && this.f_19796_.m_188503_(200) == 0) {
                MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageHealth(this.m_19879_(), this.m_21223_()));
            }
            if (this.isDaylightSensitive() && this.m_9236_().m_46461_() && (brightness = this.m_213856_()) > 0.5f && this.m_9236_().m_45527_(new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20186_()), Mth.m_14107_((double)this.m_20189_()))) && this.f_19796_.m_188501_() * 30.0f < (brightness - 0.4f) * 2.0f) {
                this.m_20254_(8);
            }
            if (this.getMoCAge() == 0) {
                this.setMoCAge(this.getMaxAge() - 10);
            }
            if (!this.getIsAdult() && this.f_19796_.m_188503_(300) == 0) {
                this.setMoCAge(this.getMoCAge() + 1);
                if (this.getMoCAge() >= this.getMaxAge()) {
                    this.setAdult(true);
                }
            }
            if (this.getIsFlying() && this.m_21573_().m_26571_() && !this.isMovementCeased() && this.m_5448_() == null && this.f_19796_.m_188503_(20) == 0) {
                this.wander.makeUpdate();
            }
        }
        this.m_21573_().m_7638_();
        super.m_8119_();
    }

    protected int getMaxAge() {
        return 100;
    }

    protected boolean isDaylightSensitive() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_9236_().f_46443_ && this.getIsTamed()) {
            MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageHealth(this.m_19879_(), this.m_21223_()));
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public boolean isFlyer() {
        return false;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Adult", this.getIsAdult());
        tag.m_128405_("Edad", this.getMoCAge());
        tag.m_128359_("Name", this.getPetName());
        tag.m_128405_("TypeInt", this.getTypeMoC());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setAdult(tag.m_128471_("Adult"));
        this.setMoCAge(tag.m_128451_("Edad"));
        this.setPetName(tag.m_128461_("Name"));
        this.setTypeMoC(tag.m_128451_("TypeInt"));
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        if (!this.isFlyer()) {
            return super.m_142535_(distance, damageMultiplier, source);
        }
        return false;
    }

    public boolean m_6147_() {
        return this.isFlyer() ? false : super.m_6147_();
    }

    public void m_7023_(Vec3 delta) {
        if (!this.isFlyer()) {
            super.m_7023_(delta);
            return;
        }
        this.navigateFlying(delta);
    }

    protected void navigateFlying(Vec3 delta) {
        if (this.m_6084_() && !this.m_9236_().f_46443_) {
            this.m_19920_(0.1f, delta);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(delta);
        }
    }

    @Override
    public void performAnimation(int attackType) {
    }

    @Override
    public int nameYOffset() {
        return 0;
    }

    @Override
    public boolean renderName() {
        return MoCreatures.proxy.getDisplayPetName() && !this.getPetName().isEmpty() && !this.m_20159_() && this.m_20202_() == null;
    }

    @Override
    public void makeEntityJump() {
    }

    @Override
    public void makeEntityDive() {
        this.divePending = true;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_9236_().f_46443_ && this.getIsTamed() && this.m_21223_() > 0.0f) {
            return;
        }
        super.m_142687_(reason);
    }

    @Override
    public float getSizeFactor() {
        return 1.0f;
    }

    @Override
    public float getAdjustedYOffset() {
        return 0.0f;
    }

    @Override
    public void setArmorType(int i) {
    }

    @Override
    public float pitchRotationOffset() {
        return 0.0f;
    }

    @Override
    public float rollRotationOffset() {
        return 0.0f;
    }

    @Override
    public float yawRotationOffset() {
        return 0.0f;
    }

    @Override
    public float getAdjustedZOffset() {
        return 0.0f;
    }

    @Override
    public float getAdjustedXOffset() {
        return 0.0f;
    }

    @Override
    public boolean canAttackTarget(LivingEntity entity) {
        return false;
    }

    @Override
    public boolean getIsSitting() {
        return false;
    }

    @Override
    public boolean isNotScared() {
        return true;
    }

    @Override
    public boolean isMovementCeased() {
        return false;
    }

    @Override
    public boolean shouldAttackPlayers() {
        return this.m_9236_().m_46791_() != Difficulty.PEACEFUL;
    }

    @Override
    public double getDivingDepth() {
        return 0.0;
    }

    @Override
    public boolean isDiving() {
        return false;
    }

    @Override
    public void forceEntityJump() {
    }

    public boolean m_7327_(Entity target) {
        boolean flag = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
        if (flag) {
            this.m_19970_((LivingEntity)this, target);
        }
        return flag;
    }

    @Override
    public int maxFlyingHeight() {
        return 5;
    }

    @Override
    public int minFlyingHeight() {
        return 1;
    }

    public PathNavigation m_21573_() {
        if (this.m_20069_() && this.isAmphibian()) {
            return this.navigatorWater;
        }
        if (this.isFlyer()) {
            return this.navigatorFlyer;
        }
        return super.m_21573_();
    }

    public boolean isAmphibian() {
        return false;
    }

    @Override
    public boolean getIsFlying() {
        return this.isFlyer();
    }

    public boolean m_20145_() {
        return false;
    }

    @Override
    public boolean getIsGhost() {
        return false;
    }
}

