/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.ai;

import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.MoCEntityAquatic;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityAIFleeFromEntityMoC
extends Goal {
    private final double farSpeed;
    private final double nearSpeed;
    private final float avoidDistance;
    private final Predicate<Entity> avoidTargetSelector;
    protected Mob entity;
    public final Predicate<Entity> canBeSeenSelector = entityIn -> entityIn.m_6084_() && this.entity.m_21574_().m_148306_(entityIn);
    protected Entity closestLivingEntity;
    private double randPosX;
    private double randPosY;
    private double randPosZ;

    public EntityAIFleeFromEntityMoC(Mob mob, Predicate<Entity> targetSelector, float searchDistance, double farSpeedIn, double nearSpeedIn) {
        this.entity = mob;
        this.avoidTargetSelector = targetSelector;
        this.avoidDistance = searchDistance;
        this.farSpeed = farSpeedIn;
        this.nearSpeed = nearSpeedIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.entity instanceof IMoCEntity && ((IMoCEntity)this.entity).isNotScared()) {
            return false;
        }
        if (this.entity instanceof MoCEntityAquatic && !this.entity.m_20069_()) {
            return false;
        }
        AABB searchBox = this.entity.m_20191_().m_82377_((double)this.avoidDistance, 3.0, (double)this.avoidDistance);
        List list = this.entity.m_9236_().m_6443_(Entity.class, searchBox, e -> EntitySelector.f_20408_.test(e) && this.canBeSeenSelector.test((Entity)e) && this.avoidTargetSelector.test((Entity)e));
        if (list.isEmpty()) {
            return false;
        }
        this.closestLivingEntity = (Entity)list.get(0);
        BlockPos awayPos = RandomPos.m_217855_((RandomSource)this.entity.m_217043_(), (int)16, (int)7, (int)((int)Math.floor(this.entity.m_20186_())), (double)(this.entity.m_20185_() - this.closestLivingEntity.m_20185_()), (double)(this.entity.m_20189_() - this.closestLivingEntity.m_20189_()), (double)Math.PI);
        if (awayPos == null) {
            return false;
        }
        Vec3 vec3 = Vec3.m_82539_((Vec3i)awayPos);
        if (this.closestLivingEntity.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < this.closestLivingEntity.m_20280_((Entity)this.entity)) {
            return false;
        }
        this.randPosX = vec3.f_82479_;
        this.randPosY = vec3.f_82480_;
        this.randPosZ = vec3.f_82481_;
        return true;
    }

    public void m_8056_() {
        this.entity.m_21573_().m_26519_(this.randPosX, this.randPosY, this.randPosZ, this.nearSpeed);
    }

    public boolean m_8045_() {
        return !this.entity.m_21573_().m_26571_();
    }

    public void m_8041_() {
        this.closestLivingEntity = null;
    }

    public void m_8037_() {
        if (this.entity.m_20280_(this.closestLivingEntity) < 8.0) {
            this.entity.m_21573_().m_26517_(this.nearSpeed);
        } else {
            this.entity.m_21573_().m_26517_(this.farSpeed);
        }
    }
}

