/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.ai;

import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.MoCEntityAnimal;
import drzhark.mocreatures.entity.ai.EntityAITools;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class EntityAIFollowOwnerPlayer
extends Goal {
    private final Mob thePet;
    private final double speed;
    private final PathNavigation petPathfinder;
    private final Level level;
    float maxDist;
    float minDist;
    private Player theOwner;
    private int delayCounter;

    public EntityAIFollowOwnerPlayer(Mob thePetIn, double speedIn, float minDistIn, float maxDistIn) {
        this.thePet = thePetIn;
        this.level = thePetIn.m_9236_();
        this.speed = speedIn;
        this.petPathfinder = thePetIn.m_21573_();
        this.minDist = minDistIn;
        this.maxDist = maxDistIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (((IMoCEntity)this.thePet).getIsSitting()) {
            return false;
        }
        if (!((MoCEntityAnimal)this.thePet).getIsFollowingOwnerPlayer()) {
            return false;
        }
        UUID ownerUniqueId = ((IMoCTameable)this.thePet).getOwnerId();
        if (ownerUniqueId == null) {
            return false;
        }
        Player entityplayer = EntityAITools.getIMoCTameableOwner((IMoCTameable)this.thePet);
        if (entityplayer == null) {
            return false;
        }
        if (this.thePet.m_20280_((Entity)entityplayer) < (double)(this.minDist * this.minDist) || this.thePet.m_20280_((Entity)entityplayer) > (double)(this.maxDist * this.maxDist)) {
            return false;
        }
        this.theOwner = entityplayer;
        return true;
    }

    public boolean m_8045_() {
        return !this.petPathfinder.m_26571_() && this.thePet.m_20280_((Entity)this.theOwner) > (double)(this.maxDist * this.maxDist) && !((IMoCEntity)this.thePet).getIsSitting();
    }

    public void m_8056_() {
        this.delayCounter = 0;
    }

    public void m_8041_() {
        this.theOwner = null;
        this.petPathfinder.m_26573_();
    }

    private boolean isEmptyBlock(BlockPos pos) {
        BlockState iblockstate = this.level.m_8055_(pos);
        return iblockstate.m_60795_() || !iblockstate.m_60815_();
    }

    public void m_8037_() {
        this.thePet.m_21563_().m_24960_((Entity)this.theOwner, 10.0f, (float)this.thePet.m_8132_());
        if (!((IMoCEntity)this.thePet).getIsSitting() && --this.delayCounter <= 0) {
            this.delayCounter = 10;
            if (!this.petPathfinder.m_5624_((Entity)this.theOwner, this.speed) && !this.thePet.m_21523_() && this.thePet.m_20280_((Entity)this.theOwner) >= 144.0) {
                int i = Mth.m_14107_((double)this.theOwner.m_20185_()) - 2;
                int j = Mth.m_14107_((double)this.theOwner.m_20189_()) - 2;
                int k = Mth.m_14107_((double)this.theOwner.m_20191_().f_82289_);
                for (int l = 0; l <= 4; ++l) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        BlockPos pos = new BlockPos(i + l, k - 1, j + i1);
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.level.m_8055_(pos).m_60783_((BlockGetter)this.level, pos, Direction.UP) || !this.isEmptyBlock(new BlockPos(i + l, k, j + i1)) || !this.isEmptyBlock(new BlockPos(i + l, k + 1, j + i1))) continue;
                        this.thePet.m_7678_((double)(i + l) + 0.5, (double)k, (double)(j + i1) + 0.5, this.thePet.m_146908_(), this.thePet.m_146909_());
                        this.petPathfinder.m_26573_();
                        return;
                    }
                }
            }
        }
    }
}

