/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.ai;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.MoCEntityAquatic;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;

public class EntityAIMoverHelperMoC
extends MoveControl {
    protected MoveControl.Operation operation = MoveControl.Operation.WAIT;
    PathfinderMob theCreature;

    public EntityAIMoverHelperMoC(Mob entityliving) {
        super(entityliving);
        this.theCreature = (PathfinderMob)entityliving;
    }

    public boolean isUpdating() {
        return this.operation == MoveControl.Operation.MOVE_TO;
    }

    public void m_6849_(double x, double y, double z, double speedIn) {
        this.f_24975_ = x;
        this.f_24976_ = y;
        this.f_24977_ = z;
        this.f_24978_ = speedIn;
        this.operation = MoveControl.Operation.MOVE_TO;
    }

    public void m_24988_(float forward, float strafe) {
        this.operation = MoveControl.Operation.STRAFE;
        this.f_24979_ = forward;
        this.f_24980_ = strafe;
        this.f_24978_ = 0.25;
    }

    public void onUpdateMoveOnGround() {
        if (this.operation == MoveControl.Operation.STRAFE) {
            NodeEvaluator nodeprocessor;
            float f = (float)this.f_24974_.m_21133_(Attributes.f_22279_);
            float f1 = (float)this.f_24978_ * f;
            float f2 = this.f_24979_;
            float f3 = this.f_24980_;
            float f4 = Mth.m_14116_((float)(f2 * f2 + f3 * f3));
            if (f4 < 1.0f) {
                f4 = 1.0f;
            }
            f4 = f1 / f4;
            float f5 = Mth.m_14031_((float)(this.f_24974_.m_146908_() * ((float)Math.PI / 180)));
            float f6 = Mth.m_14089_((float)(this.f_24974_.m_146908_() * ((float)Math.PI / 180)));
            float f7 = (f2 *= f4) * f6 - (f3 *= f4) * f5;
            float f8 = f3 * f6 + f2 * f5;
            PathNavigation pathnavigate = this.f_24974_.m_21573_();
            if (pathnavigate != null && (nodeprocessor = pathnavigate.m_26575_()) != null && nodeprocessor.m_8086_((BlockGetter)this.f_24974_.m_9236_(), Mth.m_14107_((double)(this.f_24974_.m_20185_() + (double)f7)), Mth.m_14107_((double)this.f_24974_.m_20186_()), Mth.m_14107_((double)(this.f_24974_.m_20189_() + (double)f8))) != BlockPathTypes.WALKABLE) {
                this.f_24979_ = 1.0f;
                this.f_24980_ = 0.0f;
                f1 = f;
            }
            this.f_24974_.m_7910_(f1);
            this.f_24974_.m_21564_(this.f_24979_);
            this.f_24974_.m_21570_(this.f_24980_);
            this.operation = MoveControl.Operation.WAIT;
        } else if (this.operation == MoveControl.Operation.MOVE_TO) {
            this.operation = MoveControl.Operation.WAIT;
            double d0 = this.f_24975_ - this.f_24974_.m_20185_();
            double d1 = this.f_24977_ - this.f_24974_.m_20189_();
            double d2 = this.f_24976_ - this.f_24974_.m_20186_();
            double d3 = d0 * d0 + d2 * d2 + d1 * d1;
            if (d3 < 2.500000277905201E-7) {
                this.f_24974_.m_21564_(0.0f);
                return;
            }
            float f9 = (float)(Mth.m_14136_((double)d1, (double)d0) * 57.29577951308232) - 90.0f;
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), f9, 20.0f));
            this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
            if (d2 > (double)this.f_24974_.getStepHeight() && d0 * d0 + d1 * d1 < (double)Math.max(1.0f, this.f_24974_.m_20205_())) {
                this.f_24974_.m_21569_().m_24901_();
            }
        } else {
            this.f_24974_.m_21564_(0.0f);
        }
    }

    protected float m_24991_(float p_75639_1_, float p_75639_2_, float p_75639_3_) {
        float f1;
        float f = Mth.m_14177_((float)(p_75639_2_ - p_75639_1_));
        if (f > p_75639_3_) {
            f = p_75639_3_;
        }
        if (f < -p_75639_3_) {
            f = -p_75639_3_;
        }
        if ((f1 = p_75639_1_ + f) < 0.0f) {
            f1 += 360.0f;
        } else if (f1 > 360.0f) {
            f1 -= 360.0f;
        }
        return f1;
    }

    public void m_8126_() {
        boolean isFlyer = ((IMoCEntity)this.theCreature).isFlyer();
        boolean isSwimmer = this.theCreature.m_20069_();
        float fLimitAngle = 90.0f;
        if (!isFlyer && !isSwimmer) {
            this.onUpdateMoveOnGround();
            return;
        }
        if (isFlyer && !this.theCreature.m_20160_()) {
            this.flyingMovementUpdate();
        }
        if (isSwimmer) {
            this.swimmerMovementUpdate();
            fLimitAngle = 30.0f;
        }
        if (this.operation == MoveControl.Operation.MOVE_TO && !this.theCreature.m_21573_().m_26571_()) {
            double d0 = this.f_24975_ - this.theCreature.m_20185_();
            double d1 = this.f_24976_ - this.theCreature.m_20186_();
            double d2 = this.f_24977_ - this.theCreature.m_20189_();
            double d3 = d0 * d0 + d1 * d1 + d2 * d2;
            if ((d3 = (double)Mth.m_14116_((float)((float)d3))) < 0.5) {
                this.f_24974_.m_21564_(0.0f);
                this.theCreature.m_21573_().m_26573_();
                return;
            }
            d1 /= d3;
            float f = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
            this.theCreature.m_146922_(this.m_24991_(this.theCreature.m_146908_(), f, fLimitAngle));
            this.theCreature.f_20883_ = this.theCreature.m_146908_();
            float f1 = (float)(this.f_24978_ * this.theCreature.m_21133_(Attributes.f_22279_));
            this.theCreature.m_7910_(this.theCreature.m_6113_() + (f1 - this.theCreature.m_6113_()) * 0.125f);
            double d4 = Math.sin((double)(this.theCreature.f_19797_ + this.theCreature.m_19879_()) * 0.75) * 0.01;
            double d5 = Math.cos(this.theCreature.m_146908_() * (float)Math.PI / 180.0f);
            double d6 = Math.sin(this.theCreature.m_146908_() * (float)Math.PI / 180.0f);
            double targetDepth = MoCTools.waterSurfaceAtGivenEntity((Entity)this.theCreature) - this.theCreature.m_20186_();
            double yMotion = 0.0;
            if (targetDepth > ((IMoCEntity)this.theCreature).getDivingDepth()) {
                yMotion = 0.01;
            } else if (targetDepth < ((IMoCEntity)this.theCreature).getDivingDepth() - 0.2) {
                yMotion = -0.005;
            }
            this.theCreature.m_20256_(this.theCreature.m_20184_().m_82520_(d4 * d5, yMotion, d4 * d6));
        }
    }

    private void flyingMovementUpdate() {
        if (((IMoCEntity)this.theCreature).getIsFlying()) {
            int distY = MoCTools.distanceToFloor((Entity)this.theCreature);
            if (distY <= ((IMoCEntity)this.theCreature).minFlyingHeight() && (this.theCreature.f_19862_ || this.theCreature.m_9236_().f_46441_.m_188503_(100) == 0)) {
                this.theCreature.m_20256_(this.theCreature.m_20184_().m_82520_(0.0, 0.02, 0.0));
            }
            if (distY > ((IMoCEntity)this.theCreature).maxFlyingHeight() || this.theCreature.m_9236_().f_46441_.m_188503_(150) == 0) {
                this.theCreature.m_20256_(this.theCreature.m_20184_().m_82492_(0.0, 0.02, 0.0));
            }
        } else if (this.theCreature.m_20184_().f_82480_ < 0.0) {
            this.theCreature.m_20256_(this.theCreature.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
    }

    private void swimmerMovementUpdate() {
        if (this.theCreature.m_20160_()) {
            return;
        }
        double distToSurface = MoCTools.waterSurfaceAtGivenEntity((Entity)this.theCreature) - this.theCreature.m_20186_();
        if (distToSurface > ((IMoCEntity)this.theCreature).getDivingDepth()) {
            if (this.theCreature.m_20184_().f_82480_ < 0.0) {
                this.theCreature.m_20334_(this.theCreature.m_20184_().m_7096_(), 0.0, this.theCreature.m_20184_().m_7094_());
            }
            this.theCreature.m_20256_(this.theCreature.m_20184_().m_82520_(0.0, 0.001 + distToSurface * 0.01, 0.0));
        }
        if (!this.theCreature.m_21573_().m_26571_() && this.theCreature.f_19862_) {
            if (this.theCreature instanceof MoCEntityAquatic) {
                this.theCreature.m_20334_(this.theCreature.m_20184_().m_7096_(), 0.05, this.theCreature.m_20184_().m_7094_());
            } else {
                ((IMoCEntity)this.theCreature).forceEntityJump();
            }
        }
        if (this.theCreature.m_5448_() != null && this.theCreature.m_5448_().m_20186_() < this.f_24975_ - 0.5 && this.theCreature.m_20270_((Entity)this.theCreature.m_5448_()) < 10.0f && this.theCreature.m_20184_().f_82480_ < -0.1) {
            this.theCreature.m_20334_(this.theCreature.m_20184_().m_7096_(), -0.1, this.theCreature.m_20184_().m_7094_());
        }
    }
}

