/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.ai;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.ai.PathNavigateFlyer;
import drzhark.mocreatures.entity.ai.RandomPositionGeneratorMoCFlyer;
import drzhark.mocreatures.entity.ambient.MoCEntityAnt;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class EntityAIWanderMoC2
extends Goal {
    private final PathfinderMob entity;
    private final double speed;
    private double xPosition;
    private double yPosition;
    private double zPosition;
    private int executionChance;
    private boolean mustUpdate;

    public EntityAIWanderMoC2(PathfinderMob creatureIn, double speedIn) {
        this(creatureIn, speedIn, 120);
    }

    public EntityAIWanderMoC2(PathfinderMob creatureIn, double speedIn, int chance) {
        this.entity = creatureIn;
        this.speed = speedIn;
        this.executionChance = chance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        Vec3 vec3;
        if (this.entity.f_19862_ || this.entity.m_20069_() && this.entity.m_217043_().m_188503_(40) == 0) {
            this.mustUpdate = true;
        }
        if (this.entity instanceof IMoCEntity && ((IMoCEntity)this.entity).isMovementCeased()) {
            return false;
        }
        if (this.entity.m_20160_() && !(this.entity instanceof MoCEntityAnt) && !(this.entity instanceof MoCEntityMob)) {
            return false;
        }
        if (!this.mustUpdate) {
            if (this.entity.m_21216_() >= 100) {
                return false;
            }
            if (this.entity.m_217043_().m_188503_(this.executionChance) != 0) {
                return false;
            }
        }
        if ((vec3 = RandomPositionGeneratorMoCFlyer.findRandomTarget(this.entity, 10, 12)) != null && this.entity instanceof IMoCEntity && this.entity.m_21573_() instanceof PathNavigateFlyer) {
            int distToFloor = MoCTools.distanceToFloor((Entity)this.entity);
            int finalYHeight = distToFloor + Mth.m_14107_((double)(vec3.f_82480_ - this.entity.m_20186_()));
            if (finalYHeight < ((IMoCEntity)this.entity).minFlyingHeight()) {
                return false;
            }
            if (finalYHeight > ((IMoCEntity)this.entity).maxFlyingHeight()) {
                return false;
            }
        }
        if (vec3 == null) {
            return false;
        }
        this.xPosition = vec3.f_82479_;
        this.yPosition = vec3.f_82480_;
        this.zPosition = vec3.f_82481_;
        this.mustUpdate = false;
        return true;
    }

    public boolean m_8045_() {
        return !this.entity.m_21573_().m_26571_() && !this.entity.m_20160_();
    }

    public void m_8056_() {
        this.entity.m_21573_().m_26519_(this.xPosition, this.yPosition, this.zPosition, this.speed);
    }

    public void makeUpdate() {
        this.mustUpdate = true;
    }

    public void setExecutionChance(int newchance) {
        this.executionChance = newchance;
    }
}

