/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.ambient;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.entity.MoCEntityInsect;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MoCEntityBee
extends MoCEntityInsect {
    private int soundCount;

    public MoCEntityBee(EntityType<? extends MoCEntityBee> type, Level world) {
        super((EntityType<? extends MoCEntityInsect>)type, world);
        this.texture = "bee.png";
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22280_, 0.25);
    }

    public void m_8107_() {
        Player player;
        super.m_8107_();
        if (!this.m_9236_().m_5776_() && this.getIsFlying() && --this.soundCount == -1 && (player = this.m_9236_().m_45930_((Entity)this, 5.0)) != null) {
            MoCTools.playCustomSound((Entity)this, this.getMySound());
            this.soundCount = 20;
        }
    }

    private SoundEvent getMySound() {
        if (this.m_5448_() != null) {
            return (SoundEvent)MoCSoundEvents.ENTITY_BEE_UPSET.get();
        }
        return (SoundEvent)MoCSoundEvents.ENTITY_BEE_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_BEE_HURT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)MoCSoundEvents.ENTITY_BEE_HURT.get();
    }

    @Nullable
    protected ResourceLocation m_7582_() {
        return MoCLootTables.BEE;
    }

    public int m_8100_() {
        return 2000;
    }

    public boolean m_6469_(DamageSource damagesource, float damage) {
        Entity entity;
        if (super.m_6469_(damagesource, damage) && (entity = damagesource.m_7639_()) instanceof LivingEntity) {
            LivingEntity entityliving = (LivingEntity)entity;
            if (entity != this && this.m_9236_().m_46791_().m_19028_() > 0) {
                this.m_6710_(entityliving);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isMyFavoriteFood(ItemStack stack) {
        return !stack.m_41619_() && stack.m_204117_(ItemTags.f_13149_);
    }

    public float m_6113_() {
        if (this.getIsFlying()) {
            return 0.15f;
        }
        return 0.12f;
    }

    @Override
    public boolean isFlyer() {
        return true;
    }
}

