/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.aquatic;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.ai.EntityAIPanicMoC;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAquatic;
import drzhark.mocreatures.init.MoCEntities;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageHeart;
import drzhark.mocreatures.util.MoCTags;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class MoCEntityDolphin
extends MoCEntityTameableAquatic {
    private static final EntityDataAccessor<Boolean> IS_HUNGRY = SynchedEntityData.m_135353_(MoCEntityDolphin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_EATEN = SynchedEntityData.m_135353_(MoCEntityDolphin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int gestationtime;

    public MoCEntityDolphin(EntityType<? extends MoCEntityDolphin> type, Level world) {
        super((EntityType<? extends MoCEntityTameableAquatic>)type, world);
        this.setAdult(true);
        this.setMoCAge(120);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new EntityAIPanicMoC((PathfinderMob)this, 1.3));
        this.f_21345_.m_25352_(5, (Goal)new EntityAIWanderMoC2((PathfinderMob)this, 1.0, 30));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityTameableAquatic.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22281_, 4.5);
    }

    @Override
    public void selectType() {
        if (this.getTypeMoC() == 0) {
            int i = this.f_19796_.m_188503_(100);
            if (i <= 35) {
                this.setTypeMoC(1);
            } else if (i <= 60) {
                this.setTypeMoC(2);
            } else if (i <= 85) {
                this.setTypeMoC(3);
            } else if (i <= 96) {
                this.setTypeMoC(4);
            } else if (i <= 98) {
                this.setTypeMoC(5);
            } else {
                this.setTypeMoC(6);
            }
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getTypeMoC()) {
            case 2: {
                return MoCreatures.proxy.getModelTexture("dolphin_green.png");
            }
            case 3: {
                return MoCreatures.proxy.getModelTexture("dolphin_purple.png");
            }
            case 4: {
                return MoCreatures.proxy.getModelTexture("dolphin_black.png");
            }
            case 5: {
                return MoCreatures.proxy.getModelTexture("dolphin_pink.png");
            }
            case 6: {
                return MoCreatures.proxy.getModelTexture("dolphin_white.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("dolphin_blue.png");
    }

    @Override
    public int getMaxTemper() {
        switch (this.getTypeMoC()) {
            case 1: {
                return 50;
            }
            case 3: {
                return 150;
            }
            case 4: {
                return 200;
            }
            case 5: {
                return 250;
            }
            case 6: {
                return 300;
            }
        }
        return 100;
    }

    public int getInitialTemper() {
        switch (this.getTypeMoC()) {
            case 2: {
                return 100;
            }
            case 3: {
                return 150;
            }
            case 4: {
                return 200;
            }
            case 5: {
                return 250;
            }
            case 6: {
                return 300;
            }
        }
        return 50;
    }

    @Override
    public double getCustomSpeed() {
        switch (this.getTypeMoC()) {
            case 2: {
                return 2.0;
            }
            case 3: {
                return 2.5;
            }
            case 4: {
                return 3.0;
            }
            case 5: {
                return 3.5;
            }
            case 6: {
                return 4.0;
            }
        }
        return 1.5;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_HUNGRY, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(HAS_EATEN, (Object)Boolean.FALSE);
    }

    public boolean getIsHungry() {
        return (Boolean)this.f_19804_.m_135370_(IS_HUNGRY);
    }

    public void setIsHungry(boolean flag) {
        this.f_19804_.m_135381_(IS_HUNGRY, (Object)flag);
    }

    @Override
    public boolean getHasEaten() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EATEN);
    }

    @Override
    public void setHasEaten(boolean flag) {
        this.f_19804_.m_135381_(HAS_EATEN, (Object)flag);
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float i) {
        Entity entity;
        if (super.m_6469_(damagesource, i) && this.m_9236_().m_46791_().m_19028_() > 0 && (entity = damagesource.m_7639_()) instanceof LivingEntity) {
            LivingEntity entityliving = (LivingEntity)entity;
            if (this.m_20160_() && !this.m_20197_().isEmpty() && entity == this.m_20197_().get(0)) {
                return true;
            }
            if (entity != this && this.getMoCAge() >= 100) {
                this.m_6710_(entityliving);
            }
            return true;
        }
        return false;
    }

    public boolean m_5829_() {
        return !this.m_20160_();
    }

    private int Genetics(MoCEntityDolphin entitydolphin, MoCEntityDolphin entitydolphin1) {
        boolean flag1;
        if (entitydolphin.getTypeMoC() == entitydolphin1.getTypeMoC()) {
            return entitydolphin.getTypeMoC();
        }
        int i = entitydolphin.getTypeMoC() + entitydolphin1.getTypeMoC();
        boolean flag = this.f_19796_.m_188503_(3) == 0;
        boolean bl = flag1 = this.f_19796_.m_188503_(10) == 0;
        if (i < 5 && flag) {
            return i;
        }
        if ((i == 5 || i == 6) && flag1) {
            return i;
        }
        return 0;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_DOLPHIN_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)MoCSoundEvents.ENTITY_DOLPHIN_HURT.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)MoCSoundEvents.ENTITY_DOLPHIN_AMBIENT.get();
    }

    @Override
    protected SoundEvent getAngrySound() {
        return (SoundEvent)MoCSoundEvents.ENTITY_DOLPHIN_UPSET.get();
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.DOLPHIN;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && this.isInTag(stack.m_41720_(), MoCTags.Items.RAW_FISHES)) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if (!this.m_9236_().m_5776_()) {
                this.setTemper(this.getTemper() + 25);
                if (this.getTemper() >= this.getMaxTemper() && !this.getIsTamed()) {
                    MoCTools.tameWithName(player, this);
                } else if (this.getTemper() > this.getMaxTemper()) {
                    this.setTemper(this.getMaxTemper() - 1);
                }
                if (this.m_21223_() + 15.0f > this.m_21233_()) {
                    this.m_21153_(this.m_21233_());
                } else {
                    this.m_21153_(this.m_21223_() + 15.0f);
                }
                if (!this.getIsAdult()) {
                    this.setMoCAge(this.getMoCAge() + 1);
                }
            }
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_EATING.get());
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41619_() && this.isInTag(stack.m_41720_(), MoCTags.Items.COOKED_FISHES) && this.getIsTamed() && this.getIsAdult()) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if (this.m_21223_() + 25.0f > this.m_21233_()) {
                this.m_21153_(this.m_21233_());
            } else {
                this.m_21153_(this.m_21223_() + 25.0f);
            }
            this.setHasEaten(true);
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GENERIC_EATING.get());
            return InteractionResult.SUCCESS;
        }
        if (!this.m_20160_()) {
            if (!this.m_9236_().m_5776_() && player.m_20329_((Entity)this)) {
                player.m_146922_(this.m_146908_());
                player.m_146926_(this.m_146909_());
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private boolean isInTag(Item item, TagKey<Item> tag) {
        return item.m_204114_().m_203656_(tag);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            ItemEntity entityitem;
            if (!this.getIsAdult() && this.f_19796_.m_188503_(50) == 0) {
                this.setMoCAge(this.getMoCAge() + 1);
                if (this.getMoCAge() >= 150) {
                    this.setAdult(true);
                }
            }
            if (!(this.m_20160_() || this.f_20919_ != 0 || this.getIsTamed() && !this.getIsHungry() || (entityitem = this.getClosestFish((Entity)this, 12.0)) == null)) {
                this.moveToNextEntity((Entity)entityitem);
                ItemEntity entityitem1 = this.getClosestFish((Entity)this, 2.0);
                if (this.f_19796_.m_188503_(20) == 0 && entityitem1 != null && this.f_20919_ == 0) {
                    entityitem1.m_142687_(Entity.RemovalReason.DISCARDED);
                    this.setTemper(this.getTemper() + 25);
                    if (this.getTemper() > this.getMaxTemper()) {
                        this.setTemper(this.getMaxTemper() - 1);
                    }
                    this.m_21153_(this.m_21233_());
                }
            }
            if (!this.ReadyforParenting(this)) {
                return;
            }
            int i = 0;
            List list = this.m_9236_().m_6443_(Entity.class, this.m_20191_().m_82377_(8.0, 2.0, 8.0), entity -> entity != this);
            for (Entity entity2 : list) {
                if (!(entity2 instanceof MoCEntityDolphin)) continue;
                ++i;
            }
            if (i > 1) {
                return;
            }
            List list1 = this.m_9236_().m_6443_(Entity.class, this.m_20191_().m_82377_(4.0, 2.0, 4.0), entity -> entity != this);
            for (Entity entity1 : list1) {
                Entity babyEntity;
                EntityType dolphinType;
                if (!(entity1 instanceof MoCEntityDolphin) || entity1 == this) continue;
                MoCEntityDolphin entitydolphin = (MoCEntityDolphin)entity1;
                if (!this.ReadyforParenting(this) || !this.ReadyforParenting(entitydolphin)) continue;
                if (this.f_19796_.m_188503_(100) == 0) {
                    ++this.gestationtime;
                }
                if (this.gestationtime % 3 == 0) {
                    MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageHeart(this.m_19879_()));
                }
                if (this.gestationtime <= 50 || (dolphinType = (EntityType)MoCEntities.DOLPHIN.get()) == null || !((babyEntity = dolphinType.m_20615_(this.m_9236_())) instanceof MoCEntityDolphin)) continue;
                MoCEntityDolphin babydolphin = (MoCEntityDolphin)babyEntity;
                babydolphin.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                if (!this.m_9236_().m_7967_((Entity)babydolphin)) continue;
                MoCTools.playCustomSound((Entity)this, SoundEvents.f_11752_);
                this.setHasEaten(false);
                entitydolphin.setHasEaten(false);
                this.gestationtime = 0;
                entitydolphin.gestationtime = 0;
                int l = this.Genetics(this, entitydolphin);
                babydolphin.setMoCAge(35);
                babydolphin.setAdult(false);
                babydolphin.setOwnerId(this.getOwnerId());
                babydolphin.setTamed(true);
                UUID ownerId = this.getOwnerId();
                Player entityplayer = null;
                if (ownerId != null) {
                    entityplayer = this.m_9236_().m_46003_(this.getOwnerId());
                }
                if (entityplayer != null) {
                    MoCTools.tameWithName(entityplayer, babydolphin);
                }
                babydolphin.setTypeInt(l);
                break;
            }
        }
    }

    public boolean ReadyforParenting(MoCEntityDolphin entitydolphin) {
        LivingEntity passenger = this.m_6688_();
        return !entitydolphin.m_20160_() && passenger == null && entitydolphin.getIsTamed() && entitydolphin.getHasEaten() && entitydolphin.getIsAdult();
    }

    @Override
    public void m_142687_(Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.DISCARDED) {
            super.m_142687_(reason);
            return;
        }
        if (this.m_9236_().m_5776_() || !this.getIsTamed() || !(this.m_21223_() > 0.0f)) {
            super.m_142687_(reason);
        }
    }

    @Override
    protected boolean usesNewAI() {
        return true;
    }

    public float m_6113_() {
        return 0.15f;
    }

    @Override
    public boolean isMovementCeased() {
        return !this.m_20069_();
    }

    @Override
    protected double minDivingDepth() {
        return 0.4;
    }

    @Override
    protected double maxDivingDepth() {
        return 4.0;
    }

    @Override
    public int getMaxAge() {
        return 160;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(passenger)) {
            double dist = 0.8;
            double newPosX = this.m_20185_() + dist * Math.sin(this.f_20883_ / 57.29578f);
            double newPosZ = this.m_20189_() - dist * Math.cos(this.f_20883_ / 57.29578f);
            moveFunction.m_20372_(passenger, newPosX, this.m_20186_() + this.getMountedYOffset() + passenger.m_6049_(), newPosZ);
        }
    }

    public double getMountedYOffset() {
        return (double)((float)this.getMoCAge() * 0.01f) * ((double)this.m_20206_() * 0.3);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.315f;
    }

    public boolean canBeControlledByRider() {
        return this.m_6688_() instanceof Player && this.getIsTamed();
    }

    @Override
    public LivingEntity m_6688_() {
        Entity entity;
        if (this.m_20160_() && (entity = (Entity)this.m_20197_().get(0)) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    @Override
    public void m_8119_() {
        LivingEntity passenger;
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.m_20160_() && !this.getIsTamed() && (passenger = this.m_6688_()) != null && passenger instanceof Player) {
            Player player = (Player)passenger;
            boolean riderUnderwater = passenger.m_204029_(FluidTags.f_13131_);
            int buckingChance = riderUnderwater ? 50 : 15;
            long seed = this.m_19879_() + this.f_19797_;
            Random syncRandom = new Random(seed);
            if (syncRandom.nextInt(buckingChance) == 0) {
                double offsetX = syncRandom.nextGaussian() * 0.5;
                double offsetZ = syncRandom.nextGaussian() * 0.5;
                double dismountX = this.m_20185_() + offsetX;
                double dismountY = this.m_20186_();
                double dismountZ = this.m_20189_() + offsetZ;
                passenger.m_8127_();
                passenger.m_6021_(dismountX, dismountY, dismountZ);
                this.m_20153_();
                this.m_6210_();
                this.m_6135_();
                passenger.m_6034_(dismountX, dismountY, dismountZ);
                this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                MoCreatures.LOGGER.info("DOLPHIN_TICK: {} successfully bucked rider off! (rider underwater: {})", (Object)this.m_6095_().m_20676_().getString(), (Object)riderUnderwater);
            }
            if (syncRandom.nextInt(400) == 0) {
                MoCTools.tameWithName(player, this);
                MoCreatures.LOGGER.info("DOLPHIN_TICK: {} RNG taming successful while being ridden!", (Object)this.m_6095_().m_20676_().getString());
            }
        }
    }
}

