/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.aquatic;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAquatic;
import drzhark.mocreatures.init.MoCEntities;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageHeart;
import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class MoCEntityFishy
extends MoCEntityTameableAquatic {
    public static final String[] fishNames = new String[]{"Blue", "Orange", "Light Blue", "Lime", "Green", "Purple", "Yellow", "Cyan", "Striped", "Red"};
    private static final EntityDataAccessor<Boolean> HAS_EATEN = SynchedEntityData.m_135353_(MoCEntityFishy.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int gestationtime;

    public MoCEntityFishy(EntityType<? extends MoCEntityFishy> type, Level world) {
        super((EntityType<? extends MoCEntityTameableAquatic>)type, world);
        this.setAdult(true);
        this.setMoCAge(100);
        this.f_21342_ = new FishMoveControl(this);
    }

    @Override
    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FishSwimGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, 0.5);
    }

    @Override
    public void selectType() {
        if (this.getTypeMoC() == 0) {
            this.setTypeMoC(this.f_19796_.m_188503_(fishNames.length) + 1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getTypeMoC()) {
            case 2: {
                return MoCreatures.proxy.getModelTexture("fishy_orange.png");
            }
            case 3: {
                return MoCreatures.proxy.getModelTexture("fishy_light_blue.png");
            }
            case 4: {
                return MoCreatures.proxy.getModelTexture("fishy_lime.png");
            }
            case 5: {
                return MoCreatures.proxy.getModelTexture("fishy_green.png");
            }
            case 6: {
                return MoCreatures.proxy.getModelTexture("fishy_purple.png");
            }
            case 7: {
                return MoCreatures.proxy.getModelTexture("fishy_yellow.png");
            }
            case 8: {
                return MoCreatures.proxy.getModelTexture("fishy_cyan.png");
            }
            case 9: {
                return MoCreatures.proxy.getModelTexture("fishy_striped.png");
            }
            case 10: {
                return MoCreatures.proxy.getModelTexture("fishy_red.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("fishy_blue.png");
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_EATEN, (Object)Boolean.FALSE);
    }

    @Override
    public boolean getHasEaten() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EATEN);
    }

    @Override
    public void setHasEaten(boolean flag) {
        this.f_19804_.m_135381_(HAS_EATEN, (Object)flag);
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        int i = this.f_19796_.m_188503_(100);
        if (i < 70) {
            Item[] fishTypes = new Item[]{Items.f_42526_, Items.f_42527_, Items.f_42528_};
            Item fish = fishTypes[this.f_19796_.m_188503_(fishTypes.length)];
            this.m_5552_(new ItemStack((ItemLike)fish), 0.0f);
        } else {
            int j = this.f_19796_.m_188503_(2);
            int fishyEggType = this.getTypeMoC();
            ItemStack fishyEgg = new ItemStack((ItemLike)MoCItems.MOC_EGG.get(), j + 1);
            fishyEgg.m_41784_().m_128405_("EggType", fishyEggType);
            this.m_5552_(fishyEgg, 0.0f);
        }
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.FISHY;
    }

    @Override
    public void m_7023_(Vec3 p_27490_) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(0.01f, p_27490_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(p_27490_);
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_204029_(FluidTags.f_13131_)) {
            this.f_20883_ = this.m_146908_();
            this.m_146926_(this.m_146909_());
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.getIsTamed() && this.f_19796_.m_188503_(100) == 0 && this.m_21223_() < this.m_21233_()) {
                this.m_21153_(this.m_21233_());
            }
            if (!this.ReadyforParenting(this)) {
                return;
            }
            int i = 0;
            List list = this.m_9236_().m_6443_(Entity.class, this.m_20191_().m_82377_(4.0, 3.0, 4.0), entity -> entity != this);
            for (Entity entity2 : list) {
                if (!(entity2 instanceof MoCEntityFishy)) continue;
                ++i;
            }
            if (i > 1) {
                list.clear();
                return;
            }
            List list1 = this.m_9236_().m_6443_(Entity.class, this.m_20191_().m_82377_(4.0, 2.0, 4.0), entity -> entity != this);
            for (int k = 0; k < list1.size(); ++k) {
                Entity entity1 = (Entity)list1.get(k);
                if (!(entity1 instanceof MoCEntityFishy) || entity1 == this) continue;
                MoCEntityFishy entityfishy = (MoCEntityFishy)entity1;
                if (!this.ReadyforParenting(this) || !this.ReadyforParenting(entityfishy) || this.getTypeMoC() != entityfishy.getTypeMoC()) continue;
                if (this.f_19796_.m_188503_(100) == 0) {
                    ++this.gestationtime;
                }
                if (this.gestationtime % 3 == 0) {
                    MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageHeart(this.m_19879_()));
                }
                if (this.gestationtime <= 50) continue;
                int l = this.f_19796_.m_188503_(3) + 1;
                for (int i1 = 0; i1 < l; ++i1) {
                    Entity babyEntity = ((EntityType)MoCEntities.FISHY.get()).m_20615_(this.m_9236_());
                    if (!(babyEntity instanceof MoCEntityFishy)) continue;
                    MoCEntityFishy entityfishy1 = (MoCEntityFishy)babyEntity;
                    entityfishy1.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                    this.m_9236_().m_7967_((Entity)entityfishy1);
                    MoCTools.playCustomSound((Entity)this, SoundEvents.f_11752_);
                    this.setHasEaten(false);
                    entityfishy.setHasEaten(false);
                    this.gestationtime = 0;
                    entityfishy.gestationtime = 0;
                    Player entityplayer = this.m_9236_().m_45930_((Entity)this, 24.0);
                    if (entityplayer != null) {
                        MoCTools.tameWithName(entityplayer, entityfishy1);
                    }
                    entityfishy1.setMoCAge(20);
                    entityfishy1.setAdult(false);
                    entityfishy1.setTypeInt(this.getTypeMoC());
                }
                break;
            }
            list.clear();
            list1.clear();
        }
    }

    public boolean ReadyforParenting(MoCEntityFishy entityfishy) {
        return false;
    }

    @Override
    protected boolean canBeTrappedInNet() {
        return true;
    }

    @Override
    public int nameYOffset() {
        return -25;
    }

    @Override
    public float rollRotationOffset() {
        if (!this.m_204029_(FluidTags.f_13131_)) {
            return -90.0f;
        }
        return 0.0f;
    }

    @Override
    protected boolean isFisheable() {
        return !this.getIsTamed();
    }

    @Override
    protected boolean usesNewAI() {
        return true;
    }

    public float m_6113_() {
        return 0.5f;
    }

    @Override
    public boolean isMovementCeased() {
        return !this.m_20069_();
    }

    @Override
    protected double maxDivingDepth() {
        return 2.0;
    }

    @Override
    public float getSizeFactor() {
        return 0.6f;
    }

    @Override
    public float getAdjustedXOffset() {
        if (!this.m_204029_(FluidTags.f_13131_)) {
            return -0.1f;
        }
        return 0.0f;
    }

    @Override
    public float getAdjustedYOffset() {
        if (!this.m_204029_(FluidTags.f_13131_)) {
            return 0.2f;
        }
        return -0.5f;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.65f;
    }

    static class FishMoveControl
    extends MoveControl {
        private final MoCEntityFishy fish;

        FishMoveControl(MoCEntityFishy p_27501_) {
            super((Mob)p_27501_);
            this.fish = p_27501_;
        }

        public void m_8126_() {
            if (this.fish.m_204029_(FluidTags.f_13131_)) {
                this.fish.m_20256_(this.fish.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.fish.m_21573_().m_26571_()) {
                float f = (float)(this.f_24978_ * this.fish.m_21133_(Attributes.f_22279_));
                this.fish.m_7910_(Mth.m_14179_((float)0.125f, (float)this.fish.m_6113_(), (float)f));
                double d0 = this.f_24975_ - this.fish.m_20185_();
                double d1 = this.f_24976_ - this.fish.m_20186_();
                double d2 = this.f_24977_ - this.fish.m_20189_();
                if (d1 != 0.0) {
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    this.fish.m_20256_(this.fish.m_20184_().m_82520_(0.0, (double)this.fish.m_6113_() * (d1 / d3) * 0.1, 0.0));
                }
                if (d0 != 0.0 || d2 != 0.0) {
                    float f1 = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.fish.m_146922_(this.m_24991_(this.fish.m_146908_(), f1, 90.0f));
                    this.fish.f_20883_ = this.fish.m_146908_();
                }
            } else {
                this.fish.m_7910_(0.0f);
            }
        }
    }

    static class FishSwimGoal
    extends RandomSwimmingGoal {
        private final MoCEntityFishy fish;

        public FishSwimGoal(MoCEntityFishy p_27505_) {
            super((PathfinderMob)p_27505_, 1.0, 40);
            this.fish = p_27505_;
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }
    }
}

