/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.aquatic;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAquatic;
import drzhark.mocreatures.init.MoCLootTables;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

public class MoCEntityJellyFish
extends MoCEntityTameableAquatic {
    private static final EntityDataAccessor<Boolean> GLOWS = SynchedEntityData.m_135353_(MoCEntityJellyFish.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int poisoncounter;

    public MoCEntityJellyFish(EntityType<? extends MoCEntityJellyFish> type, Level world) {
        super((EntityType<? extends MoCEntityTameableAquatic>)type, world);
        this.setMoCAge(100);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new EntityAIWanderMoC2((PathfinderMob)this, 0.15, 120));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityTameableAquatic.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.15);
    }

    @Override
    public void selectType() {
        if (this.getTypeMoC() == 0) {
            this.setTypeMoC(this.f_19796_.m_188503_(5) + 1);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GLOWS, (Object)Boolean.FALSE);
    }

    public boolean isGlowing() {
        return (Boolean)this.f_19804_.m_135370_(GLOWS);
    }

    public void setGlowing(boolean flag) {
        this.f_19804_.m_135381_(GLOWS, (Object)flag);
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getTypeMoC()) {
            case 2: {
                return MoCreatures.proxy.getModelTexture("jellyfish_purple_gray.png");
            }
            case 3: {
                return MoCreatures.proxy.getModelTexture("jellyfish_blue_dark.png");
            }
            case 4: {
                return MoCreatures.proxy.getModelTexture("jellyfish_green.png");
            }
            case 5: {
                return MoCreatures.proxy.getModelTexture("jellyfish_orange_red.png");
            }
            case 6: {
                return MoCreatures.proxy.getModelTexture("jellyfish_orange_yellow.png");
            }
            case 7: {
                return MoCreatures.proxy.getModelTexture("jellyfish_blue_speckled.png");
            }
            case 8: {
                return MoCreatures.proxy.getModelTexture("jellyfish_white.png");
            }
            case 9: {
                return MoCreatures.proxy.getModelTexture("jellyfish_purple.png");
            }
            case 10: {
                return MoCreatures.proxy.getModelTexture("jellyfish_orange_light.png");
            }
            case 11: {
                return MoCreatures.proxy.getModelTexture("jellyfish_red.png");
            }
            case 12: {
                return MoCreatures.proxy.getModelTexture("jellyfish_blue_light.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("jellyfish_orange_dark.png");
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            if (this.f_19796_.m_188503_(200) == 0) {
                this.setGlowing(!this.m_9236_().m_46461_());
            }
            if (!this.getIsTamed() && ++this.poisoncounter > 250 && this.shouldAttackPlayers() && this.f_19796_.m_188503_(30) == 0 && MoCTools.findNearPlayerAndPoison((Entity)this, true)) {
                this.poisoncounter = 0;
            }
        }
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12384_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12384_;
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.JELLYFISH;
    }

    @Override
    public float pitchRotationOffset() {
        if (!this.m_20069_()) {
            return 90.0f;
        }
        return 0.0f;
    }

    @Override
    public int nameYOffset() {
        return (int)((double)(this.getMoCAge() * -1) / 2.3);
    }

    @Override
    public float getSizeFactor() {
        float myMoveSpeed = MoCTools.getMyMovementSpeed((Entity)this);
        float pulseSpeed = 0.08f;
        if (myMoveSpeed > 0.0f) {
            pulseSpeed = 0.5f;
        }
        float pulseSize = Mth.m_14089_((float)((float)this.f_19797_ * pulseSpeed)) * 0.2f;
        return (float)this.getMoCAge() * 0.01f + pulseSize / 5.0f;
    }

    @Override
    protected boolean canBeTrappedInNet() {
        return true;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.85f;
    }
}

