/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.aquatic;

import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAquatic;
import drzhark.mocreatures.init.MoCEntities;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MoCEntitySmallFish
extends MoCEntityTameableAquatic {
    public static final String[] fishNames = new String[]{"Anchovy", "Angelfish", "Angler", "Clownfish", "Goldfish", "Hippo Tang", "Mandarinfish"};

    public MoCEntitySmallFish(EntityType<? extends MoCEntitySmallFish> type, Level world) {
        super((EntityType<? extends MoCEntityTameableAquatic>)type, world);
        this.setMoCAge(100);
        this.f_21342_ = new FishMoveControl(this);
    }

    @Override
    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    public static MoCEntitySmallFish createEntity(Level world, int type) {
        if (type == 1) {
            return (MoCEntitySmallFish)((EntityType)MoCEntities.ANCHOVY.get()).m_20615_(world);
        }
        if (type == 2) {
            return (MoCEntitySmallFish)((EntityType)MoCEntities.ANGELFISH.get()).m_20615_(world);
        }
        if (type == 3) {
            return (MoCEntitySmallFish)((EntityType)MoCEntities.ANGLER.get()).m_20615_(world);
        }
        if (type == 4) {
            return (MoCEntitySmallFish)((EntityType)MoCEntities.CLOWNFISH.get()).m_20615_(world);
        }
        if (type == 5) {
            return (MoCEntitySmallFish)((EntityType)MoCEntities.GOLDFISH.get()).m_20615_(world);
        }
        if (type == 6) {
            return (MoCEntitySmallFish)((EntityType)MoCEntities.HIPPOTANG.get()).m_20615_(world);
        }
        if (type == 7) {
            return (MoCEntitySmallFish)((EntityType)MoCEntities.MANDERIN.get()).m_20615_(world);
        }
        return (MoCEntitySmallFish)((EntityType)MoCEntities.CLOWNFISH.get()).m_20615_(world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FishSwimGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityTameableAquatic.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.5);
    }

    @Override
    public void selectType() {
        if (this.getTypeMoC() == 0) {
            this.setTypeMoC(this.f_19796_.m_188503_(fishNames.length) + 1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getTypeMoC()) {
            case 1: {
                return MoCreatures.proxy.getModelTexture("smallfish_anchovy.png");
            }
            case 2: {
                return MoCreatures.proxy.getModelTexture("smallfish_angelfish.png");
            }
            case 3: {
                return MoCreatures.proxy.getModelTexture("smallfish_angler.png");
            }
            case 5: {
                return MoCreatures.proxy.getModelTexture("smallfish_goldfish.png");
            }
            case 6: {
                return MoCreatures.proxy.getModelTexture("smallfish_hippotang.png");
            }
            case 7: {
                return MoCreatures.proxy.getModelTexture("smallfish_manderin.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("smallfish_clownfish.png");
    }

    @Override
    protected boolean canBeTrappedInNet() {
        return true;
    }

    @Override
    public void m_7023_(Vec3 p_27490_) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(0.01f, p_27490_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(p_27490_);
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_() && this.getIsTamed() && this.f_19796_.m_188503_(100) == 0 && this.m_21223_() < this.m_21233_()) {
            this.m_21153_(this.m_21233_());
        }
        if (!this.m_20069_()) {
            this.f_20883_ = this.m_146908_();
            this.m_146926_(this.m_146909_());
        }
    }

    @Override
    public float getSizeFactor() {
        return (float)this.getMoCAge() * 0.01f;
    }

    @Override
    public float getAdjustedYOffset() {
        if (!this.m_20069_()) {
            return 0.5f;
        }
        return 0.3f;
    }

    @Override
    protected boolean isFisheable() {
        return !this.getIsTamed();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float yawRotationOffset() {
        if (!this.m_20069_()) {
            return 90.0f;
        }
        return 90.0f + super.yawRotationOffset();
    }

    @Override
    public float rollRotationOffset() {
        if (!this.m_20069_()) {
            return -90.0f;
        }
        return 0.0f;
    }

    @Override
    public int nameYOffset() {
        return -25;
    }

    @Override
    protected boolean usesNewAI() {
        return true;
    }

    public float m_6113_() {
        return 0.5f;
    }

    @Override
    public boolean isMovementCeased() {
        return !this.m_20069_();
    }

    @Override
    protected double maxDivingDepth() {
        return 2.0;
    }

    @Override
    public int getMaxAge() {
        return 120;
    }

    @Override
    public boolean isNotScared() {
        return this.getIsTamed();
    }

    @Override
    public float getAdjustedZOffset() {
        if (!this.m_20069_()) {
            return 0.1f;
        }
        return 0.0f;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.45f;
    }

    static class FishMoveControl
    extends MoveControl {
        private final MoCEntitySmallFish fish;

        FishMoveControl(MoCEntitySmallFish p_27501_) {
            super((Mob)p_27501_);
            this.fish = p_27501_;
        }

        public void m_8126_() {
            if (this.fish.m_204029_(FluidTags.f_13131_)) {
                this.fish.m_20256_(this.fish.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.fish.m_21573_().m_26571_()) {
                float f = (float)(this.f_24978_ * this.fish.m_21133_(Attributes.f_22279_));
                this.fish.m_7910_(Mth.m_14179_((float)0.125f, (float)this.fish.m_6113_(), (float)f));
                double d0 = this.f_24975_ - this.fish.m_20185_();
                double d1 = this.f_24976_ - this.fish.m_20186_();
                double d2 = this.f_24977_ - this.fish.m_20189_();
                if (d1 != 0.0) {
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    this.fish.m_20256_(this.fish.m_20184_().m_82520_(0.0, (double)this.fish.m_6113_() * (d1 / d3) * 0.1, 0.0));
                }
                if (d0 != 0.0 || d2 != 0.0) {
                    float f1 = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.fish.m_146922_(this.m_24991_(this.fish.m_146908_(), f1, 90.0f));
                    this.fish.f_20883_ = this.fish.m_146908_();
                }
            } else {
                this.fish.m_7910_(0.0f);
            }
        }
    }

    static class FishSwimGoal
    extends RandomSwimmingGoal {
        private final MoCEntitySmallFish fish;

        public FishSwimGoal(MoCEntitySmallFish p_27505_) {
            super((PathfinderMob)p_27505_, 1.0, 40);
            this.fish = p_27505_;
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }
    }
}

