/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hostile;

import com.mojang.authlib.GameProfile;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.item.MoCEntityThrowableRock;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import drzhark.mocreatures.network.message.MoCMessageTwoBytes;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public class MoCEntityGolem
extends MoCEntityMob {
    private static final EntityDataAccessor<Integer> GOLEM_STATE = SynchedEntityData.m_135353_(MoCEntityGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int tCounter;
    private byte[] golemCubes;
    private int dCounter = 0;
    private int sCounter;

    public MoCEntityGolem(EntityType<? extends MoCEntityGolem> type, Level world) {
        super(type, world);
        this.texture = "golem.png";
        this.f_21364_ = 20;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new AIGolemAttack(this, 1.0, true));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new AIGolemTarget<Player>(this, Player.class, true));
        this.f_21346_.m_25352_(3, new AIGolemTarget<IronGolem>(this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MoCEntityMob.createAttributes().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 7.0);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf data) {
        if (this.golemCubes == null) {
            this.initGolemCubes();
        }
        for (int i = 0; i < 23; ++i) {
            data.writeByte((int)this.golemCubes[i]);
        }
    }

    public void readSpawnData(FriendlyByteBuf data) {
        if (this.golemCubes == null) {
            this.golemCubes = new byte[23];
        }
        for (int i = 0; i < 23; ++i) {
            this.golemCubes[i] = data.readByte();
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.initGolemCubes();
        this.f_19804_.m_135372_(GOLEM_STATE, (Object)0);
    }

    public int getGolemState() {
        return (Integer)this.f_19804_.m_135370_(GOLEM_STATE);
    }

    public void setGolemState(int i) {
        this.f_19804_.m_135381_(GOLEM_STATE, (Object)i);
    }

    public void m_8107_() {
        float distanceToTarget;
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            Player entityplayer1;
            if (this.getGolemState() == 0 && (entityplayer1 = this.m_9236_().m_45930_((Entity)this, 8.0)) != null) {
                this.setGolemState(1);
            }
            if (this.getGolemState() == 1 && !this.isMissingCubes()) {
                this.setGolemState(2);
            }
            if (this.getGolemState() > 2 && this.getGolemState() != 4 && this.m_5448_() == null) {
                this.setGolemState(1);
            }
            if (this.getGolemState() > 1 && this.m_5448_() != null && this.f_19796_.m_188503_(20) == 0) {
                if (this.m_21223_() >= 30.0f) {
                    this.setGolemState(2);
                }
                if (this.m_21223_() < 30.0f && this.m_21223_() >= 10.0f) {
                    this.setGolemState(3);
                }
                if (this.m_21223_() < 10.0f) {
                    this.setGolemState(4);
                }
            }
            if (this.getGolemState() != 0 && this.getGolemState() != 4 && this.isMissingCubes()) {
                int freq = 42 - this.getGolemState() * this.m_9236_().m_46791_().m_19028_();
                if (this.getGolemState() == 1) {
                    freq = 20;
                }
                if (this.f_19796_.m_188503_(freq) == 0) {
                    this.acquireRock(2);
                }
            }
            if (this.getGolemState() == 4) {
                this.m_21573_().m_26573_();
                ++this.dCounter;
                if (this.dCounter < 80 && this.f_19796_.m_188503_(3) == 0) {
                    this.acquireRock(4);
                }
                if (this.dCounter == 120) {
                    MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GOLEM_DYING.get(), 3.0f);
                    if (!this.m_9236_().m_5776_()) {
                        ServerLevel serverWorld = (ServerLevel)this.m_9236_();
                        MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 1));
                    }
                }
                if (this.dCounter > 140) {
                    MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GOLEM_EXPLODE.get(), 3.0f);
                    this.destroyGolem();
                }
            }
        }
        if (this.tCounter == 0 && this.m_5448_() != null && this.canShoot() && (distanceToTarget = this.m_20270_((Entity)this.m_5448_())) > 6.0f) {
            this.tCounter = 1;
            if (!this.m_9236_().m_5776_()) {
                ServerLevel serverWorld = (ServerLevel)this.m_9236_();
                MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageAnimation(this.m_19879_(), 0));
            }
        }
        if (this.tCounter != 0) {
            if (this.tCounter++ == 70 && this.m_5448_() != null && this.canShoot() && !this.m_5448_().m_213877_() && this.m_142582_((Entity)this.m_5448_())) {
                this.shootBlock((Entity)this.m_5448_());
            } else if (this.tCounter > 90) {
                this.tCounter = 0;
            }
        }
        if (MoCreatures.proxy.getParticleFX() > 0 && this.getGolemState() == 4 && this.sCounter > 0) {
            for (int i = 0; i < 10; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19796_.m_188583_(), this.f_19796_.m_188583_(), this.f_19796_.m_188583_());
            }
        }
    }

    private void destroyGolem() {
        List<Integer> usedBlocks = this.usedCubes();
        if (!usedBlocks.isEmpty() && MoCTools.mobGriefing(this.m_9236_()) && MoCreatures.proxy.golemDestroyBlocks) {
            for (Integer usedBlock : usedBlocks) {
                Block block = this.generateBlock(this.golemCubes[usedBlock]).m_60734_();
                ItemEntity entityitem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)block, 1));
                entityitem.m_32060_();
                this.m_9236_().m_7967_((Entity)entityitem);
            }
        }
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    @Override
    public boolean isMovementCeased() {
        return this.getGolemState() == 4;
    }

    protected void acquireRock(int type) {
        boolean canDestroyBlock;
        if (this.m_9236_().m_5776_()) {
            return;
        }
        BlockPos blockPos = this.m_20183_();
        BlockState blockState = this.returnRandomCheapBlock();
        boolean bl = canDestroyBlock = MoCTools.mobGriefing(this.m_9236_()) && MoCreatures.proxy.golemDestroyBlocks;
        if (canDestroyBlock) {
            Object[] result = this.destroyRandomBlockAndGetPosition(12.0);
            if (result != null) {
                blockPos = (BlockPos)result[0];
                blockState = (BlockState)result[1];
            } else {
                canDestroyBlock = false;
            }
        }
        if (!canDestroyBlock) {
            blockPos = this.m_20183_();
            blockState = this.returnRandomCheapBlock();
        }
        MoCEntityThrowableRock tRock = MoCEntityThrowableRock.build(this.m_9236_(), (Entity)this, blockPos.m_123341_(), blockPos.m_123342_() + 1, blockPos.m_123343_());
        tRock.setState(blockState);
        tRock.setBehavior(type);
        this.m_9236_().m_7967_((Entity)tRock);
    }

    private BlockState returnRandomCheapBlock() {
        int i = this.f_19796_.m_188503_(4);
        switch (i) {
            case 1: {
                return Blocks.f_50652_.m_49966_();
            }
            case 2: {
                return Blocks.f_50705_.m_49966_();
            }
            case 3: {
                return Blocks.f_50126_.m_49966_();
            }
        }
        return Blocks.f_50493_.m_49966_();
    }

    @Nullable
    private Object[] destroyRandomBlockAndGetPosition(double distance) {
        int l = (int)(distance * distance * distance);
        Level level = this.m_9236_();
        for (int i = 0; i < l; ++i) {
            int x = (int)(this.m_20185_() + (double)level.f_46441_.m_188503_((int)distance) - distance / 2.0);
            int y = (int)(this.m_20186_() + (double)level.f_46441_.m_188503_((int)distance) - distance / 2.0);
            int z = (int)(this.m_20189_() + (double)level.f_46441_.m_188503_((int)distance) - distance / 2.0);
            BlockPos pos = new BlockPos(Mth.m_14143_((float)x), Mth.m_14143_((float)y), Mth.m_14143_((float)z));
            BlockState stateAbove = level.m_8055_(pos.m_7494_());
            BlockState stateTarget = level.m_8055_(pos);
            if ((double)pos.m_123342_() == (double)((int)this.m_20186_()) - 1.0 && pos.m_123341_() == Mth.m_14107_((double)this.m_20185_()) && pos.m_123343_() == Mth.m_14107_((double)this.m_20189_()) || stateTarget.m_60795_() || stateTarget.m_60734_() == Blocks.f_49990_ || stateTarget.m_60734_() == Blocks.f_50752_ || !stateAbove.m_60795_() || !MoCTools.mobGriefing(level)) continue;
            BlockEvent.BreakEvent event = null;
            if (!level.f_46443_) {
                event = new BlockEvent.BreakEvent(level, pos, stateTarget, (Player)FakePlayerFactory.get((ServerLevel)((ServerLevel)level), (GameProfile)MoCreatures.MOCFAKEPLAYER));
            }
            if (event == null || event.isCanceled()) continue;
            level.m_7471_(pos, false);
            return new Object[]{pos, stateTarget};
        }
        return null;
    }

    public void receiveRock(BlockState state) {
        if (!this.m_9236_().m_5776_()) {
            byte myBlock = this.translateOre(state);
            byte slot = (byte)this.getRandomCubeAdj();
            if (slot != -1 && slot < 23 && myBlock != -1 && this.getGolemState() != 4) {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GOLEM_ATTACH.get(), 3.0f);
                int h = this.m_9236_().m_46791_().m_19028_();
                this.m_21153_(this.m_21223_() + (float)h);
                if (this.m_21223_() > this.m_21233_()) {
                    this.m_21153_(this.m_21233_());
                }
                this.saveGolemCube(slot, myBlock);
            } else {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_TURTLE_HURT.get(), 2.0f);
                if (MoCTools.mobGriefing(this.m_9236_()) && MoCreatures.proxy.golemDestroyBlocks) {
                    ItemEntity entityitem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)state.m_60734_(), 1));
                    entityitem.m_32060_();
                    entityitem.lifespan = 1200;
                    this.m_9236_().m_7967_((Entity)entityitem);
                }
            }
        }
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 0) {
            this.tCounter = 1;
        } else if (animationType == 1) {
            this.sCounter = 1;
        }
    }

    private void shootBlock(Entity entity) {
        int baseIndex;
        if (entity == null) {
            return;
        }
        ArrayList<Integer> armBlocks = new ArrayList<Integer>();
        for (int i = 9; i < 15; ++i) {
            if (this.golemCubes[i] == 30) continue;
            armBlocks.add(i);
        }
        if (armBlocks.isEmpty()) {
            return;
        }
        int x = baseIndex = ((Integer)armBlocks.get(this.f_19796_.m_188503_(armBlocks.size()))).intValue();
        if (baseIndex == 9 || baseIndex == 12) {
            if (this.golemCubes[baseIndex + 2] != 30) {
                x = baseIndex + 2;
            } else if (this.golemCubes[baseIndex + 1] != 30) {
                x = baseIndex + 1;
            }
        } else if ((baseIndex == 10 || baseIndex == 13) && this.golemCubes[baseIndex + 1] != 30) {
            x = baseIndex + 1;
        }
        if (this.golemCubes[x] == 30) {
            return;
        }
        BlockState shootState = this.generateBlock(this.golemCubes[x]);
        MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GOLEM_SHOOT.get(), 3.0f);
        MoCTools.throwStone((Entity)this, entity, shootState, 10.0, 0.3);
        this.saveGolemCube((byte)x, (byte)30);
        this.tCounter = 0;
    }

    private boolean canShoot() {
        int x = 0;
        for (int i = 9; i < 15; i = (int)((byte)(i + 1))) {
            if (this.golemCubes[i] == 30) continue;
            ++x;
        }
        return x != 0 && this.getGolemState() != 4 && this.getGolemState() != 1;
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float i) {
        boolean uncoveredChest;
        if (this.getGolemState() == 4) {
            return false;
        }
        List<Integer> missingChestBlocks = this.missingChestCubes();
        boolean bl = uncoveredChest = missingChestBlocks.size() == 4;
        if (!this.openChest() && !uncoveredChest && this.getGolemState() != 1) {
            int j = this.m_9236_().m_46791_().m_19028_();
            if (!this.m_9236_().m_5776_() && this.f_19796_.m_188503_(j) == 0) {
                this.destroyRandomGolemCube();
            } else {
                MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_TURTLE_HURT.get(), 2.0f);
            }
            Entity entity = damagesource.m_7639_();
            if (entity != this && this.m_9236_().m_46791_().m_19028_() > 0 && entity instanceof LivingEntity) {
                this.m_6710_((LivingEntity)entity);
                return true;
            }
            return false;
        }
        if (i > 5.0f) {
            i = 5.0f;
        }
        if (this.getGolemState() != 1 && super.m_6469_(damagesource, i)) {
            Entity entity = damagesource.m_7639_();
            if (entity != this && this.m_9236_().m_46791_().m_19028_() > 0 && entity instanceof LivingEntity) {
                this.m_6710_((LivingEntity)entity);
                return true;
            }
            return false;
        }
        if (this.getGolemState() == 1) {
            Entity entity = damagesource.m_7639_();
            if (entity != this && this.m_9236_().m_46791_().m_19028_() > 0 && entity instanceof LivingEntity) {
                this.m_6710_((LivingEntity)entity);
                return true;
            }
            return false;
        }
        return false;
    }

    private void destroyRandomGolemCube() {
        int i = this.getRandomUsedCube();
        if (i == 4) {
            return;
        }
        int x = i;
        if ((i == 10 || i == 13 || i == 16 || i == 19) && this.golemCubes[i + 1] != 30) {
            x = i + 1;
        }
        if (i == 9 || i == 12 || i == 15 || i == 18) {
            if (this.golemCubes[i + 2] != 30) {
                x = i + 2;
            } else if (this.golemCubes[i + 1] != 30) {
                x = i + 1;
            }
        }
        if (x != -1 && this.golemCubes[x] != 30) {
            Block block = this.generateBlock(this.golemCubes[x]).m_60734_();
            this.saveGolemCube((byte)x, (byte)30);
            MoCTools.playCustomSound((Entity)this, (SoundEvent)MoCSoundEvents.ENTITY_GOLEM_HURT.get(), 3.0f);
            if (MoCTools.mobGriefing(this.m_9236_()) && MoCreatures.proxy.golemDestroyBlocks) {
                ItemEntity entityitem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)block, 1));
                entityitem.m_32060_();
                this.m_9236_().m_7967_((Entity)entityitem);
            }
        }
    }

    @Override
    public float getAdjustedYOffset() {
        if (this.golemCubes[17] != 30 || this.golemCubes[20] != 30) {
            return 0.0f;
        }
        if (this.golemCubes[16] != 30 || this.golemCubes[19] != 30) {
            return 0.4f;
        }
        if (this.golemCubes[15] != 30 || this.golemCubes[18] != 30) {
            return 0.7f;
        }
        if (this.golemCubes[1] != 30 || this.golemCubes[3] != 30) {
            return 0.8f;
        }
        return 1.45f;
    }

    @Override
    public float getSizeFactor() {
        return 1.8f;
    }

    public byte getBlockText(int i) {
        return this.golemCubes[i];
    }

    @Override
    public void m_7380_(CompoundTag nbttagcompound) {
        super.m_7380_(nbttagcompound);
        nbttagcompound.m_128405_("golemState", this.getGolemState());
        ListTag cubeLists = new ListTag();
        for (int i = 0; i < 23; ++i) {
            CompoundTag nbttag = new CompoundTag();
            nbttag.m_128344_("Slot", this.golemCubes[i]);
            cubeLists.add((Object)nbttag);
        }
        nbttagcompound.m_128365_("GolemBlocks", (Tag)cubeLists);
    }

    @Override
    public void m_7378_(CompoundTag nbttagcompound) {
        super.m_7378_(nbttagcompound);
        this.setGolemState(nbttagcompound.m_128451_("golemState"));
        ListTag nbttaglist = nbttagcompound.m_128437_("GolemBlocks", 10);
        for (int i = 0; i < 23; ++i) {
            CompoundTag var4 = nbttaglist.m_128728_(i);
            this.golemCubes[i] = var4.m_128445_("Slot");
        }
    }

    private void initGolemCubes() {
        this.golemCubes = new byte[23];
        for (int i = 0; i < 23; ++i) {
            this.golemCubes[i] = 30;
        }
        int j = this.f_19796_.m_188503_(4);
        switch (j) {
            case 0: {
                j = 7;
                break;
            }
            case 1: {
                j = 11;
                break;
            }
            case 2: {
                j = 15;
                break;
            }
            case 3: {
                j = 21;
            }
        }
        this.saveGolemCube((byte)4, (byte)j);
    }

    public void saveGolemCube(byte slot, byte value) {
        this.golemCubes[slot] = value;
        if (!this.m_9236_().m_5776_() && MoCreatures.proxy.worldInitDone) {
            MoCMessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_())), (Object)new MoCMessageTwoBytes(this.m_19879_(), slot, value));
        }
    }

    private List<Integer> missingCubes() {
        ArrayList<Integer> emptyBlocks = new ArrayList<Integer>();
        for (int i = 0; i < 23; ++i) {
            if (this.golemCubes[i] != 30) continue;
            emptyBlocks.add(i);
        }
        return emptyBlocks;
    }

    public boolean isMissingCubes() {
        for (int i = 0; i < 23; ++i) {
            if (this.golemCubes[i] != 30) continue;
            return true;
        }
        return false;
    }

    private List<Integer> missingChestCubes() {
        ArrayList<Integer> emptyChestBlocks = new ArrayList<Integer>();
        for (int i = 0; i < 4; ++i) {
            if (this.golemCubes[i] != 30) continue;
            emptyChestBlocks.add(i);
        }
        return emptyChestBlocks;
    }

    private List<Integer> usedCubes() {
        ArrayList<Integer> usedBlocks = new ArrayList<Integer>();
        for (int i = 0; i < 23; ++i) {
            if (this.golemCubes[i] == 30) continue;
            usedBlocks.add(i);
        }
        return usedBlocks;
    }

    private int getRandomUsedCube() {
        List<Integer> usedBlocks = this.usedCubes();
        if (usedBlocks.isEmpty()) {
            return -1;
        }
        int randomEmptyBlock = this.f_19796_.m_188503_(usedBlocks.size());
        return usedBlocks.get(randomEmptyBlock);
    }

    private int getRandomMissingCube() {
        List<Integer> emptyChestBlocks = this.missingChestCubes();
        if (!emptyChestBlocks.isEmpty()) {
            int randomEmptyBlock = this.f_19796_.m_188503_(emptyChestBlocks.size());
            return emptyChestBlocks.get(randomEmptyBlock);
        }
        List<Integer> emptyBlocks = this.missingCubes();
        if (emptyBlocks.isEmpty()) {
            return -1;
        }
        int randomEmptyBlock = this.f_19796_.m_188503_(emptyBlocks.size());
        return emptyBlocks.get(randomEmptyBlock);
    }

    private int getRandomCubeAdj() {
        int i = this.getRandomMissingCube();
        if (i == 10 || i == 13 || i == 16 || i == 19) {
            if (this.golemCubes[i - 1] != 30) {
                this.saveGolemCube((byte)i, this.golemCubes[i - 1]);
            }
            return i - 1;
        }
        if (i == 11 || i == 14 || i == 17 || i == 20) {
            if (this.golemCubes[i - 2] == 30 && this.golemCubes[i - 1] == 30) {
                return i - 2;
            }
            if (this.golemCubes[i - 1] != 30) {
                this.saveGolemCube((byte)i, this.golemCubes[i - 1]);
            }
            this.saveGolemCube((byte)(i - 1), this.golemCubes[i - 2]);
            return i - 2;
        }
        return i;
    }

    @Override
    public float rollRotationOffset() {
        int leftLeg = 0;
        int rightLeg = 0;
        if (this.golemCubes[15] != 30) {
            ++leftLeg;
        }
        if (this.golemCubes[16] != 30) {
            ++leftLeg;
        }
        if (this.golemCubes[17] != 30) {
            ++leftLeg;
        }
        if (this.golemCubes[18] != 30) {
            ++rightLeg;
        }
        if (this.golemCubes[19] != 30) {
            ++rightLeg;
        }
        if (this.golemCubes[20] != 30) {
            ++rightLeg;
        }
        return (float)(leftLeg - rightLeg) * 10.0f;
    }

    public boolean openChest() {
        if (this.isMissingCubes()) {
            List list = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(2.0));
            for (Entity entity1 : list) {
                if (!(entity1 instanceof MoCEntityThrowableRock)) continue;
                if (MoCreatures.proxy.getParticleFX() > 0) {
                    MoCreatures.proxy.VacuumFX(this);
                }
                return true;
            }
        }
        return false;
    }

    private byte translateOre(BlockState state) {
        Block block = state.m_60734_();
        if (block == Blocks.f_50069_) {
            return 0;
        }
        if (block == Blocks.f_50493_ || block == Blocks.f_50440_) {
            return 1;
        }
        if (block == Blocks.f_50652_ || block == Blocks.f_50079_) {
            return 2;
        }
        if (block == Blocks.f_50705_) {
            return 3;
        }
        if (block == Blocks.f_49992_) {
            return 4;
        }
        if (block == Blocks.f_49994_) {
            return 5;
        }
        if (block == Blocks.f_49999_ || block == Blocks.f_50010_) {
            return 6;
        }
        if (block == Blocks.f_50074_ || block == Blocks.f_49995_) {
            return 7;
        }
        if (block == Blocks.f_50058_) {
            return 8;
        }
        if (block == Blocks.f_50105_ || block == Blocks.f_50060_) {
            return 9;
        }
        if (block == Blocks.f_50050_) {
            return 10;
        }
        if (block == Blocks.f_50075_ || block == Blocks.f_49996_) {
            return 11;
        }
        if (block == Blocks.f_50076_) {
            return 12;
        }
        if (block == Blocks.f_50080_) {
            return 14;
        }
        if (block == Blocks.f_50090_ || block == Blocks.f_50089_) {
            return 15;
        }
        if (block == Blocks.f_50091_) {
            return 16;
        }
        if (block == Blocks.f_50134_) {
            return 23;
        }
        if (block == Blocks.f_50141_) {
            return 25;
        }
        if (block == Blocks.f_50222_ || block == Blocks.f_50224_) {
            return 26;
        }
        if (block == Blocks.f_50197_) {
            return 27;
        }
        if (block == Blocks.f_50268_ || block == Blocks.f_50264_) {
            return 21;
        }
        if (block == Blocks.f_50133_ || block == Blocks.f_50144_ || block == Blocks.f_50186_) {
            return 22;
        }
        if (block == Blocks.f_50126_ || block == Blocks.f_50354_) {
            return 18;
        }
        if (block == Blocks.f_50128_) {
            return 19;
        }
        if (block == Blocks.f_50129_) {
            return 20;
        }
        return -1;
    }

    private BlockState generateBlock(int golemBlock) {
        switch (golemBlock) {
            case 0: {
                return Blocks.f_50069_.m_49966_();
            }
            case 1: {
                return Blocks.f_50493_.m_49966_();
            }
            case 2: {
                return Blocks.f_50652_.m_49966_();
            }
            case 3: {
                return Blocks.f_50705_.m_49966_();
            }
            case 4: {
                return Blocks.f_49992_.m_49966_();
            }
            case 5: {
                return Blocks.f_49994_.m_49966_();
            }
            case 6: {
                return Blocks.f_49999_.m_49966_();
            }
            case 7: {
                return Blocks.f_50074_.m_49966_();
            }
            case 8: {
                return Blocks.f_50058_.m_49966_();
            }
            case 9: {
                return Blocks.f_50105_.m_49966_();
            }
            case 10: {
                return Blocks.f_50050_.m_49966_();
            }
            case 11: {
                return Blocks.f_50075_.m_49966_();
            }
            case 12: {
                return Blocks.f_50076_.m_49966_();
            }
            case 13: {
                return Blocks.f_50440_.m_49966_();
            }
            case 14: {
                return Blocks.f_50080_.m_49966_();
            }
            case 15: {
                return Blocks.f_50090_.m_49966_();
            }
            case 16: {
                return Blocks.f_50091_.m_49966_();
            }
            case 17: {
                return Blocks.f_50083_.m_49966_();
            }
            case 18: {
                return Blocks.f_50126_.m_49966_();
            }
            case 19: {
                return Blocks.f_50128_.m_49966_();
            }
            case 20: {
                return Blocks.f_50129_.m_49966_();
            }
            case 21: {
                return Blocks.f_50268_.m_49966_();
            }
            case 22: {
                return Blocks.f_50133_.m_49966_();
            }
            case 23: {
                return Blocks.f_50134_.m_49966_();
            }
            case 24: {
                return Blocks.f_50089_.m_49966_();
            }
            case 25: {
                return Blocks.f_50141_.m_49966_();
            }
            case 26: {
                return Blocks.f_50222_.m_49966_();
            }
            case 27: {
                return Blocks.f_50197_.m_49966_();
            }
        }
        return Blocks.f_50440_.m_49966_();
    }

    private int countLegBlocks() {
        int x = 0;
        for (int i = 15; i < 21; i = (int)((byte)(i + 1))) {
            if (this.golemCubes[i] == 30) continue;
            ++x;
        }
        return x;
    }

    public float m_6113_() {
        return 0.15f * ((float)this.countLegBlocks() / 6.0f);
    }

    public ResourceLocation getEffectTexture() {
        switch (this.getGolemState()) {
            case 1: {
                return MoCreatures.proxy.getModelTexture("golem_effect_red.png");
            }
            case 2: {
                return MoCreatures.proxy.getModelTexture("golem_effect_yellow.png");
            }
            case 3: {
                return MoCreatures.proxy.getModelTexture("golem_effect_orange.png");
            }
            case 4: {
                return MoCreatures.proxy.getModelTexture("golem_effect_blue.png");
            }
        }
        return null;
    }

    public float colorFX(int i) {
        switch (this.getGolemState()) {
            case 1: {
                if (i == 1) {
                    return 0.25490198f;
                }
                if (i == 2) {
                    return 0.6156863f;
                }
                if (i == 3) {
                    return 0.99607843f;
                }
            }
            case 2: {
                if (i == 1) {
                    return 0.95686275f;
                }
                if (i == 2) {
                    return 0.972549f;
                }
                if (i == 3) {
                    return 0.14117648f;
                }
            }
            case 3: {
                if (i == 1) {
                    return 1.0f;
                }
                if (i == 2) {
                    return 0.6039216f;
                }
                if (i == 3) {
                    return 0.08235294f;
                }
            }
            case 4: {
                if (i == 1) {
                    return 0.972549f;
                }
                if (i == 2) {
                    return 0.039215688f;
                }
                if (i != 3) break;
                return 0.039215688f;
            }
        }
        return 0.0f;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)MoCSoundEvents.ENTITY_GOLEM_WALK.get(), 1.0f, 1.0f);
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)MoCSoundEvents.ENTITY_GOLEM_AMBIENT.get();
    }

    protected ResourceLocation m_7582_() {
        return MoCLootTables.BIG_GOLEM;
    }

    public static boolean getCanSpawnHere(EntityType<? extends MoCEntityMob> type, ServerLevel world, MobSpawnType reason, BlockPos pos, Random randomIn) {
        return MoCEntityMob.getCanSpawnHere(type, world, reason, pos, randomIn);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_20206_() * 0.8f;
    }

    static class AIGolemAttack
    extends MeleeAttackGoal {
        public AIGolemAttack(MoCEntityGolem golem, double speed, boolean useLongMemory) {
            super((PathfinderMob)golem, speed, useLongMemory);
        }

        public boolean m_8045_() {
            float f = this.f_25540_.m_213856_();
            if (f >= 0.5f && this.f_25540_.m_217043_().m_188503_(100) == 0) {
                this.f_25540_.m_6710_(null);
                return false;
            }
            return super.m_8045_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }
    }

    static class AIGolemTarget<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public AIGolemTarget(MoCEntityGolem golem, Class<T> classTarget, boolean checkSight) {
            super((Mob)golem, classTarget, checkSight);
        }

        public boolean m_8036_() {
            float f = this.f_26135_.m_213856_();
            return !(f >= 0.5f) && super.m_8036_();
        }
    }
}

